/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fmc.blockdiagram.editor.diagram;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.fmc.blockdiagram.editor.extension.CompositeFeatureProvider;
import org.eclipse.fmc.blockdiagram.editor.extension.FeatureProviderExtensionFactory;
import org.eclipse.fmc.blockdiagram.editor.features.ContainerTextDirectEditingFeature;
import org.eclipse.fmc.blockdiagram.editor.features.DeepRemoveFeature;
import org.eclipse.fmc.blockdiagram.editor.features.DotsConnectionRemoveFeature;
import org.eclipse.fmc.blockdiagram.editor.features.ReconnectionFeature;
import org.eclipse.fmc.blockdiagram.editor.features.ShapeCopyFeature;
import org.eclipse.fmc.blockdiagram.editor.features.ShapeMoveFeature;
import org.eclipse.fmc.blockdiagram.editor.features.ShapePasteFeature;
import org.eclipse.fmc.blockdiagram.editor.features.TextDirectEditingFeature;
import org.eclipse.fmc.blockdiagram.editor.features.add.AccessAddFeature;
import org.eclipse.fmc.blockdiagram.editor.features.add.AgentAddFeature;
import org.eclipse.fmc.blockdiagram.editor.features.add.AnchorAddFeature;
import org.eclipse.fmc.blockdiagram.editor.features.add.AreaBorderAddFeature;
import org.eclipse.fmc.blockdiagram.editor.features.add.BraceAddFeature;
import org.eclipse.fmc.blockdiagram.editor.features.add.CommonFeatureAreaAddFeature;
import org.eclipse.fmc.blockdiagram.editor.features.add.CommunicationChannelAddFeature;
import org.eclipse.fmc.blockdiagram.editor.features.add.DotsConnectionAddFeature;
import org.eclipse.fmc.blockdiagram.editor.features.add.DotsShapeAddFeature;
import org.eclipse.fmc.blockdiagram.editor.features.add.HumanAgentAddFeature;
import org.eclipse.fmc.blockdiagram.editor.features.add.ImageAddFeature;
import org.eclipse.fmc.blockdiagram.editor.features.add.InvisibleShapeAddFeature;
import org.eclipse.fmc.blockdiagram.editor.features.add.StorageAddFeature;
import org.eclipse.fmc.blockdiagram.editor.features.add.StructureVarianceAddFeature;
import org.eclipse.fmc.blockdiagram.editor.features.add.TextAddFeature;
import org.eclipse.fmc.blockdiagram.editor.features.create.ConnectionCreateFeature;
import org.eclipse.fmc.blockdiagram.editor.features.create.ShapeCreateFeature;
import org.eclipse.fmc.blockdiagram.editor.features.custom.AddTextToConnectionCustomFeature;
import org.eclipse.fmc.blockdiagram.editor.features.custom.BringToFrontCustomFeature;
import org.eclipse.fmc.blockdiagram.editor.features.custom.CopyToClipboardCustomFeature;
import org.eclipse.fmc.blockdiagram.editor.features.custom.FlipHorizontallyCustomFeature;
import org.eclipse.fmc.blockdiagram.editor.features.custom.FlipVerticallyCustomFeature;
import org.eclipse.fmc.blockdiagram.editor.features.custom.HideContentCustomFeature;
import org.eclipse.fmc.blockdiagram.editor.features.custom.LayoutConnectionCustomFeature;
import org.eclipse.fmc.blockdiagram.editor.features.custom.PaintFormatCustomFeature;
import org.eclipse.fmc.blockdiagram.editor.features.custom.RotateCustomFeature;
import org.eclipse.fmc.blockdiagram.editor.features.custom.SendToBackCustomFeature;
import org.eclipse.fmc.blockdiagram.editor.features.custom.UnhideContentCustomFeature;
import org.eclipse.fmc.blockdiagram.editor.features.resize.AreaBorderResizeFeature;
import org.eclipse.fmc.blockdiagram.editor.features.resize.BraceResizeFeature;
import org.eclipse.fmc.blockdiagram.editor.features.resize.ChannelResizeFeature;
import org.eclipse.fmc.blockdiagram.editor.features.resize.ContainerResizeFeature;
import org.eclipse.fmc.blockdiagram.editor.features.resize.DotsShapeResizeFeature;
import org.eclipse.fmc.blockdiagram.editor.features.resize.FMCNodeResizeFeature;
import org.eclipse.fmc.blockdiagram.editor.features.resize.ResizeFeature;
import org.eclipse.fmc.blockdiagram.editor.model.ConnectionStyle;
import org.eclipse.fmc.blockdiagram.editor.model.FMCType;
import org.eclipse.fmc.blockdiagram.editor.model.FMCTypeChecker;
import org.eclipse.fmc.blockdiagram.editor.model.FMCTypeCheckerFactory;
import org.eclipse.fmc.blockdiagram.editor.model.ShapeStyle;
import org.eclipse.graphiti.dt.IDiagramTypeProvider;
import org.eclipse.graphiti.features.IAddFeature;
import org.eclipse.graphiti.features.ICopyFeature;
import org.eclipse.graphiti.features.ICreateConnectionFeature;
import org.eclipse.graphiti.features.ICreateFeature;
import org.eclipse.graphiti.features.IDeleteFeature;
import org.eclipse.graphiti.features.IDirectEditingFeature;
import org.eclipse.graphiti.features.IFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.ILayoutFeature;
import org.eclipse.graphiti.features.IMoveShapeFeature;
import org.eclipse.graphiti.features.IPasteFeature;
import org.eclipse.graphiti.features.IReconnectionFeature;
import org.eclipse.graphiti.features.IRemoveFeature;
import org.eclipse.graphiti.features.IResizeShapeFeature;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.ICopyContext;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.features.context.IDeleteContext;
import org.eclipse.graphiti.features.context.IDirectEditingContext;
import org.eclipse.graphiti.features.context.ILayoutContext;
import org.eclipse.graphiti.features.context.IMoveShapeContext;
import org.eclipse.graphiti.features.context.IPasteContext;
import org.eclipse.graphiti.features.context.IPictogramElementContext;
import org.eclipse.graphiti.features.context.IReconnectionContext;
import org.eclipse.graphiti.features.context.IRemoveContext;
import org.eclipse.graphiti.features.context.IResizeShapeContext;
import org.eclipse.graphiti.features.custom.ICustomFeature;
import org.eclipse.graphiti.features.impl.DefaultMoveShapeFeature;
import org.eclipse.graphiti.features.impl.IIndependenceSolver;
import org.eclipse.graphiti.mm.algorithms.MultiText;
import org.eclipse.graphiti.mm.algorithms.Text;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.ui.editor.DiagramBehavior;
import org.eclipse.graphiti.ui.features.DefaultFeatureProvider;

public class BlockDiagramFeatureProvider
extends DefaultFeatureProvider {
    private static final String MOUSE_Y = "mouseY";
    private static final String MOUSE_X = "mouseX";
    private static final String CLASS_EXTENSION = "class";
    private static final String FEATUREPROVIDER_EXTENSIONPOINT_ID = "org.eclipse.fmc.blockdiagram.editor.featureprovider";
    public static final int CREATE_FEATURE_AGENT = 0;
    public static final int CREATE_FEATURE_AGENT_L = 1;
    public static final int CREATE_FEATURE_AGENT_U = 2;
    public static final int CREATE_FEATURE_STORAGE = 3;
    public static final int CREATE_FEATURE_STORAGE_L = 4;
    public static final int CREATE_FEATURE_STORAGE_U = 5;
    public static final int CREATE_FEATURE_HUMAN_AGENT = 6;
    public static final int CREATE_FEATURE_STRUCTURE_VARIANCE = 7;
    public static final int CREATE_FEATURE_TEXT = 8;
    public static final int CREATE_FEATURE_COMMON_FEATURE_AREA = 9;
    public static final int CREATE_FEATURE_BRACE = 10;
    public static final int CREATE_FEATURE_AREA_BORDER = 11;
    public static final int CREATE_FEATURE_DOTS = 12;
    public static final int CREATE_FEATURE_ANCHOR = 13;
    public static final int CREATE_CON_UNI_ACCESS_MH = 1;
    public static final int CREATE_CON_UNI_ACCESS_FF = 2;
    public static final int CREATE_CON_BI_ACCESS_MH = 3;
    public static final int CREATE_CON_BI_ACCESS_FF = 4;
    public static final int CREATE_CON_MODIFY_ACCESS = 0;
    public static final int CREATE_CON_BI_COMM_CH_MH = 5;
    public static final int CREATE_CON_BI_COMM_CH_FF = 6;
    public static final int CREATE_CON_UNI_COMM_CH_MH = 7;
    public static final int CREATE_CON_UNI_COMM_CH_FF = 8;
    public static final int CREATE_CON_REQRESP_COMM_CH_MH = 9;
    public static final int CREATE_CON_REQRESP_COMM_CH_FF = 10;
    public static final int CREATE_CON_DOTS_MH = 12;
    public static final int CREATE_CON_DOTS_FF = 11;
    protected FMCTypeChecker typeChecker = FMCTypeCheckerFactory.getInstance();
    protected PaintFormatCustomFeature paintFormatFeature;
    protected CompositeFeatureProvider compositeFP;

    public BlockDiagramFeatureProvider(IDiagramTypeProvider diagramTypeProvider) {
        super(diagramTypeProvider);
        this.compositeFP = new CompositeFeatureProvider(diagramTypeProvider);
        try {
            this.addFeatureProvidersFromExtensionPoint(diagramTypeProvider);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        this.setIndependenceSolver(new IIndependenceSolver(){

            public String getKeyForBusinessObject(Object bo) {
                if (bo instanceof FMCType) {
                    FMCType type = (FMCType)((Object)bo);
                    return type.name();
                }
                return null;
            }

            public Object getBusinessObjectForKey(String key) {
                return FMCType.valueOf(key);
            }
        });
    }

    public IFeature[] getDragAndDropFeatures(IPictogramElementContext context) {
        return super.getCreateConnectionFeatures();
    }

    public IAddFeature getAddFeature(IAddContext context) {
        switch ((FMCType)((Object)context.getNewObject())) {
            case Agent: {
                ShapeStyle style = (ShapeStyle)((Object)context.getProperty((Object)"graphicalType"));
                return new AgentAddFeature((IFeatureProvider)this, style);
            }
            case HumanAgent: {
                return new HumanAgentAddFeature((IFeatureProvider)this);
            }
            case Storage: {
                ShapeStyle style = (ShapeStyle)((Object)context.getProperty((Object)"graphicalType"));
                return new StorageAddFeature((IFeatureProvider)this, style);
            }
            case StructureVariance: {
                return new StructureVarianceAddFeature((IFeatureProvider)this);
            }
            case UnidirectionalAccess: 
            case BidirectionalAccess: 
            case ModifyAccess: {
                return new AccessAddFeature((IFeatureProvider)this, (ConnectionStyle)((Object)context.getProperty((Object)"graphicalType")));
            }
            case UnidirectionalCommChannel: 
            case BidirectionalCommChannel: 
            case ReqRespCommChannel: {
                return new CommunicationChannelAddFeature((IFeatureProvider)this, (ConnectionStyle)((Object)context.getProperty((Object)"graphicalType")));
            }
            case Dots: {
                return new DotsConnectionAddFeature((IFeatureProvider)this, (ConnectionStyle)((Object)context.getProperty((Object)"graphicalType")));
            }
            case DotsShape: {
                return new DotsShapeAddFeature((IFeatureProvider)this);
            }
            case Image: {
                return new ImageAddFeature((IFeatureProvider)this, context.getProperty((Object)"imageid").toString());
            }
            case Text: {
                return new TextAddFeature((IFeatureProvider)this);
            }
            case CommonFeatureArea: {
                return new CommonFeatureAreaAddFeature((IFeatureProvider)this);
            }
            case Brace: {
                return new BraceAddFeature((IFeatureProvider)this);
            }
            case AreaBorder: {
                return new AreaBorderAddFeature((IFeatureProvider)this);
            }
            case Invisible: {
                return new InvisibleShapeAddFeature((IFeatureProvider)this);
            }
            case Anchor: {
                return new AnchorAddFeature((IFeatureProvider)this);
            }
        }
        return this.compositeFP.getAddFeature(context);
    }

    public void link(PictogramElement pictogramElement, Object businessObject) {
        super.link(pictogramElement, businessObject);
    }

    public ICreateFeature[] getCreateFeatures() {
        ICreateFeature[] features = new ICreateFeature[]{new ShapeCreateFeature((IFeatureProvider)this, "Agent", "Agent", (Object)FMCType.Agent, "org.eclipse.fmc.IconAgent"), new ShapeCreateFeature((IFeatureProvider)this, "Agent L", "Agent L", (Object)FMCType.Agent, ShapeStyle.L, "org.eclipse.fmc.IconAgent_L"), new ShapeCreateFeature((IFeatureProvider)this, "Agent U", "Agent U", (Object)FMCType.Agent, ShapeStyle.U, "org.eclipse.fmc.IconAgent_U"), new ShapeCreateFeature((IFeatureProvider)this, "Storage", "Storage", (Object)FMCType.Storage, "org.eclipse.fmc.IconStorage"), new ShapeCreateFeature((IFeatureProvider)this, "Storage_L", "Storage_L", (Object)FMCType.Storage, ShapeStyle.L, "org.eclipse.fmc.IconStorage_L"), new ShapeCreateFeature((IFeatureProvider)this, "Storage_U", "Storage_U", (Object)FMCType.Storage, ShapeStyle.U, "org.eclipse.fmc.IconStorage_U"), new ShapeCreateFeature((IFeatureProvider)this, "HumanAgent", "HumanAgent", (Object)FMCType.HumanAgent, "org.eclipse.fmc.IconHumanAgent"), new ShapeCreateFeature((IFeatureProvider)this, "StructureVariance", "StructureVariance", (Object)FMCType.StructureVariance, "org.eclipse.fmc.IconStructureVariance"), new ShapeCreateFeature((IFeatureProvider)this, "Text", "", (Object)FMCType.Text, "org.eclipse.fmc.Text"), new ShapeCreateFeature((IFeatureProvider)this, "Common Feature Area", "", (Object)FMCType.CommonFeatureArea, "org.eclipse.fmc.IconCommonFeatureArea"), new ShapeCreateFeature((IFeatureProvider)this, "Brace", "", (Object)FMCType.Brace, "org.eclipse.fmc.IconBrace"), new ShapeCreateFeature((IFeatureProvider)this, "AreaBorder", "", (Object)FMCType.AreaBorder, "org.eclipse.fmc.IconAreaBorder"), new ShapeCreateFeature((IFeatureProvider)this, "Dots", "", (Object)FMCType.DotsShape, "org.eclipse.fmc.Dots"), new ShapeCreateFeature((IFeatureProvider)this, "Anchor", "", (Object)FMCType.Anchor, "org.eclipse.fmc.Anchor")};
        return features;
    }

    public ICreateConnectionFeature[] getCreateConnectionFeatures() {
        return new ICreateConnectionFeature[]{new ConnectionCreateFeature((IFeatureProvider)this, "Modify Access", "", (Object)FMCType.ModifyAccess, ConnectionStyle.COMPOSITE, "org.eclipse.fmc.IconModifyAccess"), new ConnectionCreateFeature((IFeatureProvider)this, "Unidirectional Access", "", (Object)FMCType.UnidirectionalAccess, ConnectionStyle.MANHATTAN, "org.eclipse.fmc.IconUnidirectionalAccessMh"), new ConnectionCreateFeature((IFeatureProvider)this, "Unidirectional Access", "", (Object)FMCType.UnidirectionalAccess, ConnectionStyle.NORMAL, "org.eclipse.fmc.IconUnidirectionalAccess"), new ConnectionCreateFeature((IFeatureProvider)this, "Bidirectional Access", "", (Object)FMCType.BidirectionalAccess, ConnectionStyle.MANHATTAN, "org.eclipse.fmc.IconBidirectionalAccessMh"), new ConnectionCreateFeature((IFeatureProvider)this, "Bidirectional Access", "", (Object)FMCType.BidirectionalAccess, ConnectionStyle.NORMAL, "org.eclipse.fmc.IconBidirectionalAccess"), new ConnectionCreateFeature((IFeatureProvider)this, "Bidirectional Communication Channel", "", (Object)FMCType.BidirectionalCommChannel, ConnectionStyle.MANHATTAN, "org.eclipse.fmc.IconBidirectionalCommunicationChannelMh"), new ConnectionCreateFeature((IFeatureProvider)this, "Bidirectional Communication Channel", "", (Object)FMCType.BidirectionalCommChannel, ConnectionStyle.NORMAL, "org.eclipse.fmc.IconBidirectionalCommunicationChannel"), new ConnectionCreateFeature((IFeatureProvider)this, "Unidirectional Communication Channel", "", (Object)FMCType.UnidirectionalCommChannel, ConnectionStyle.MANHATTAN, "org.eclipse.fmc.IconUnidirectionalCommunicationChannelMh"), new ConnectionCreateFeature((IFeatureProvider)this, "Unidirectional Communication Channel", "", (Object)FMCType.UnidirectionalCommChannel, ConnectionStyle.NORMAL, "org.eclipse.fmc.IconUnidirectionalCommunicationChannel"), new ConnectionCreateFeature((IFeatureProvider)this, "Request-Response Communication Channel", "", (Object)FMCType.ReqRespCommChannel, ConnectionStyle.MANHATTAN, "org.eclipse.fmc.IconRequestResponseCommunicationChannelMh"), new ConnectionCreateFeature((IFeatureProvider)this, "Request-Response Communication Channel", "", (Object)FMCType.ReqRespCommChannel, ConnectionStyle.NORMAL, "org.eclipse.fmc.IconRequestResponseCommunicationChannel"), new ConnectionCreateFeature((IFeatureProvider)this, "Dots", "", (Object)FMCType.Dots, ConnectionStyle.NORMAL, "org.eclipse.fmc.Dots"), new ConnectionCreateFeature((IFeatureProvider)this, "Dots", "", (Object)FMCType.Dots, ConnectionStyle.MANHATTAN, "org.eclipse.fmc.DotsMh")};
    }

    public IMoveShapeFeature getMoveShapeFeature(IMoveShapeContext context) {
        PictogramElement container = (PictogramElement)context.getPictogramElement().eContainer();
        if (this.typeChecker.isHumanAgent(container) && !this.typeChecker.isFMCNode(context.getPictogramElement()) && !this.typeChecker.isComment(context.getPictogramElement())) {
            return new DefaultMoveShapeFeature((IFeatureProvider)this);
        }
        return new ShapeMoveFeature((IFeatureProvider)this);
    }

    public IDirectEditingFeature getDirectEditingFeature(IDirectEditingContext context) {
        if (context.getGraphicsAlgorithm() instanceof Text || context.getGraphicsAlgorithm() instanceof MultiText) {
            return new TextDirectEditingFeature((IFeatureProvider)this);
        }
        if (!this.typeChecker.isBrace(context.getPictogramElement()) && context.getPictogramElement() instanceof ContainerShape) {
            return new ContainerTextDirectEditingFeature((IFeatureProvider)this);
        }
        return super.getDirectEditingFeature(context);
    }

    public IResizeShapeFeature getResizeShapeFeature(IResizeShapeContext context) {
        PictogramElement container = (PictogramElement)context.getPictogramElement().eContainer();
        if (this.typeChecker.isHumanAgent(container) && !this.typeChecker.isFMCNode(context.getPictogramElement()) && !this.typeChecker.isComment(context.getPictogramElement())) {
            return null;
        }
        if (this.typeChecker.isBrace(context.getPictogramElement())) {
            return new BraceResizeFeature((IFeatureProvider)this);
        }
        if (this.typeChecker.isAreaBorder(context.getPictogramElement())) {
            return new AreaBorderResizeFeature((IFeatureProvider)this);
        }
        if (this.typeChecker.isDots(context.getPictogramElement())) {
            return new DotsShapeResizeFeature((IFeatureProvider)this);
        }
        if (this.typeChecker.isCommunicationChannel(context.getPictogramElement())) {
            return new ChannelResizeFeature((IFeatureProvider)this);
        }
        if (this.typeChecker.isHumanAgent(context.getPictogramElement())) {
            return new ContainerResizeFeature((IFeatureProvider)this);
        }
        if (this.typeChecker.isAgent(context.getPictogramElement()) || this.typeChecker.isStorage(context.getPictogramElement()) || this.typeChecker.isStructureVariance(context.getPictogramElement())) {
            return new FMCNodeResizeFeature((IFeatureProvider)this);
        }
        return new ResizeFeature((IFeatureProvider)this);
    }

    public IRemoveFeature getRemoveFeature(IRemoveContext context) {
        if (context.getPictogramElement() instanceof Connection && this.typeChecker.isDots(context.getPictogramElement())) {
            return new DotsConnectionRemoveFeature((IFeatureProvider)this);
        }
        return new DeepRemoveFeature((IFeatureProvider)this);
    }

    public IDeleteFeature getDeleteFeature(IDeleteContext context) {
        return null;
    }

    public IReconnectionFeature getReconnectionFeature(IReconnectionContext context) {
        return new ReconnectionFeature((IFeatureProvider)this);
    }

    public ILayoutFeature getLayoutFeature(ILayoutContext context) {
        return super.getLayoutFeature(context);
    }

    public ICustomFeature[] getCustomFeatures(ICustomContext context) {
        ICustomFeature[] ret = super.getCustomFeatures(context);
        ArrayList<Object> retList = new ArrayList<Object>();
        int i = 0;
        while (i < ret.length) {
            retList.add(ret[i]);
            ++i;
        }
        retList.add((Object)new CopyToClipboardCustomFeature((IFeatureProvider)this));
        retList.add((Object)new BringToFrontCustomFeature((IFeatureProvider)this));
        retList.add((Object)new SendToBackCustomFeature((IFeatureProvider)this));
        retList.add((Object)new LayoutConnectionCustomFeature((IFeatureProvider)this));
        retList.add((Object)new AddTextToConnectionCustomFeature((IFeatureProvider)this));
        if (this.paintFormatFeature == null) {
            this.paintFormatFeature = new PaintFormatCustomFeature((IFeatureProvider)this);
        }
        retList.add((Object)this.paintFormatFeature);
        retList.add((Object)new RotateCustomFeature((IFeatureProvider)this));
        retList.add((Object)new FlipHorizontallyCustomFeature((IFeatureProvider)this));
        retList.add((Object)new FlipVerticallyCustomFeature((IFeatureProvider)this));
        retList.add((Object)new HideContentCustomFeature((IFeatureProvider)this));
        retList.add((Object)new UnhideContentCustomFeature((IFeatureProvider)this));
        retList.addAll(Arrays.asList(this.compositeFP.getCustomFeatures(context)));
        ret = retList.toArray(ret);
        return ret;
    }

    public ICopyFeature getCopyFeature(ICopyContext context) {
        return new ShapeCopyFeature((IFeatureProvider)this);
    }

    public IPasteFeature getPasteFeature(IPasteContext context) {
        DiagramBehavior diagramBehavior = (DiagramBehavior)this.getDiagramTypeProvider().getDiagramBehavior();
        Point mouseLoc = diagramBehavior.getMouseLocation();
        context.putProperty((Object)MOUSE_X, (Object)mouseLoc.x());
        context.putProperty((Object)MOUSE_Y, (Object)mouseLoc.y());
        return new ShapePasteFeature((IFeatureProvider)this);
    }

    private void addFeatureProvidersFromExtensionPoint(IDiagramTypeProvider diagramTypeProvider) throws CoreException {
        IConfigurationElement[] extensions;
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = extensions = reg.getConfigurationElementsFor(FEATUREPROVIDER_EXTENSIONPOINT_ID);
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            FeatureProviderExtensionFactory entry = (FeatureProviderExtensionFactory)element.createExecutableExtension(CLASS_EXTENSION);
            this.compositeFP.addFeatureProvider(entry.createFeatureProviderExtension(diagramTypeProvider));
            ++n2;
        }
    }
}

