/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fmc.blockdiagram.editor.features;

import org.eclipse.graphiti.features.IDirectEditingFeature;
import org.eclipse.graphiti.features.IDirectEditingInfo;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.features.context.IDirectEditingContext;
import org.eclipse.graphiti.features.context.impl.DirectEditingContext;
import org.eclipse.graphiti.features.custom.AbstractCustomFeature;
import org.eclipse.graphiti.mm.algorithms.AbstractText;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;

public class DirectEditingDoubleclickFeature
extends AbstractCustomFeature {
    public DirectEditingDoubleclickFeature(IFeatureProvider featureProvider) {
        super(featureProvider);
    }

    public boolean canExecute(ICustomContext context) {
        if (context.getPictogramElements().length == 1 && context.getPictogramElements()[0] instanceof Shape) {
            PictogramElement element = context.getPictogramElements()[0];
            DirectEditingContext ctx = new DirectEditingContext(element, element.getGraphicsAlgorithm());
            IDirectEditingFeature directEditingFeature = this.getFeatureProvider().getDirectEditingFeature((IDirectEditingContext)ctx);
            return directEditingFeature != null;
        }
        return false;
    }

    public void execute(ICustomContext context) {
        if (context.getPictogramElements().length > 0 && context.getPictogramElements()[0] instanceof ContainerShape) {
            ContainerShape element = (ContainerShape)context.getPictogramElements()[0];
            AbstractText text = this.findTextInContainer(element);
            this.editText((PictogramElement)element, text);
        } else if (context.getPictogramElements().length > 0 && context.getPictogramElements()[0].getGraphicsAlgorithm() instanceof AbstractText) {
            PictogramElement element = context.getPictogramElements()[0];
            this.editText(element, (AbstractText)element.getGraphicsAlgorithm());
        }
    }

    private void editText(PictogramElement element, AbstractText text) {
        IDirectEditingInfo directEditingInfo = this.getFeatureProvider().getDirectEditingInfo();
        directEditingInfo.setMainPictogramElement(element);
        directEditingInfo.setGraphicsAlgorithm((GraphicsAlgorithm)text);
        if (text != null) {
            directEditingInfo.setPictogramElement(text.getPictogramElement() != null ? text.getPictogramElement() : element);
        }
        directEditingInfo.setActive(true);
        this.getDiagramBehavior().refresh();
    }

    private AbstractText findTextInContainer(ContainerShape container) {
        for (Shape shape : container.getChildren()) {
            if (shape instanceof ContainerShape) {
                for (Shape nested : ((ContainerShape)shape).getChildren()) {
                    if (!(nested.getGraphicsAlgorithm() instanceof AbstractText)) continue;
                    return this.findTextInGraphicsAlgorithm(nested);
                }
            }
            if (!(shape.getGraphicsAlgorithm() instanceof AbstractText)) continue;
            return this.findTextInGraphicsAlgorithm(shape);
        }
        return this.findTextInGraphicsAlgorithm((Shape)container);
    }

    private AbstractText findTextInGraphicsAlgorithm(Shape shape) {
        if (shape.getGraphicsAlgorithm() instanceof AbstractText) {
            return (AbstractText)shape.getGraphicsAlgorithm();
        }
        if (shape.getGraphicsAlgorithm() != null) {
            for (GraphicsAlgorithm algoChild : shape.getGraphicsAlgorithm().getGraphicsAlgorithmChildren()) {
                if (!(algoChild instanceof AbstractText)) continue;
                return (AbstractText)algoChild;
            }
            return null;
        }
        return null;
    }
}

