/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fmc.blockdiagram.editor.features;

import org.eclipse.fmc.blockdiagram.editor.features.create.ConnectionCreateFeature;
import org.eclipse.fmc.blockdiagram.editor.model.ConnectionStyle;
import org.eclipse.fmc.blockdiagram.editor.model.FMCType;
import org.eclipse.fmc.blockdiagram.editor.util.FMCUtil;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.ICreateConnectionContext;
import org.eclipse.graphiti.features.context.IReconnectionContext;
import org.eclipse.graphiti.features.context.impl.CreateConnectionContext;
import org.eclipse.graphiti.features.context.impl.ReconnectionContext;
import org.eclipse.graphiti.features.impl.DefaultReconnectionFeature;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;

public class ReconnectionFeature
extends DefaultReconnectionFeature {
    public ReconnectionFeature(IFeatureProvider fp) {
        super(fp);
    }

    public boolean canReconnect(IReconnectionContext context) {
        Shape shape;
        Shape s;
        Connection con = context.getConnection();
        FMCType model = FMCUtil.getIndependentObject((PictogramElement)con);
        if (model == null) {
            model = FMCUtil.getBO((PictogramElement)con);
        }
        ConnectionCreateFeature feature = null;
        feature = new ConnectionCreateFeature(this.getFeatureProvider(), "", "", (Object)model, ConnectionStyle.NORMAL, null);
        CreateConnectionContext ctx = new CreateConnectionContext();
        if (context.getTargetPictogramElement() instanceof Shape && (s = ConnectionCreateFeature.getShapeBehindTextOrPicture((Shape)context.getTargetPictogramElement())) != null && !s.getAnchors().isEmpty()) {
            context.setTargetPictogramElement((PictogramElement)s);
            ((ReconnectionContext)context).setNewAnchor((Anchor)s.getAnchors().get(0));
        }
        if (context.getOldAnchor() != null && context.getOldAnchor().eContainer() instanceof Shape && !(shape = (Shape)context.getOldAnchor().eContainer()).isVisible()) {
            return true;
        }
        if (ReconnectionContext.RECONNECT_SOURCE.equals(context.getReconnectType())) {
            ctx.setSourceAnchor(context.getNewAnchor());
            ctx.setTargetAnchor(con.getEnd());
            if (con.getEnd() != null) {
                ctx.setTargetPictogramElement((PictogramElement)con.getEnd().getParent());
            }
            if (context.getNewAnchor() != null) {
                ctx.setSourcePictogramElement((PictogramElement)context.getNewAnchor().getParent());
            }
        } else if (ReconnectionContext.RECONNECT_TARGET.equals(context.getReconnectType())) {
            ctx.setSourceAnchor(con.getStart());
            ctx.setTargetAnchor(context.getNewAnchor());
            ctx.setSourcePictogramElement((PictogramElement)con.getStart().getParent());
            if (context.getNewAnchor() != null) {
                ctx.setTargetPictogramElement((PictogramElement)context.getNewAnchor().getParent());
            }
        }
        return feature.canCreate((ICreateConnectionContext)ctx);
    }

    public void execute(IContext context) {
        if (context instanceof IReconnectionContext) {
            IReconnectionContext reCtx = (IReconnectionContext)context;
            if (reCtx.getNewAnchor() == null) {
                Shape shape = (Shape)reCtx.getOldAnchor().eContainer();
                Graphiti.getGaService().setLocation(shape.getGraphicsAlgorithm(), reCtx.getTargetLocation().getX(), reCtx.getTargetLocation().getY());
            } else {
                super.execute(context);
            }
        } else {
            super.execute(context);
        }
    }
}

