/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fmc.blockdiagram.editor.features.add;

import org.eclipse.fmc.blockdiagram.editor.features.add.ShapeAddFeature;
import org.eclipse.fmc.blockdiagram.editor.util.StyleUtil;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.mm.GraphicsAlgorithmContainer;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.MultiText;
import org.eclipse.graphiti.mm.algorithms.Polyline;
import org.eclipse.graphiti.mm.algorithms.Rectangle;
import org.eclipse.graphiti.mm.algorithms.styles.LineStyle;
import org.eclipse.graphiti.mm.algorithms.styles.Orientation;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;

public class AreaBorderAddFeature
extends ShapeAddFeature {
    private static final int MIN_HEIGHT = 100;
    private static final int MIN_WIDTH = 100;

    public AreaBorderAddFeature(IFeatureProvider fp) {
        super(fp);
        this.minimumWidth = 100;
        this.minimumHeight = 100;
    }

    public AreaBorderAddFeature(IFeatureProvider featureProvider, boolean linked) {
        super(featureProvider);
        this.minimumWidth = 100;
        this.minimumHeight = 100;
        this.linked = linked;
    }

    @Override
    public boolean canAdd(IAddContext context) {
        return true;
    }

    public PictogramElement add(IAddContext context) {
        ContainerShape container = context.getTargetContainer();
        ContainerShape areaBorderContainer = this.pe.createContainerShape(container, true);
        Rectangle invRec = this.ga.createInvisibleRectangle((PictogramElement)areaBorderContainer);
        invRec.setStyle(StyleUtil.getStyle(this.getDiagram(), "Shape"));
        if (this.linked) {
            this.link((PictogramElement)areaBorderContainer, context.getNewObject());
        }
        int w = context.getWidth();
        int h = context.getHeight();
        int min = 100;
        if (context.getWidth() > context.getHeight()) {
            w = context.getWidth() < min ? min : w;
        } else {
            h = context.getHeight() < min ? min : h;
        }
        int margin = 2;
        int lineWidth = 2;
        int textHeight = 20;
        int textWidth = 100;
        Polyline line = this.ga.createPolyline((GraphicsAlgorithmContainer)invRec);
        line.setLineStyle(LineStyle.DASH);
        line.setLineWidth(Integer.valueOf(lineWidth));
        line.setParentGraphicsAlgorithm((GraphicsAlgorithm)invRec);
        line.setStyle(StyleUtil.getStyle(this.getDiagram(), "Shape"));
        MultiText txt = this.ga.createMultiText((GraphicsAlgorithmContainer)invRec, "Area Border");
        txt.setForeground(this.manageColor(0, 0, 0));
        txt.setStyle(StyleUtil.getStyle(this.getDiagram(), "Shape"));
        txt.setParentGraphicsAlgorithm((GraphicsAlgorithm)invRec);
        if (context.getWidth() > context.getHeight()) {
            this.ga.setLocationAndSize((GraphicsAlgorithm)invRec, context.getX(), context.getY(), w, 3 * margin + lineWidth + textHeight);
            txt.setHorizontalAlignment(Orientation.ALIGNMENT_RIGHT);
            txt.setVerticalAlignment(Orientation.ALIGNMENT_BOTTOM);
            this.ga.setLocationAndSize((GraphicsAlgorithm)txt, margin, margin, w - 2 * margin, textHeight);
            this.ga.setLocationAndSize((GraphicsAlgorithm)line, 0, 2 * margin + textHeight, w, 2);
            line.getPoints().add((Object)this.ga.createPoint(0, 0));
            line.getPoints().add((Object)this.ga.createPoint(w, 0));
        } else {
            this.ga.setLocationAndSize((GraphicsAlgorithm)invRec, context.getX(), context.getY(), 3 * margin + lineWidth + textWidth, h);
            this.ga.setLocationAndSize((GraphicsAlgorithm)line, margin, 0, 2, h);
            line.getPoints().add((Object)this.ga.createPoint(0, 0));
            line.getPoints().add((Object)this.ga.createPoint(0, h));
            txt.setHorizontalAlignment(Orientation.ALIGNMENT_LEFT);
            txt.setVerticalAlignment(Orientation.ALIGNMENT_BOTTOM);
            this.ga.setLocationAndSize((GraphicsAlgorithm)txt, 2 * margin + lineWidth, margin, textWidth, h - 2 * margin);
        }
        return areaBorderContainer;
    }
}

