/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fmc.blockdiagram.editor.features.add;

import org.eclipse.fmc.blockdiagram.editor.features.add.ConnectionAddFeature;
import org.eclipse.fmc.blockdiagram.editor.model.ConnectionStyle;
import org.eclipse.fmc.blockdiagram.editor.model.FMCType;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAddConnectionContext;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.mm.GraphicsAlgorithmContainer;
import org.eclipse.graphiti.mm.algorithms.Ellipse;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Polyline;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ConnectionDecorator;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;
import org.eclipse.graphiti.services.IPeService;

public class DotsConnectionAddFeature
extends ConnectionAddFeature {
    public static final int DOTS_SIZE = 6;
    public static final int NO_OF_DOTS = 3;
    protected boolean linked = true;

    public DotsConnectionAddFeature(IFeatureProvider featureProvider, ConnectionStyle style) {
        super(featureProvider, style);
    }

    public boolean canAdd(IAddContext context) {
        return true;
    }

    public PictogramElement add(IAddContext context) {
        IPeService pe = Graphiti.getPeService();
        IGaService ga = Graphiti.getGaService();
        IAddConnectionContext cContext = (IAddConnectionContext)context;
        Connection cShape = super.createConnection();
        Polyline line = ga.createPolyline((GraphicsAlgorithmContainer)cShape);
        line.setLineVisible(Boolean.valueOf(false));
        cShape.setStart(cContext.getSourceAnchor());
        cShape.setEnd(cContext.getTargetAnchor());
        line.setForeground(this.manageColor(0, 0, 0));
        int i = 0;
        while (i < 3) {
            ConnectionDecorator deco = pe.createConnectionDecorator(cShape, false, 0.26666666666666666 * (double)(i + 1), true);
            Ellipse e = ga.createEllipse((GraphicsAlgorithmContainer)deco);
            e.setBackground(this.manageColor(0, 0, 0));
            e.setForeground(this.manageColor(0, 0, 0));
            ga.setSize((GraphicsAlgorithm)e, 6, 6);
            ++i;
        }
        if (this.linked) {
            this.link((PictogramElement)cShape, (Object)((FMCType)((Object)context.getNewObject())));
        }
        return cShape;
    }

    public static boolean isDots(Connection connection) {
        for (ConnectionDecorator decorator : connection.getConnectionDecorators()) {
            Ellipse ellipse;
            if (!(decorator.getGraphicsAlgorithm() instanceof Ellipse) || (ellipse = (Ellipse)decorator.getGraphicsAlgorithm()).getWidth() == 6 && ellipse.getHeight() == 6) continue;
            return false;
        }
        return connection.getConnectionDecorators().size() == 3;
    }
}

