/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fmc.blockdiagram.editor.features.custom;

import org.eclipse.fmc.blockdiagram.editor.BlockDiagramEditor;
import org.eclipse.fmc.blockdiagram.editor.clipboard.CopyToClipboard;
import org.eclipse.fmc.blockdiagram.editor.features.custom.FMCCustomFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;

public class CopyToClipboardCustomFeature
extends FMCCustomFeature {
    private final int imageFormat;

    public CopyToClipboardCustomFeature(IFeatureProvider featureProvider) {
        super(featureProvider);
        this.imageFormat = 5;
    }

    public CopyToClipboardCustomFeature(IFeatureProvider featureProvider, int imageFormat) {
        super(featureProvider);
        this.imageFormat = imageFormat;
    }

    public String getImageId() {
        return "org.eclipse.fmc.CopyAsicons";
    }

    public String getName() {
        return "Copy to Clipboard (PNG)";
    }

    public boolean canExecute(ICustomContext context) {
        if (context.getPictogramElements() != null && context.getPictogramElements().length > 0) {
            PictogramElement[] pictogramElementArray = context.getPictogramElements();
            int n = pictogramElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                PictogramElement pe = pictogramElementArray[n2];
                if (pe instanceof Shape) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
        return false;
    }

    public void execute(ICustomContext context) {
        CopyToClipboard.copyToClipboard((BlockDiagramEditor)this.getDiagramBehavior().getDiagramContainer(), this.imageFormat);
    }

    public boolean hasDoneChanges() {
        return false;
    }

    public boolean canUndo(IContext context) {
        return false;
    }
}

