/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fmc.blockdiagram.editor.features.custom;

import org.eclipse.fmc.blockdiagram.editor.features.custom.FMCCustomFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.BoxRelativeAnchor;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IPeLayoutService;

public class LayoutConnectionCustomFeature
extends FMCCustomFeature {
    private IPeLayoutService pe = Graphiti.getPeLayoutService();

    public LayoutConnectionCustomFeature(IFeatureProvider featureProvider) {
        super(featureProvider);
    }

    public boolean canExecute(ICustomContext context) {
        PictogramElement[] pictogramElementArray = context.getPictogramElements();
        int n = pictogramElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            PictogramElement element = pictogramElementArray[n2];
            if (!(element instanceof Connection)) {
                return false;
            }
            Connection con = (Connection)element;
            if (!(con.getStart() instanceof BoxRelativeAnchor) || !(con.getEnd() instanceof BoxRelativeAnchor)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public void execute(ICustomContext context) {
        PictogramElement[] pictogramElementArray = context.getPictogramElements();
        int n = pictogramElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            PictogramElement element = pictogramElementArray[n2];
            Connection con = (Connection)element;
            Anchor start = con.getStart();
            Anchor end = con.getEnd();
            if (start instanceof BoxRelativeAnchor || end instanceof BoxRelativeAnchor) {
                int difW = this.pe.getLocationRelativeToDiagram(end).getX() - this.pe.getLocationRelativeToDiagram(start).getX();
                int difH = this.pe.getLocationRelativeToDiagram(end).getY() - this.pe.getLocationRelativeToDiagram(start).getY();
                if (this.isVerticalAnchor(start) || this.isVerticalAnchor(end)) {
                    if (!(end instanceof BoxRelativeAnchor)) {
                        ((BoxRelativeAnchor)start).setRelativeWidth(((BoxRelativeAnchor)start).getRelativeWidth() + this.getRelativeWidth(start, difW));
                    } else {
                        ((BoxRelativeAnchor)end).setRelativeWidth(((BoxRelativeAnchor)end).getRelativeWidth() - this.getRelativeWidth(end, difW));
                    }
                } else if (this.isHorizontalAnchor(start) || this.isHorizontalAnchor(end)) {
                    if (!(end instanceof BoxRelativeAnchor)) {
                        ((BoxRelativeAnchor)start).setRelativeHeight(((BoxRelativeAnchor)start).getRelativeHeight() + this.getRelativeHeight(start, difH));
                    } else {
                        ((BoxRelativeAnchor)end).setRelativeHeight(((BoxRelativeAnchor)end).getRelativeHeight() - this.getRelativeHeight(end, difH));
                    }
                }
            }
            ++n2;
        }
    }

    private boolean isVerticalAnchor(Anchor anchor) {
        if (anchor instanceof BoxRelativeAnchor) {
            BoxRelativeAnchor boxAnchor = (BoxRelativeAnchor)anchor;
            return boxAnchor.getRelativeHeight() == 0.0 || boxAnchor.getRelativeHeight() == 1.0;
        }
        return false;
    }

    private boolean isHorizontalAnchor(Anchor anchor) {
        if (anchor instanceof BoxRelativeAnchor) {
            BoxRelativeAnchor boxAnchor = (BoxRelativeAnchor)anchor;
            return boxAnchor.getRelativeWidth() == 0.0 || boxAnchor.getRelativeWidth() == 1.0;
        }
        return false;
    }

    private double getRelativeWidth(Anchor anchor, int dist) {
        double width = anchor.getParent().getGraphicsAlgorithm().getWidth();
        return (double)dist / width;
    }

    private double getRelativeHeight(Anchor anchor, int num) {
        double height = anchor.getParent().getGraphicsAlgorithm().getHeight();
        return (double)num / height;
    }

    public String getName() {
        return "Layout Connection";
    }
}

