/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fmc.blockdiagram.editor.property;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.ui.provider.PropertySource;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.fmc.blockdiagram.editor.property.GraphitiPropertySection;
import org.eclipse.graphiti.mm.algorithms.AbstractText;
import org.eclipse.graphiti.mm.algorithms.styles.Orientation;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.mm.pictograms.util.PictogramsAdapterFactory;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class AlignmentPropertySection
extends GraphitiPropertySection {
    protected CCombo horCombo;
    protected CCombo verCombo;

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        TabbedPropertySheetWidgetFactory fac = this.getWidgetFactory();
        Composite comp = fac.createComposite(parent, 0);
        comp.setLayout((Layout)new GridLayout(2, false));
        fac.createLabel(comp, "Horizontal Orientation:");
        this.horCombo = fac.createCCombo(comp);
        this.horCombo.setItems(new String[]{Orientation.ALIGNMENT_LEFT.getName(), Orientation.ALIGNMENT_CENTER.getName(), Orientation.ALIGNMENT_RIGHT.getName()});
        this.horCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AlignmentPropertySection.this.changeHorizontalAlignment();
            }
        });
        fac.createLabel(comp, "Vertical Orientation:");
        this.verCombo = fac.createCCombo(comp);
        this.verCombo.setItems(new String[]{Orientation.ALIGNMENT_TOP.getName(), Orientation.ALIGNMENT_CENTER.getName(), Orientation.ALIGNMENT_BOTTOM.getName()});
        this.verCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AlignmentPropertySection.this.changeVerticalAlignment();
            }
        });
        this.refresh();
    }

    private void changeHorizontalAlignment() {
        this.editingDomain.getCommandStack().execute((Command)new RecordingCommand(this.editingDomain){

            protected void doExecute() {
                List<PictogramElement> inputs = AlignmentPropertySection.this.getInput();
                for (PictogramElement singleInput : inputs) {
                    if (singleInput instanceof ContainerShape) {
                        for (Shape s : ((ContainerShape)singleInput).getChildren()) {
                            AlignmentPropertySection.this.setHorizontalAlignment((PictogramElement)s);
                        }
                        continue;
                    }
                    if (!(singleInput.getGraphicsAlgorithm() instanceof AbstractText)) continue;
                    AlignmentPropertySection.this.setHorizontalAlignment(singleInput);
                }
            }
        });
    }

    private void changeVerticalAlignment() {
        this.editingDomain.getCommandStack().execute((Command)new RecordingCommand(this.editingDomain){

            protected void doExecute() {
                List<PictogramElement> inputs = AlignmentPropertySection.this.getInput();
                for (PictogramElement singleInput : inputs) {
                    if (singleInput instanceof ContainerShape) {
                        for (Shape s : ((ContainerShape)singleInput).getChildren()) {
                            AlignmentPropertySection.this.setVerticalAlignment((PictogramElement)s);
                        }
                        continue;
                    }
                    if (!(singleInput.getGraphicsAlgorithm() instanceof AbstractText)) continue;
                    AlignmentPropertySection.this.setVerticalAlignment(singleInput);
                }
            }
        });
    }

    public IPropertySource getPropertySource(Object object) {
        IItemPropertySource itemPropertySource;
        if (object instanceof IPropertySource) {
            return (IPropertySource)object;
        }
        AdapterFactory adapterFactory = this.getAdapterFactory(object);
        if (adapterFactory != null && (itemPropertySource = (IItemPropertySource)adapterFactory.adapt(object, IItemPropertySource.class)) != null) {
            return new PropertySource(object, itemPropertySource);
        }
        if (object instanceof IAdaptable) {
            return (IPropertySource)((IAdaptable)object).getAdapter(IPropertySource.class);
        }
        return null;
    }

    protected AdapterFactory getAdapterFactory(Object object) {
        return new PictogramsAdapterFactory();
    }

    public NotificationFilter getFilter() {
        return NotificationFilter.createEventTypeFilter((int)1).or(NotificationFilter.createEventTypeFilter((int)2)).and(NotificationFilter.createNotifierTypeFilter(EObject.class));
    }

    public void update(Notification notification) {
        final EObject eObject = (EObject)notification.getNotifier();
        if (!this.isDisposed() && this.isSelection(eObject) && !this.isDeleted(eObject)) {
            this.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!AlignmentPropertySection.this.isDisposed() && AlignmentPropertySection.this.isSelection(eObject) && !AlignmentPropertySection.this.isDeleted(eObject)) {
                        AlignmentPropertySection.this.refresh();
                    }
                }
            });
        }
    }

    protected boolean isSelection(EObject eObject) {
        ISelection selection = this.getSelection();
        if (selection == null) {
            return false;
        }
        IStructuredSelection s = (IStructuredSelection)selection;
        if (s.size() > 1) {
            return false;
        }
        Iterator it = s.iterator();
        while (it.hasNext()) {
            if (eObject != it.next()) continue;
            return true;
        }
        return false;
    }

    protected boolean isDeleted(EObject eObject) {
        return eObject.eResource() == null;
    }

    protected Display getDisplay() {
        return this.getPart().getSite().getShell().getDisplay();
    }

    public void refresh() {
        if (!this.isDisposed()) {
            PictogramElement el = this.getSingleInput();
            if (el != null && el instanceof ContainerShape) {
                for (Shape s : ((ContainerShape)el).getChildren()) {
                    if (!(s.getGraphicsAlgorithm() instanceof AbstractText)) continue;
                    this.refreshText(s);
                }
            } else if (el != null && el.getGraphicsAlgorithm() instanceof AbstractText) {
                this.refreshText((Shape)el);
            } else {
                this.verCombo.setEnabled(false);
                this.horCombo.setEnabled(false);
            }
        }
    }

    private void refreshText(Shape s) {
        this.verCombo.setEnabled(true);
        this.horCombo.setEnabled(true);
        this.horCombo.setText(((AbstractText)s.getGraphicsAlgorithm()).getHorizontalAlignment().getName());
        this.verCombo.setText(((AbstractText)s.getGraphicsAlgorithm()).getVerticalAlignment().getName());
    }

    private void setHorizontalAlignment(PictogramElement s) {
        if (s.getGraphicsAlgorithm() instanceof AbstractText) {
            ((AbstractText)s.getGraphicsAlgorithm()).setHorizontalAlignment(Orientation.getByName((String)this.horCombo.getText()));
        }
    }

    private void setVerticalAlignment(PictogramElement s) {
        if (s.getGraphicsAlgorithm() instanceof AbstractText) {
            ((AbstractText)s.getGraphicsAlgorithm()).setVerticalAlignment(Orientation.getByName((String)this.verCombo.getText()));
        }
    }
}

