/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fmc.blockdiagram.editor.features.add;

import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.impl.AbstractAddShapeFeature;
import org.eclipse.graphiti.mm.GraphicsAlgorithmContainer;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Image;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;
import org.eclipse.graphiti.services.IPeService;
import org.eclipse.graphiti.ui.services.GraphitiUi;
import org.eclipse.swt.graphics.Rectangle;

public class ImageAddFeature
extends AbstractAddShapeFeature {
    protected String imageId;

    public ImageAddFeature(IFeatureProvider featureProvider, String imageId) {
        super(featureProvider);
        this.imageId = imageId;
    }

    public boolean canAdd(IAddContext context) {
        return true;
    }

    public PictogramElement add(IAddContext context) {
        IGaService gaService = Graphiti.getGaService();
        IPeService peService = Graphiti.getPeService();
        ContainerShape parent = context.getTargetContainer();
        ContainerShape newShape = peService.createContainerShape(parent, true);
        Rectangle imageBounds = GraphitiUi.getImageService().getImageForId(this.getFeatureProvider().getDiagramTypeProvider().getProviderId(), this.imageId).getBounds();
        Image image = gaService.createImage((GraphicsAlgorithmContainer)newShape, this.imageId);
        image.setId(this.imageId);
        image.setStretchH(Boolean.valueOf(true));
        image.setStretchV(Boolean.valueOf(true));
        gaService.setLocationAndSize((GraphicsAlgorithm)image, context.getX(), context.getY(), imageBounds.width, imageBounds.height);
        this.link((PictogramElement)newShape, context.getNewObject());
        this.layoutPictogramElement((PictogramElement)newShape);
        return newShape;
    }
}

