/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fmc.blockdiagram.editor.property;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.ui.provider.PropertySource;
import org.eclipse.emf.transaction.DemultiplexingListener;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.fmc.blockdiagram.editor.util.FMCUtil;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.graphiti.mm.algorithms.AbstractText;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.ui.editor.DiagramEditor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.ui.views.properties.tabbed.AdvancedPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class DefaultPropertySection
extends AdvancedPropertySection
implements IPropertySourceProvider {
    protected TransactionalEditingDomain editingDomain;
    private DemultiplexingListener eventListener = new DemultiplexingListener(this.getFilter()){

        protected void handleNotification(TransactionalEditingDomain domain, Notification notification) {
            DefaultPropertySection.this.update(notification);
        }
    };
    protected boolean disposed;

    public IPropertySource getPropertySource(Object object) {
        IItemPropertySource itemPropertySource;
        if (object instanceof IPropertySource) {
            return (IPropertySource)object;
        }
        AdapterFactory adapterFactory = this.getAdapterFactory(object);
        if (adapterFactory != null && (itemPropertySource = (IItemPropertySource)adapterFactory.adapt(object, IItemPropertySource.class)) != null) {
            return new PropertySource(object, itemPropertySource);
        }
        if (object instanceof IAdaptable) {
            return (IPropertySource)((IAdaptable)object).getAdapter(IPropertySource.class);
        }
        return null;
    }

    private IPropertySourceProvider getPropertySourceProvider() {
        return this;
    }

    private AdapterFactory getAdapterFactory(Object object) {
        if (this.getEditingDomain() instanceof AdapterFactoryEditingDomain) {
            return ((AdapterFactoryEditingDomain)this.getEditingDomain()).getAdapterFactory();
        }
        return null;
    }

    private void setActionBars(IActionBars actionBars) {
        if (actionBars != null) {
            actionBars.getMenuManager().removeAll();
            actionBars.getToolBarManager().removeAll();
            actionBars.getStatusLineManager().removeAll();
            this.page.makeContributions(actionBars.getMenuManager(), actionBars.getToolBarManager(), actionBars.getStatusLineManager());
            actionBars.getToolBarManager().update(true);
        }
    }

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        this.page.setPropertySourceProvider(this.getPropertySourceProvider());
        this.setActionBars(aTabbedPropertySheetPage.getSite().getActionBars());
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        IEditingDomainProvider provider = (IEditingDomainProvider)part.getAdapter(IEditingDomainProvider.class);
        assert (provider.getEditingDomain() instanceof TransactionalEditingDomain);
        this.editingDomain = (TransactionalEditingDomain)provider.getEditingDomain();
        ArrayList<Object> objects = new ArrayList<Object>();
        if (selection instanceof IStructuredSelection) {
            for (Object next : (IStructuredSelection)selection) {
                if (next instanceof GraphicalEditPart) {
                    GraphicalEditPart editPart = (GraphicalEditPart)next;
                    PictogramElement pe = (PictogramElement)editPart.getModel();
                    EObject modelObj = Graphiti.getLinkService().getBusinessObjectForLinkedPictogramElement(pe);
                    objects.add(modelObj);
                    continue;
                }
                if (!(next instanceof EObject)) continue;
                objects.add(next);
            }
        }
        StructuredSelection newSelection = new StructuredSelection(objects);
        super.setInput(part, (ISelection)newSelection);
    }

    public NotificationFilter getFilter() {
        return NotificationFilter.createEventTypeFilter((int)1).or(NotificationFilter.createEventTypeFilter((int)2)).and(NotificationFilter.createNotifierTypeFilter(EObject.class));
    }

    public void aboutToBeHidden() {
        if (this.getEditingDomain() != null) {
            this.getEditingDomain().removeResourceSetListener((ResourceSetListener)this.getEventListener());
        }
        super.aboutToBeHidden();
    }

    public void aboutToBeShown() {
        super.aboutToBeShown();
        if (this.getEditingDomain() != null) {
            this.getEditingDomain().addResourceSetListener((ResourceSetListener)this.getEventListener());
        }
    }

    private DemultiplexingListener getEventListener() {
        return this.eventListener;
    }

    private TransactionalEditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    public void update(final Notification notification) {
        final EObject eObject = (EObject)notification.getNotifier();
        if (!this.isDisposed() && this.isSelection(eObject) && !this.isDeleted(eObject)) {
            this.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!DefaultPropertySection.this.isDisposed() && DefaultPropertySection.this.isSelection(eObject) && !DefaultPropertySection.this.isDeleted(eObject)) {
                        DefaultPropertySection.this.refresh();
                    }
                    DiagramEditor editor = FMCUtil.getActiveEditor();
                    TransactionalEditingDomain domain = editor.getEditingDomain();
                    PictogramElement pe = editor.getSelectedPictogramElements()[0];
                    Map<EStructuralFeature, GraphicsAlgorithm> map = FMCUtil.getLinkedFeaturesMap(pe, eObject);
                    if (map != null) {
                        final GraphicsAlgorithm algo = map.get(notification.getFeature());
                        domain.getCommandStack().execute((Command)new RecordingCommand(domain){

                            protected void doExecute() {
                                if (algo != null && algo instanceof AbstractText) {
                                    ((AbstractText)algo).setValue(notification.getNewStringValue());
                                }
                            }
                        });
                        editor.getDiagramBehavior().refresh();
                    }
                }
            });
        }
    }

    public void dispose() {
        super.dispose();
        this.disposed = true;
    }

    protected boolean isDisposed() {
        return this.disposed;
    }

    protected boolean isSelection(EObject eObject) {
        ISelection selection = this.getSelection();
        if (selection == null) {
            return false;
        }
        IStructuredSelection s = (IStructuredSelection)selection;
        if (s.size() > 1) {
            return false;
        }
        Iterator it = s.iterator();
        while (it.hasNext()) {
            if (eObject != it.next()) continue;
            return true;
        }
        return false;
    }

    protected boolean isDeleted(EObject eObject) {
        return eObject.eResource() == null;
    }

    protected Display getDisplay() {
        return this.getPart().getSite().getShell().getDisplay();
    }
}

