/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fmc.mm.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.fmc.mm.Access;
import org.eclipse.fmc.mm.AccessType;
import org.eclipse.fmc.mm.Agent;
import org.eclipse.fmc.mm.Channel;
import org.eclipse.fmc.mm.Comment;
import org.eclipse.fmc.mm.CommentType;
import org.eclipse.fmc.mm.DataflowDirection;
import org.eclipse.fmc.mm.FMCModel;
import org.eclipse.fmc.mm.FmcFactory;
import org.eclipse.fmc.mm.FmcPackage;
import org.eclipse.fmc.mm.Metadata;
import org.eclipse.fmc.mm.MultiplicityType;
import org.eclipse.fmc.mm.RequestDirection;
import org.eclipse.fmc.mm.Stereotype;
import org.eclipse.fmc.mm.StereotypeValue;
import org.eclipse.fmc.mm.Storage;
import org.eclipse.fmc.mm.StructureVariance;
import org.eclipse.fmc.mm.impl.AccessImpl;
import org.eclipse.fmc.mm.impl.AgentImpl;
import org.eclipse.fmc.mm.impl.ChannelImpl;
import org.eclipse.fmc.mm.impl.CommentImpl;
import org.eclipse.fmc.mm.impl.FMCModelImpl;
import org.eclipse.fmc.mm.impl.MetadataImpl;
import org.eclipse.fmc.mm.impl.StereotypeImpl;
import org.eclipse.fmc.mm.impl.StereotypeValueImpl;
import org.eclipse.fmc.mm.impl.StorageImpl;
import org.eclipse.fmc.mm.impl.StructureVarianceImpl;

public class FmcFactoryImpl
extends EFactoryImpl
implements FmcFactory {
    public static FmcFactory init() {
        try {
            FmcFactory theFmcFactory = (FmcFactory)EPackage.Registry.INSTANCE.getEFactory("http://fmc.eclipse.org/0.10.0");
            if (theFmcFactory != null) {
                return theFmcFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new FmcFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 0: {
                return this.createAgent();
            }
            case 1: {
                return this.createChannel();
            }
            case 2: {
                return this.createStorage();
            }
            case 5: {
                return this.createAccess();
            }
            case 6: {
                return this.createFMCModel();
            }
            case 7: {
                return this.createStructureVariance();
            }
            case 8: {
                return this.createMetadata();
            }
            case 10: {
                return this.createComment();
            }
            case 12: {
                return this.createStereotype();
            }
            case 13: {
                return this.createStereotypeValue();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 15: {
                return this.createAccessTypeFromString(eDataType, initialValue);
            }
            case 16: {
                return this.createRequestDirectionFromString(eDataType, initialValue);
            }
            case 17: {
                return this.createMultiplicityTypeFromString(eDataType, initialValue);
            }
            case 18: {
                return this.createDataflowDirectionFromString(eDataType, initialValue);
            }
            case 19: {
                return this.createCommentTypeFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 15: {
                return this.convertAccessTypeToString(eDataType, instanceValue);
            }
            case 16: {
                return this.convertRequestDirectionToString(eDataType, instanceValue);
            }
            case 17: {
                return this.convertMultiplicityTypeToString(eDataType, instanceValue);
            }
            case 18: {
                return this.convertDataflowDirectionToString(eDataType, instanceValue);
            }
            case 19: {
                return this.convertCommentTypeToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    @Override
    public Agent createAgent() {
        AgentImpl agent = new AgentImpl();
        return agent;
    }

    @Override
    public Channel createChannel() {
        ChannelImpl channel = new ChannelImpl();
        return channel;
    }

    @Override
    public Storage createStorage() {
        StorageImpl storage = new StorageImpl();
        return storage;
    }

    @Override
    public Access createAccess() {
        AccessImpl access = new AccessImpl();
        return access;
    }

    @Override
    public FMCModel createFMCModel() {
        FMCModelImpl fmcModel = new FMCModelImpl();
        return fmcModel;
    }

    @Override
    public StructureVariance createStructureVariance() {
        StructureVarianceImpl structureVariance = new StructureVarianceImpl();
        return structureVariance;
    }

    @Override
    public Metadata createMetadata() {
        MetadataImpl metadata = new MetadataImpl();
        return metadata;
    }

    @Override
    public Comment createComment() {
        CommentImpl comment = new CommentImpl();
        return comment;
    }

    @Override
    public Stereotype createStereotype() {
        StereotypeImpl stereotype = new StereotypeImpl();
        return stereotype;
    }

    @Override
    public StereotypeValue createStereotypeValue() {
        StereotypeValueImpl stereotypeValue = new StereotypeValueImpl();
        return stereotypeValue;
    }

    public AccessType createAccessTypeFromString(EDataType eDataType, String initialValue) {
        AccessType result = AccessType.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertAccessTypeToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public RequestDirection createRequestDirectionFromString(EDataType eDataType, String initialValue) {
        RequestDirection result = RequestDirection.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertRequestDirectionToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public MultiplicityType createMultiplicityTypeFromString(EDataType eDataType, String initialValue) {
        MultiplicityType result = MultiplicityType.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertMultiplicityTypeToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public DataflowDirection createDataflowDirectionFromString(EDataType eDataType, String initialValue) {
        DataflowDirection result = DataflowDirection.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertDataflowDirectionToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public CommentType createCommentTypeFromString(EDataType eDataType, String initialValue) {
        CommentType result = CommentType.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertCommentTypeToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    @Override
    public FmcPackage getFmcPackage() {
        return (FmcPackage)this.getEPackage();
    }

    @Deprecated
    public static FmcPackage getPackage() {
        return FmcPackage.eINSTANCE;
    }
}

