/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fmc.blockdiagram.editor.algorithm.node;

import org.eclipse.fmc.blockdiagram.editor.algorithm.node.AbstractRectangleAlgorithm;
import org.eclipse.fmc.blockdiagram.editor.algorithm.node.AgentAlgorithm;
import org.eclipse.fmc.blockdiagram.editor.util.FMCUtil;
import org.eclipse.fmc.blockdiagram.editor.util.StyleUtil;
import org.eclipse.graphiti.mm.GraphicsAlgorithmContainer;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Rectangle;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.Shape;

public class RectangleAgentAlgorithm
extends AbstractRectangleAlgorithm
implements AgentAlgorithm {
    public static final int AGENT_MINIMUM_WIDTH = 15;
    public static final int AGENT_MINIMUM_HEIGHT = 15;
    public static final int AGENT_DEFAULT_WIDTH = 70;
    public static final int AGENT_DEFAULT_HEIGHT = 50;
    public static final int AGENT_DEFAULT_LINEWIDTH = 3;

    @Override
    public GraphicsAlgorithm createGraphics(Diagram diag, GraphicsAlgorithmContainer container, int x, int y, int width, int height) {
        Rectangle rectShape = this.ga.createRectangle(container);
        this.ga.setLocationAndSize((GraphicsAlgorithm)rectShape, x, y, width, height);
        rectShape.setLineWidth(Integer.valueOf(3));
        rectShape.setTransparency(null);
        rectShape.setStyle(StyleUtil.getStyle(diag, "Shape"));
        if (container instanceof GraphicsAlgorithm) {
            ContainerShape containerShape = this.getContainerShape((GraphicsAlgorithm)rectShape);
            this.pe.createChopboxAnchor((AnchorContainer)containerShape);
            this.createBoxAnchorSet((Shape)containerShape);
        }
        return rectShape;
    }

    @Override
    public int getMinimumHeight() {
        return 15;
    }

    @Override
    public int getMinimumWidth() {
        return 15;
    }

    @Override
    public int getDefaultHeight() {
        return 50;
    }

    @Override
    public int getDefaultWidth() {
        return 70;
    }

    @Override
    public int getDefaultLineWidth() {
        return 3;
    }

    @Override
    public void resize(GraphicsAlgorithm algorithm, int x, int y, int width, int height) {
        ContainerShape container = this.getContainerShape(algorithm);
        this.ga.setLocationAndSize(algorithm, x, y, width, height);
        this.relocateText(algorithm);
        this.createBoxAnchorSet((Shape)container);
    }

    @Override
    protected void addBoxAnchorSet(Shape shape) {
        GraphicsAlgorithm firstLevelRectangle = shape.getGraphicsAlgorithm();
        GraphicsAlgorithm secondLevelRectangle = (GraphicsAlgorithm)firstLevelRectangle.getGraphicsAlgorithmChildren().get(0);
        double offsetMultiInstance = 0.0;
        if (firstLevelRectangle.getWidth() != secondLevelRectangle.getWidth()) {
            FMCUtil.removeObsoleteAnchors(shape);
            offsetMultiInstance = 5.0;
        }
        int numOfAnchorsW = secondLevelRectangle.getWidth() / 8;
        int numOfAnchorsH = secondLevelRectangle.getHeight() / 8;
        double gapW = (double)secondLevelRectangle.getWidth() / (double)numOfAnchorsW / (double)firstLevelRectangle.getWidth();
        double gapH = (double)secondLevelRectangle.getHeight() / (double)numOfAnchorsH / (double)firstLevelRectangle.getHeight();
        double relativeOffsetXForA = offsetMultiInstance / (double)firstLevelRectangle.getWidth();
        double relativeOffsetXForC = 0.0;
        double relativeOffsetYForA = 0.0;
        double relativeOffsetYForC = 1.0 - 8.0 / (double)firstLevelRectangle.getHeight();
        double relativeOffsetXForB = 1.0 - 8.0 / (double)firstLevelRectangle.getWidth();
        double relativeOffsetXForD = 0.0;
        double relativeOffsetYForB = 0.0;
        double relativeOffsetYForD = offsetMultiInstance / (double)firstLevelRectangle.getHeight();
        int i = 0;
        while (i < numOfAnchorsW) {
            this.createBoxAnchor(shape, relativeOffsetXForA + (double)i * gapW, relativeOffsetYForA, 8, 8);
            this.createBoxAnchor(shape, relativeOffsetXForC + (double)i * gapW, relativeOffsetYForC, 8, 8);
            ++i;
        }
        i = 0;
        while (i < numOfAnchorsH) {
            this.createBoxAnchor(shape, relativeOffsetXForD, relativeOffsetYForD + (double)i * gapH, 8, 8);
            this.createBoxAnchor(shape, relativeOffsetXForB, relativeOffsetYForB + (double)i * gapH, 8, 8);
            ++i;
        }
    }
}

