/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fmc.blockdiagram.editor.features;

import org.eclipse.emf.common.util.EList;
import org.eclipse.fmc.blockdiagram.editor.model.FMCType;
import org.eclipse.fmc.blockdiagram.editor.util.FMCUtil;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IMoveShapeContext;
import org.eclipse.graphiti.features.impl.DefaultMoveShapeFeature;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;

public class ShapeMoveFeature
extends DefaultMoveShapeFeature {
    public ShapeMoveFeature(IFeatureProvider featureProvider) {
        super(featureProvider);
    }

    public boolean canMoveShape(IMoveShapeContext context) {
        return FMCUtil.getIndependentObject((PictogramElement)context.getTargetContainer()) != FMCType.Brace;
    }

    protected void internalMove(IMoveShapeContext context) {
        if (!this.getUserDecision()) {
            return;
        }
        Shape shapeToMove = context.getShape();
        ContainerShape oldContainerShape = context.getSourceContainer();
        ContainerShape newContainerShape = context.getTargetContainer();
        boolean avoidNegativeCoordinates = !(newContainerShape instanceof Diagram);
        int x = context.getX();
        int y = context.getY();
        if (avoidNegativeCoordinates && x + shapeToMove.getGraphicsAlgorithm().getWidth() > newContainerShape.getGraphicsAlgorithm().getWidth()) {
            x -= x + shapeToMove.getGraphicsAlgorithm().getWidth() - newContainerShape.getGraphicsAlgorithm().getWidth();
        }
        if (avoidNegativeCoordinates && y + shapeToMove.getGraphicsAlgorithm().getHeight() > newContainerShape.getGraphicsAlgorithm().getHeight()) {
            y -= y + shapeToMove.getGraphicsAlgorithm().getHeight() - newContainerShape.getGraphicsAlgorithm().getHeight();
        }
        if (oldContainerShape != newContainerShape) {
            EList children;
            PictogramElement[] currentSelection = this.getDiagramBehavior().getDiagramContainer().getSelectedPictogramElements();
            if (oldContainerShape != null && (children = oldContainerShape.getChildren()) != null) {
                children.remove(shapeToMove);
            }
            shapeToMove.setContainer(newContainerShape);
            this.moveDomainObjects(shapeToMove, newContainerShape);
            if (shapeToMove.getGraphicsAlgorithm() != null) {
                Graphiti.getGaService().setLocation(shapeToMove.getGraphicsAlgorithm(), x, y, avoidNegativeCoordinates);
            }
            this.getDiagramBehavior().getDiagramContainer().setPictogramElementsForSelection(currentSelection);
        } else if (shapeToMove.getGraphicsAlgorithm() != null) {
            Graphiti.getGaService().setLocation(shapeToMove.getGraphicsAlgorithm(), x, y, avoidNegativeCoordinates);
        }
    }

    protected void moveDomainObjects(Shape shapeToMove, ContainerShape newContainerShape) {
    }
}

