/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fmc.blockdiagram.editor.features.add;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.fmc.blockdiagram.editor.algorithm.connection.FMCConnectionAlgorithm;
import org.eclipse.fmc.blockdiagram.editor.algorithm.connection.FMCConnectionAlgorithmFactory;
import org.eclipse.fmc.blockdiagram.editor.features.add.ConnectionAddFeature;
import org.eclipse.fmc.blockdiagram.editor.model.ConnectionStyle;
import org.eclipse.fmc.blockdiagram.editor.model.FMCType;
import org.eclipse.fmc.blockdiagram.editor.model.FMCTypeChecker;
import org.eclipse.fmc.blockdiagram.editor.model.FMCTypeCheckerFactory;
import org.eclipse.fmc.blockdiagram.editor.util.StyleUtil;
import org.eclipse.fmc.mm.RequestDirection;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAddConnectionContext;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.mm.GraphicsAlgorithmContainer;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Polygon;
import org.eclipse.graphiti.mm.algorithms.Polyline;
import org.eclipse.graphiti.mm.algorithms.Text;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ConnectionDecorator;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;
import org.eclipse.graphiti.services.IPeService;

public class CommunicationChannelAddFeature
extends ConnectionAddFeature {
    private FMCTypeChecker checker = FMCTypeCheckerFactory.getInstance();
    private FMCConnectionAlgorithmFactory factory = FMCConnectionAlgorithmFactory.getInstance();
    private static final float decoPosX = 0.4f;
    protected static final String defaultChannelText = "Channel";

    public CommunicationChannelAddFeature(IFeatureProvider fp, ConnectionStyle type) {
        super(fp, type);
    }

    public boolean canAdd(IAddContext context) {
        return true;
    }

    public PictogramElement add(IAddContext context) {
        IPeService pe = Graphiti.getPeService();
        IGaService ga = Graphiti.getGaService();
        IAddConnectionContext cContext = (IAddConnectionContext)context;
        Connection cShape = super.createConnection();
        Polyline line = ga.createPolyline((GraphicsAlgorithmContainer)cShape);
        cShape.setStart(cContext.getSourceAnchor());
        cShape.setEnd(cContext.getTargetAnchor());
        line.setForeground(this.manageColor(0, 0, 0));
        FMCConnectionAlgorithm connectionAlgorithm = this.factory.getAlgorithm((PictogramElement)cShape);
        connectionAlgorithm.createChannelSymbol(cShape, this.getDiagram());
        if (this.checker.isUnidirectionalCommunicationChannel(context.getNewObject())) {
            CommunicationChannelAddFeature.createCenterArrow(this.getDiagram(), cShape, true);
            CommunicationChannelAddFeature.createArrowDecorator(this.getDiagram(), cShape, true);
        }
        if (this.checker.isReqRespCommunicationChannel(context.getNewObject())) {
            connectionAlgorithm.setRequestDirection(cShape, RequestDirection.REQUEST, this.getDiagram());
        }
        this.linkModel(cShape, (IAddContext)cContext);
        ConnectionDecorator textDecorator = pe.createConnectionDecorator(cShape, true, (double)0.4f, true);
        Text text = ga.createText((GraphicsAlgorithmContainer)textDecorator);
        text.setForeground(this.manageColor(0, 0, 0));
        ga.setLocation((GraphicsAlgorithm)text, 0, 15);
        text.setValue(this.getNameFromObject(context.getNewObject()));
        text.setStyle(StyleUtil.getStyle(this.getDiagram(), "Connection"));
        this.linkTextWithModel((PictogramElement)textDecorator, context.getNewObject());
        return cShape;
    }

    protected void linkTextWithModel(PictogramElement element, Object obj) {
        if (obj instanceof FMCType) {
            this.link(element, (Object)FMCType.Text);
        } else {
            this.link(element, obj);
            Graphiti.getLinkService().setLinkProperty(element, "name");
        }
    }

    protected String getNameFromObject(Object obj) {
        if (obj instanceof EObject) {
            String name = null;
            EObject eobj = (EObject)obj;
            for (EAttribute attr : eobj.eClass().getEAllAttributes()) {
                if (!"name".equals(attr.getName())) continue;
                name = (String)eobj.eGet((EStructuralFeature)attr);
                if (name != null) {
                    return name;
                }
                eobj.eSet((EStructuralFeature)attr, (Object)defaultChannelText);
                return defaultChannelText;
            }
        }
        return defaultChannelText;
    }

    public static void createCenterArrow(Diagram diagram, Connection connection, boolean defaultDirection) {
        ConnectionDecorator arrow1 = Graphiti.getPeService().createConnectionDecorator(connection, false, (double)0.4f, true);
        Polygon p1 = null;
        if (defaultDirection) {
            int[] nArray = new int[8];
            nArray[0] = 23;
            nArray[1] = -6;
            nArray[2] = 8;
            nArray[4] = 23;
            nArray[5] = 6;
            nArray[6] = 20;
            p1 = Graphiti.getGaService().createPolygon((GraphicsAlgorithmContainer)arrow1, nArray);
        } else {
            int[] nArray = new int[8];
            nArray[0] = -21;
            nArray[1] = -6;
            nArray[2] = -6;
            nArray[4] = -21;
            nArray[5] = 6;
            nArray[6] = -18;
            p1 = Graphiti.getGaService().createPolygon((GraphicsAlgorithmContainer)arrow1, nArray);
        }
        p1.setBackground(Graphiti.getGaService().manageColor(diagram, 0, 0, 0));
    }

    protected void linkModel(Connection con, IAddContext context) {
        this.link((PictogramElement)con, context.getNewObject());
    }
}

