/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fmc.blockdiagram.editor.features.resize;

import org.eclipse.fmc.blockdiagram.editor.algorithm.comment.BraceAlgorithm;
import org.eclipse.fmc.blockdiagram.editor.algorithm.comment.CommentAlgorithmFactory;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IResizeShapeContext;
import org.eclipse.graphiti.features.impl.DefaultResizeShapeFeature;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;

public class BraceResizeFeature
extends DefaultResizeShapeFeature {
    public BraceResizeFeature(IFeatureProvider fp) {
        super(fp);
    }

    public void resizeShape(IResizeShapeContext context) {
        GraphicsAlgorithm resizeGa = context.getPictogramElement().getGraphicsAlgorithm();
        BraceAlgorithm braceAlgorithm = CommentAlgorithmFactory.getInstance().getBrace();
        int oldContainerWidth = resizeGa.getWidth();
        int oldContainerHeight = resizeGa.getHeight();
        int oldContainerX = resizeGa.getX();
        int oldContainerY = resizeGa.getY();
        int newContainerWidth = context.getWidth();
        int newContainerHeight = context.getHeight();
        int newContainerX = context.getX();
        int newContainerY = context.getY();
        if (context.getWidth() < braceAlgorithm.getMinimumWidth()) {
            if (oldContainerX != context.getX()) {
                newContainerX = oldContainerX + oldContainerWidth - braceAlgorithm.getMinimumWidth();
            }
            newContainerWidth = braceAlgorithm.getMinimumWidth();
        }
        if (context.getHeight() < braceAlgorithm.getMinimumHeight()) {
            if (oldContainerY != context.getY()) {
                newContainerY = oldContainerY + oldContainerHeight - braceAlgorithm.getMinimumHeight();
            }
            newContainerHeight = braceAlgorithm.getMinimumHeight();
        }
        braceAlgorithm.resize(resizeGa, newContainerX, newContainerY, newContainerWidth, newContainerHeight);
    }
}

