/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fmc.blockdiagram.editor.features.resize;

import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IResizeShapeContext;
import org.eclipse.graphiti.features.impl.DefaultResizeShapeFeature;
import org.eclipse.graphiti.mm.algorithms.AbstractText;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;

public class ResizeFeature
extends DefaultResizeShapeFeature {
    public ResizeFeature(IFeatureProvider fp) {
        super(fp);
    }

    public void resizeShape(IResizeShapeContext context) {
        int h;
        int maxW = 0;
        int maxH = 0;
        if (context.getShape() instanceof ContainerShape) {
            for (Shape s : ((ContainerShape)context.getShape()).getChildren()) {
                GraphicsAlgorithm sGa = s.getGraphicsAlgorithm();
                if (sGa instanceof AbstractText) continue;
                if (sGa.getWidth() + sGa.getX() > maxW) {
                    maxW = sGa.getWidth() + sGa.getX();
                }
                if (sGa.getHeight() + sGa.getY() <= maxH) continue;
                maxH = sGa.getHeight() + sGa.getY();
            }
        }
        int w = context.getWidth() >= maxW ? context.getWidth() : maxW;
        int n = h = context.getHeight() >= maxH ? context.getHeight() : maxH;
        if (context.getShape() instanceof ContainerShape) {
            for (Shape s : ((ContainerShape)context.getShape()).getChildren()) {
                if (!(s.getGraphicsAlgorithm() instanceof AbstractText) || s.isActive()) continue;
                Graphiti.getGaService().setLocationAndSize(s.getGraphicsAlgorithm(), 5, 5, w - 5, h - 10);
            }
        }
        super.resizeShape(context);
    }
}

