/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fmc.blockdiagram.editor.util;

import java.util.Collections;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.services.Graphiti;

public class DiagramFactory {
    public static final int DIAGRAM_HEIGHT_DEFAULT = 1000;
    public static final int DIAGRAM_WIDTH_DEFAULT = 1000;

    public static void createDefaultBlockdiagramFile(URI uri, int width, int height, int gridUnit) {
        Diagram defaultDiagram = DiagramFactory.getDefaultDiagram();
        defaultDiagram.setGridUnit(gridUnit);
        DiagramFactory.createBlockdiagramFile(uri, defaultDiagram, width, height);
    }

    public static void createDefaultBlockdiagramMetaFile(URI uri, int width, int height, int gridUnit) {
        Diagram defaultDiagram = DiagramFactory.getDefaultMetaDiagram();
        defaultDiagram.setGridUnit(gridUnit);
        DiagramFactory.createBlockdiagramFile(uri, defaultDiagram, width, height);
    }

    public static Diagram getDefaultDiagram() {
        Diagram d = Graphiti.getPeService().createDiagram("fmc", "", 10, false);
        d.setSnapToGrid(true);
        return d;
    }

    public static Diagram getDefaultMetaDiagram() {
        Diagram diagram = DiagramFactory.getDefaultDiagram();
        diagram.setDiagramTypeId("fmcMeta");
        return diagram;
    }

    public static void createBlockdiagramFile(URI uri, Diagram d, int width, int height) {
        XMIResourceFactoryImpl resFac = new XMIResourceFactoryImpl();
        try {
            Resource r = resFac.createResource(uri);
            r.getContents().add((Object)d);
            r.save(Collections.EMPTY_MAP);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    public static void createDefaultFMCProfileFile(URI uri, int width, int height, int gridUnit) {
        Diagram defaultDiagram = DiagramFactory.getDefaultProfileDiagram();
        defaultDiagram.setGridUnit(gridUnit);
        DiagramFactory.createBlockdiagramFile(uri, defaultDiagram, width, height);
    }

    public static Diagram getDefaultProfileDiagram() {
        Diagram d = Graphiti.getPeService().createDiagram("fmcProfile", "", 10, false);
        d.setSnapToGrid(true);
        return d;
    }
}

