/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fmc.blockdiagram.editor.wizards;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.fmc.blockdiagram.editor.wizards.FMCWizardUtils;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;

public class BlockDiagramFilePage
extends WizardPage {
    public static final String DIAGRAM_EXTENSION = "blockdiag";
    private Text containerText;
    private Text fileText;
    private ISelection selection;
    private Spinner gridUnit;
    private String extension;

    public String getExtension() {
        return this.extension;
    }

    public BlockDiagramFilePage(ISelection selection) {
        super("BlockdiagramWizardPage");
        this.setTitle("New Blockdiagram File");
        this.extension = DIAGRAM_EXTENSION;
        this.subInit();
        this.selection = selection;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 3;
        layout.verticalSpacing = 9;
        this.createContainerControl(container);
        this.createFilenameControl(container);
        this.createGridUnitControl(container);
        this.initialize();
        this.dialogChanged();
        this.setControl((Control)container);
    }

    protected void createGridUnitControl(Composite container) {
        Label label = new Label(container, 0);
        label.setText("&GridUnit:");
        this.gridUnit = new Spinner(container, 2048);
        this.gridUnit.setSelection(10);
    }

    private void createFilenameControl(Composite container) {
        Label label = new Label(container, 0);
        label.setText("&File name:");
        this.fileText = new Text(container, 2052);
        GridData gd = new GridData(768);
        this.fileText.setLayoutData((Object)gd);
        this.fileText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BlockDiagramFilePage.this.dialogChanged();
            }
        });
        new Label(container, 0);
    }

    private void createContainerControl(Composite container) {
        Label label = new Label(container, 0);
        label.setText("&Project:");
        this.containerText = new Text(container, 2052);
        GridData gd = new GridData(768);
        this.containerText.setLayoutData((Object)gd);
        this.containerText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BlockDiagramFilePage.this.dialogChanged();
            }
        });
        Button button = new Button(container, 8);
        button.setText("Browse...");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BlockDiagramFilePage.this.handleBrowse();
            }
        });
    }

    private void initialize() {
        if (this.selection != null && !this.selection.isEmpty() && this.selection instanceof IStructuredSelection) {
            IStructuredSelection ssel = (IStructuredSelection)this.selection;
            if (ssel.size() > 1) {
                return;
            }
            Object obj = ssel.getFirstElement();
            if (obj instanceof IResource) {
                IContainer container = obj instanceof IContainer ? (IContainer)obj : ((IResource)obj).getParent();
                this.containerText.setText(container.getFullPath().toString());
            }
        } else {
            try {
                IContainer container = FMCWizardUtils.createProjectIfNecessary();
                if (container != null) {
                    this.containerText.setText(container.getFullPath().toString());
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        this.fileText.setText("new_file." + this.extension);
    }

    private void handleBrowse() {
        Object[] result;
        ContainerSelectionDialog dialog = new ContainerSelectionDialog(this.getShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), false, "Select new file container");
        if (dialog.open() == 0 && (result = dialog.getResult()).length == 1) {
            this.containerText.setText(((Path)result[0]).toString());
        }
    }

    private void dialogChanged() {
        String ext;
        IResource container = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(this.getContainerName()));
        String fileName = this.getFileName();
        if (this.getContainerName().length() == 0) {
            this.updateStatus("File container must be specified");
            return;
        }
        if (container == null || (container.getType() & 6) == 0) {
            this.updateStatus("File container must exist");
            return;
        }
        if (!container.isAccessible()) {
            this.updateStatus("Project must be writable");
            return;
        }
        if (fileName.length() == 0) {
            this.updateStatus("File name must be specified");
            return;
        }
        if (fileName.replace('\\', '/').indexOf(47, 1) > 0) {
            this.updateStatus("File name must be valid");
            return;
        }
        int dotLoc = fileName.lastIndexOf(46);
        if (dotLoc != -1 && !(ext = fileName.substring(dotLoc + 1)).equalsIgnoreCase(this.extension)) {
            this.updateStatus("File extension must be \"" + this.extension + "\"");
            return;
        }
        IContainer cont = (IContainer)container;
        IFile f = cont.getFile((IPath)new Path(fileName));
        if (f.exists()) {
            this.updateStatus("File already exists. Please choose another file name.");
            return;
        }
        this.updateStatus(null);
    }

    private void updateStatus(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    public String getContainerName() {
        return this.containerText.getText();
    }

    public String getFileName() {
        String file = this.fileText.getText();
        if (!file.endsWith(this.extension)) {
            file = String.valueOf(file) + "." + this.extension;
        }
        return file;
    }

    public int getGridUnit() {
        if (this.gridUnit == null) {
            return 5;
        }
        return this.gridUnit.getSelection();
    }

    private void subInit() {
        this.setDescription("This wizard creates a new Blockdiagram Diagram file with *." + this.extension + " extension that can be opened by the Blockdiagram editor.");
        if (this.fileText != null) {
            String txt = this.fileText.getText();
            if (txt != null) {
                int dotPos = txt.lastIndexOf(46);
                if (dotPos != -1) {
                    txt = txt.substring(0, dotPos + 1).concat(this.extension);
                    this.fileText.setText(txt);
                } else {
                    this.fileText.setText(String.valueOf(txt) + "." + this.extension);
                }
            } else {
                this.fileText.setText("new_file." + this.extension);
            }
        }
    }
}

