/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fmc.mm.navigator;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.NotificationImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.fmc.mm.navigator.ProjectAdapterFactoryProvider;

public class ProjectAdapterFactoryContentProvider
extends AdapterFactoryContentProvider
implements IResourceChangeListener,
IResourceDeltaVisitor {
    private static ResourceSet resourceSet = new ResourceSetImpl();

    public ProjectAdapterFactoryContentProvider() {
        super((AdapterFactory)ProjectAdapterFactoryProvider.getAdapterFactory());
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
    }

    public boolean hasChildren(Object object) {
        if (object instanceof IFile) {
            return true;
        }
        return super.hasChildren(object);
    }

    public Object[] getChildren(Object object) {
        if (object instanceof IFile) {
            String path = ((IFile)object).getFullPath().toString();
            URI uri = URI.createPlatformResourceURI((String)path, (boolean)true);
            object = resourceSet.getResource(uri, false);
        }
        return super.getChildren(object);
    }

    public Object[] getElements(Object object) {
        if (object instanceof IFile) {
            String path = ((IFile)object).getFullPath().toString();
            URI uri = URI.createPlatformResourceURI((String)path, (boolean)false);
            object = resourceSet.getResource(uri, true);
        }
        return super.getElements(object);
    }

    public Object getParent(Object object) {
        if (object instanceof IFile) {
            return ((IResource)object).getParent();
        }
        return super.getParent(object);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta delta = event.getDelta();
        try {
            delta.accept((IResourceDeltaVisitor)this);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        try {
            IResource changedResource = delta.getResource();
            if (changedResource.getType() == 1 && "block".equals(changedResource.getFileExtension())) {
                String path = ((IFile)changedResource).getFullPath().toString();
                URI uri = URI.createPlatformResourceURI((String)path, (boolean)true);
                Resource res = resourceSet.getResource(uri, true);
                res.unload();
                res.load(resourceSet.getLoadOptions());
                this.notifyChanged((Notification)new ViewerNotification((Notification)new NotificationImpl(1, (Object)"", (Object)"Refresh")));
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        super.dispose();
    }
}

