/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fmc.blockdiagram.editor.meta;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.fmc.blockdiagram.editor.diagram.BlockDiagramFeatureProvider;
import org.eclipse.fmc.blockdiagram.editor.features.add.AnchorAddFeature;
import org.eclipse.fmc.blockdiagram.editor.features.add.InvisibleShapeAddFeature;
import org.eclipse.fmc.blockdiagram.editor.features.create.ConnectionCreateFeature;
import org.eclipse.fmc.blockdiagram.editor.features.create.ShapeCreateFeature;
import org.eclipse.fmc.blockdiagram.editor.meta.AddFeatureVisitor;
import org.eclipse.fmc.blockdiagram.editor.meta.features.FMCNodeDeleteFeature;
import org.eclipse.fmc.blockdiagram.editor.meta.features.ReconnectionMetaFeature;
import org.eclipse.fmc.blockdiagram.editor.meta.features.ShapePasteMetaFeature;
import org.eclipse.fmc.blockdiagram.editor.meta.features.TextDirectEditingMetaFeature;
import org.eclipse.fmc.blockdiagram.editor.meta.features.add.DotsConnectionAddMetaFeature;
import org.eclipse.fmc.blockdiagram.editor.meta.features.create.CommunicationChannelCreateFeature;
import org.eclipse.fmc.blockdiagram.editor.meta.features.create.ConnectionCreateMetaFeature;
import org.eclipse.fmc.blockdiagram.editor.meta.features.create.DotsCreateFeature;
import org.eclipse.fmc.blockdiagram.editor.meta.features.create.HumanAgentCreateMetaFeature;
import org.eclipse.fmc.blockdiagram.editor.meta.features.create.ShapeCreateMetaFeature;
import org.eclipse.fmc.blockdiagram.editor.meta.features.update.AccessUpdateFeature;
import org.eclipse.fmc.blockdiagram.editor.meta.features.update.AgentUpdateFeature;
import org.eclipse.fmc.blockdiagram.editor.meta.features.update.CommentUpdateMetaFeature;
import org.eclipse.fmc.blockdiagram.editor.meta.features.update.CommunicationChannelUpdateFeature;
import org.eclipse.fmc.blockdiagram.editor.meta.features.update.FMCNodeUpdateFeature;
import org.eclipse.fmc.blockdiagram.editor.meta.features.update.StorageUpdateMetaFeature;
import org.eclipse.fmc.blockdiagram.editor.meta.profile.IStereotypeProvider;
import org.eclipse.fmc.blockdiagram.editor.model.ConnectionStyle;
import org.eclipse.fmc.blockdiagram.editor.model.FMCType;
import org.eclipse.fmc.blockdiagram.editor.model.ShapeStyle;
import org.eclipse.fmc.blockdiagram.editor.util.FMCUtil;
import org.eclipse.fmc.mm.AccessType;
import org.eclipse.fmc.mm.CommentType;
import org.eclipse.fmc.mm.DataflowDirection;
import org.eclipse.fmc.mm.FMCElement;
import org.eclipse.fmc.mm.FMCNode;
import org.eclipse.fmc.mm.FmcPackage;
import org.eclipse.fmc.mm.RequestDirection;
import org.eclipse.graphiti.dt.IDiagramTypeProvider;
import org.eclipse.graphiti.features.IAddFeature;
import org.eclipse.graphiti.features.ICreateConnectionFeature;
import org.eclipse.graphiti.features.ICreateFeature;
import org.eclipse.graphiti.features.IDeleteFeature;
import org.eclipse.graphiti.features.IDirectEditingFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IPasteFeature;
import org.eclipse.graphiti.features.IReconnectionFeature;
import org.eclipse.graphiti.features.IUpdateFeature;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.IDeleteContext;
import org.eclipse.graphiti.features.context.IDirectEditingContext;
import org.eclipse.graphiti.features.context.IPasteContext;
import org.eclipse.graphiti.features.context.IReconnectionContext;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.mm.algorithms.MultiText;
import org.eclipse.graphiti.mm.algorithms.Text;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.ui.editor.DiagramBehavior;
import org.eclipse.graphiti.ui.features.DefaultDeleteFeature;

public class BlockDiagramMetaFeatureProvider
extends BlockDiagramFeatureProvider {
    private IStereotypeProvider stereoTypeProvider;

    public BlockDiagramMetaFeatureProvider(IDiagramTypeProvider diagramTypeProvider) {
        super(diagramTypeProvider);
        this.setIndependenceSolver(null);
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IConfigurationElement[] extensions = reg.getConfigurationElementsFor("org.eclipse.fmc.blockdiagram.editor.meta.profile");
        if (extensions.length == 1) {
            try {
                this.stereoTypeProvider = (IStereotypeProvider)extensions[0].createExecutableExtension("stereotypeProvider");
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }

    public IUpdateFeature getUpdateFeature(IUpdateContext context) {
        if (context.getPictogramElement() instanceof ContainerShape) {
            if (this.typeChecker.isAgent(context.getPictogramElement())) {
                return new AgentUpdateFeature((IFeatureProvider)this, this.stereoTypeProvider);
            }
            if (this.typeChecker.isStorage(context.getPictogramElement())) {
                return new StorageUpdateMetaFeature((IFeatureProvider)this, this.stereoTypeProvider);
            }
            if (this.typeChecker.isAreaBorder(context.getPictogramElement())) {
                return new CommentUpdateMetaFeature((IFeatureProvider)this);
            }
            return new FMCNodeUpdateFeature((IFeatureProvider)this, this.stereoTypeProvider);
        }
        if (context.getPictogramElement() instanceof Connection) {
            if (this.typeChecker.isCommunicationChannel((PictogramElement)((Connection)context.getPictogramElement()))) {
                return new CommunicationChannelUpdateFeature((IFeatureProvider)this, this.stereoTypeProvider);
            }
            return new AccessUpdateFeature((IFeatureProvider)this, this.stereoTypeProvider);
        }
        return super.getUpdateFeature(context);
    }

    public IDeleteFeature getDeleteFeature(IDeleteContext context) {
        if (context != null && FMCUtil.getBO((PictogramElement)context.getPictogramElement()) instanceof FMCNode) {
            return new FMCNodeDeleteFeature((IFeatureProvider)this);
        }
        return new DefaultDeleteFeature((IFeatureProvider)this);
    }

    public ICreateFeature[] getCreateFeatures() {
        return new ICreateFeature[]{new ShapeCreateMetaFeature((IFeatureProvider)this, "Agent", "Agent", FmcPackage.Literals.AGENT, "org.eclipse.fmc.IconAgent"), new ShapeCreateMetaFeature((IFeatureProvider)this, "Agent L", "Agent L", FmcPackage.Literals.AGENT, ShapeStyle.L, "org.eclipse.fmc.IconAgent_L"), new ShapeCreateMetaFeature((IFeatureProvider)this, "Agent U", "Agent U", FmcPackage.Literals.AGENT, ShapeStyle.U, "org.eclipse.fmc.IconAgent_U"), new ShapeCreateMetaFeature((IFeatureProvider)this, "Storage", "Storage", FmcPackage.Literals.STORAGE, "org.eclipse.fmc.IconStorage"), new ShapeCreateMetaFeature((IFeatureProvider)this, "Storage_L", "Storage_L", FmcPackage.Literals.STORAGE, ShapeStyle.L, "org.eclipse.fmc.IconStorage_L"), new ShapeCreateMetaFeature((IFeatureProvider)this, "Storage_U", "Storage_U", FmcPackage.Literals.STORAGE, ShapeStyle.U, "org.eclipse.fmc.IconStorage_U"), new HumanAgentCreateMetaFeature((IFeatureProvider)this, "HumanAgent", "HumanAgent", FmcPackage.Literals.AGENT, "org.eclipse.fmc.IconHumanAgent"), new ShapeCreateMetaFeature((IFeatureProvider)this, "StructureVariance", "StructureVariance", FmcPackage.Literals.STRUCTURE_VARIANCE, "org.eclipse.fmc.IconStructureVariance"), new ShapeCreateMetaFeature((IFeatureProvider)this, "Text", CommentType.TEXT.toString(), FmcPackage.Literals.COMMENT, "org.eclipse.fmc.Text"), new ShapeCreateMetaFeature((IFeatureProvider)this, "Common Feature Area", CommentType.COMMONFEATUREAREA.toString(), FmcPackage.Literals.COMMENT, "org.eclipse.fmc.IconCommonFeatureArea"), new ShapeCreateMetaFeature((IFeatureProvider)this, "Brace", CommentType.BRACE.toString(), FmcPackage.Literals.COMMENT, "org.eclipse.fmc.IconBrace"), new ShapeCreateMetaFeature((IFeatureProvider)this, "AreaBorder", CommentType.AREABORDER.toString(), FmcPackage.Literals.COMMENT, "org.eclipse.fmc.IconAreaBorder"), new ShapeCreateMetaFeature((IFeatureProvider)this, "Dots", CommentType.DOTS.toString(), FmcPackage.Literals.COMMENT, "org.eclipse.fmc.Dots"), new ShapeCreateFeature((IFeatureProvider)this, "Anchor", "", (Object)FMCType.Anchor, "org.eclipse.fmc.Anchor")};
    }

    public IDirectEditingFeature getDirectEditingFeature(IDirectEditingContext context) {
        if (context.getGraphicsAlgorithm() instanceof Text || context.getGraphicsAlgorithm() instanceof MultiText) {
            return new TextDirectEditingMetaFeature((IFeatureProvider)this, this.stereoTypeProvider);
        }
        return super.getDirectEditingFeature(context);
    }

    public IAddFeature getAddFeature(IAddContext context) {
        if (context.getNewObject() == FMCType.Invisible) {
            return new InvisibleShapeAddFeature((IFeatureProvider)this);
        }
        if (context.getNewObject() == FMCType.Dots) {
            return new DotsConnectionAddMetaFeature((IFeatureProvider)this, (ConnectionStyle)context.getProperty((Object)"graphicalType"));
        }
        if (context.getNewObject() == FMCType.Anchor) {
            return new AnchorAddFeature((IFeatureProvider)this);
        }
        AddFeatureVisitor visitor = new AddFeatureVisitor(this);
        return (IAddFeature)visitor.visit((FMCElement)context.getNewObject(), context);
    }

    public IPasteFeature getPasteFeature(IPasteContext context) {
        DiagramBehavior diagramBehavior = (DiagramBehavior)this.getDiagramTypeProvider().getDiagramBehavior();
        Point mouseLoc = diagramBehavior.getMouseLocation();
        context.putProperty((Object)"mouseX", (Object)mouseLoc.x());
        context.putProperty((Object)"mouseY", (Object)mouseLoc.y());
        return new ShapePasteMetaFeature((IFeatureProvider)this);
    }

    public ICreateConnectionFeature[] getCreateConnectionFeatures() {
        return new ICreateConnectionFeature[]{new ConnectionCreateMetaFeature((IFeatureProvider)this, "Modify Access", "", FmcPackage.Literals.ACCESS, ConnectionStyle.COMPOSITE, "org.eclipse.fmc.IconModifyAccess", AccessType.RW), new ConnectionCreateMetaFeature((IFeatureProvider)this, "Unidirectional Access", "", FmcPackage.Literals.ACCESS, ConnectionStyle.MANHATTAN, "org.eclipse.fmc.IconUnidirectionalAccessMh"), new ConnectionCreateMetaFeature((IFeatureProvider)this, "Unidirectional Access", "", FmcPackage.Literals.ACCESS, ConnectionStyle.NORMAL, "org.eclipse.fmc.IconUnidirectionalAccess"), new ConnectionCreateMetaFeature((IFeatureProvider)this, "Bidirectional Access", "", FmcPackage.Literals.ACCESS, ConnectionStyle.MANHATTAN, "org.eclipse.fmc.IconBidirectionalAccessMh", AccessType.UNSPECIFIED), new ConnectionCreateMetaFeature((IFeatureProvider)this, "Bidirectional Access", "", FmcPackage.Literals.ACCESS, ConnectionStyle.NORMAL, "org.eclipse.fmc.IconBidirectionalAccess", AccessType.UNSPECIFIED), new CommunicationChannelCreateFeature((IFeatureProvider)this, "Unidirectional Communication Channel", "", FmcPackage.Literals.CHANNEL, ConnectionStyle.MANHATTAN, "org.eclipse.fmc.IconUnidirectionalCommunicationChannelMh", DataflowDirection.DEFAULT, RequestDirection.UNSPECIFIED), new CommunicationChannelCreateFeature((IFeatureProvider)this, "Unidirectional Communication Channel", "", FmcPackage.Literals.CHANNEL, ConnectionStyle.NORMAL, "org.eclipse.fmc.IconUnidirectionalCommunicationChannel", DataflowDirection.DEFAULT, RequestDirection.UNSPECIFIED), new CommunicationChannelCreateFeature((IFeatureProvider)this, "Bidirectional Communication Channel", "", FmcPackage.Literals.CHANNEL, ConnectionStyle.MANHATTAN, "org.eclipse.fmc.IconBidirectionalCommunicationChannelMh", DataflowDirection.UNSPECIFIED, RequestDirection.UNSPECIFIED), new CommunicationChannelCreateFeature((IFeatureProvider)this, "Bidirectional Communication Channel", "", FmcPackage.Literals.CHANNEL, ConnectionStyle.NORMAL, "org.eclipse.fmc.IconBidirectionalCommunicationChannel", DataflowDirection.UNSPECIFIED, RequestDirection.UNSPECIFIED), new CommunicationChannelCreateFeature((IFeatureProvider)this, "Request-Response Communication Channel", "", FmcPackage.Literals.CHANNEL, ConnectionStyle.MANHATTAN, "org.eclipse.fmc.IconRequestResponseCommunicationChannelMh", DataflowDirection.UNSPECIFIED, RequestDirection.REQUEST), new CommunicationChannelCreateFeature((IFeatureProvider)this, "Request-Response Communication Channel", "", FmcPackage.Literals.CHANNEL, ConnectionStyle.NORMAL, "org.eclipse.fmc.IconRequestResponseCommunicationChannel", DataflowDirection.DEFAULT, RequestDirection.REQUEST), new DotsCreateFeature((IFeatureProvider)this, "Dots", "", FMCType.Dots, ConnectionStyle.NORMAL, "org.eclipse.fmc.Dots"), new ConnectionCreateFeature((IFeatureProvider)this, "Dots", "", (Object)FMCType.Dots, ConnectionStyle.MANHATTAN, "org.eclipse.fmc.DotsMh")};
    }

    public IReconnectionFeature getReconnectionFeature(IReconnectionContext context) {
        return new ReconnectionMetaFeature((IFeatureProvider)this);
    }
}

