/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fmc.blockdiagram.editor.property;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.impl.TransactionalEditingDomainImpl;
import org.eclipse.fmc.blockdiagram.editor.algorithm.connection.FMCConnectionAlgorithm;
import org.eclipse.fmc.blockdiagram.editor.algorithm.connection.FMCConnectionAlgorithmFactory;
import org.eclipse.fmc.blockdiagram.editor.algorithm.node.FMCNodeAlgorithm;
import org.eclipse.fmc.blockdiagram.editor.algorithm.node.FMCNodeAlgorithmFactory;
import org.eclipse.fmc.blockdiagram.editor.algorithm.node.LPolygonAlgorithm;
import org.eclipse.fmc.blockdiagram.editor.algorithm.node.RotatableNode;
import org.eclipse.fmc.blockdiagram.editor.algorithm.node.UPolygonAlgorithm;
import org.eclipse.fmc.blockdiagram.editor.model.ConnectionStyle;
import org.eclipse.fmc.blockdiagram.editor.model.FMCType;
import org.eclipse.fmc.blockdiagram.editor.model.FMCTypeChecker;
import org.eclipse.fmc.blockdiagram.editor.model.FMCTypeCheckerFactory;
import org.eclipse.fmc.blockdiagram.editor.model.ShapeStyle;
import org.eclipse.fmc.blockdiagram.editor.util.FMCUtil;
import org.eclipse.fmc.mm.DataflowDirection;
import org.eclipse.fmc.mm.RequestDirection;
import org.eclipse.graphiti.features.IAddFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IRemoveFeature;
import org.eclipse.graphiti.features.IResizeShapeFeature;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.IRemoveContext;
import org.eclipse.graphiti.features.context.IResizeShapeContext;
import org.eclipse.graphiti.features.context.impl.AddConnectionContext;
import org.eclipse.graphiti.features.context.impl.RemoveContext;
import org.eclipse.graphiti.features.context.impl.ResizeShapeContext;
import org.eclipse.graphiti.mm.GraphicsAlgorithmContainer;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Polygon;
import org.eclipse.graphiti.mm.algorithms.styles.Color;
import org.eclipse.graphiti.mm.algorithms.styles.Style;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;

public class PropertyActions {
    private FMCTypeChecker helper = FMCTypeCheckerFactory.getInstance();
    private FMCNodeAlgorithmFactory factory = FMCNodeAlgorithmFactory.getInstance();
    private FMCConnectionAlgorithmFactory conFactory = FMCConnectionAlgorithmFactory.getInstance();
    private final TransactionalEditingDomain editingDomain;
    private final Diagram diagram;
    private final IFeatureProvider provider;

    public PropertyActions(Diagram diagram, IFeatureProvider provider, TransactionalEditingDomain editingDomain) {
        this.diagram = diagram;
        this.provider = provider;
        this.editingDomain = editingDomain;
    }

    void changeDataFlowDirection(final Connection con, final int selectionIndex) {
        this.editingDomain.getCommandStack().execute((Command)new RecordingCommand(this.editingDomain){

            protected void doExecute() {
                if (PropertyActions.this.isWriteTransaction(PropertyActions.this.editingDomain)) {
                    FMCConnectionAlgorithm algorithm = PropertyActions.this.conFactory.getAlgorithm((PictogramElement)con);
                    switch (selectionIndex) {
                        case 0: {
                            algorithm.setDirection(con, DataflowDirection.UNSPECIFIED, PropertyActions.this.diagram);
                            break;
                        }
                        case 1: {
                            algorithm.setDirection(con, DataflowDirection.DEFAULT, PropertyActions.this.diagram);
                            break;
                        }
                        case 2: {
                            algorithm.setDirection(con, DataflowDirection.OTHER, PropertyActions.this.diagram);
                            break;
                        }
                    }
                }
            }
        });
    }

    void changeRequestDirection(final Connection con, final int selectionIndex) {
        this.editingDomain.getCommandStack().execute((Command)new RecordingCommand(this.editingDomain){

            protected void doExecute() {
                if (PropertyActions.this.isWriteTransaction(PropertyActions.this.editingDomain)) {
                    FMCConnectionAlgorithm algorithm = PropertyActions.this.conFactory.getAlgorithm((PictogramElement)con);
                    switch (selectionIndex) {
                        case 0: {
                            algorithm.setRequestDirection(con, RequestDirection.UNSPECIFIED, PropertyActions.this.diagram);
                            break;
                        }
                        case 1: {
                            algorithm.setRequestDirection(con, RequestDirection.REQUEST, PropertyActions.this.diagram);
                            break;
                        }
                        case 2: {
                            algorithm.setRequestDirection(con, RequestDirection.RESPONSE, PropertyActions.this.diagram);
                            break;
                        }
                        case 3: {
                            algorithm.setRequestDirection(con, RequestDirection.REQUESTRESPONSE, PropertyActions.this.diagram);
                            break;
                        }
                    }
                }
            }
        });
    }

    void rotate(final int angleDegrees, final PictogramElement picto) {
        this.editingDomain.getCommandStack().execute((Command)new RecordingCommand(this.editingDomain){

            protected void doExecute() {
                if (PropertyActions.this.isWriteTransaction(PropertyActions.this.editingDomain)) {
                    GraphicsAlgorithm invisibleGa = picto.getGraphicsAlgorithm();
                    FMCNodeAlgorithm na = FMCNodeAlgorithmFactory.getInstance().getShape(picto);
                    if (na instanceof RotatableNode) {
                        RotatableNode rn = (RotatableNode)((Object)na);
                        int oldAngle = rn.getAngle(invisibleGa);
                        int i = 0;
                        while (i < (angleDegrees + 360 - oldAngle) / 90 % 4) {
                            rn.rotate90Right(invisibleGa);
                            ++i;
                        }
                    }
                }
            }
        });
    }

    void resizeBottomPart(final int size, final PictogramElement picto) {
        final LPolygonAlgorithm lPoly = (LPolygonAlgorithm)((Object)this.factory.getShape(picto));
        if (lPoly.getBottomPartSize((Polygon)picto.getGraphicsAlgorithm()) != size) {
            this.editingDomain.getCommandStack().execute((Command)new RecordingCommand(this.editingDomain){

                protected void doExecute() {
                    if (PropertyActions.this.isWriteTransaction(PropertyActions.this.editingDomain)) {
                        lPoly.resizeBottomPart((Polygon)picto.getGraphicsAlgorithm(), size);
                    }
                }
            });
        }
    }

    void resizeRightPart(final int size, final PictogramElement picto) {
        final LPolygonAlgorithm lPoly = (LPolygonAlgorithm)((Object)this.factory.getShape(picto));
        if (lPoly.getRightPartSize((Polygon)picto.getGraphicsAlgorithm()) != size) {
            this.editingDomain.getCommandStack().execute((Command)new RecordingCommand(this.editingDomain){

                protected void doExecute() {
                    if (PropertyActions.this.isWriteTransaction(PropertyActions.this.editingDomain)) {
                        lPoly.resizeRightPart((Polygon)picto.getGraphicsAlgorithm(), size);
                    }
                }
            });
        }
    }

    void resizeLeftPart(final int size, final PictogramElement picto) {
        final UPolygonAlgorithm uPoly = (UPolygonAlgorithm)((Object)this.factory.getShape(picto));
        if (uPoly.getLeftPartSize((Polygon)picto.getGraphicsAlgorithm()) != size) {
            this.editingDomain.getCommandStack().execute((Command)new RecordingCommand(this.editingDomain){

                protected void doExecute() {
                    if (PropertyActions.this.isWriteTransaction(PropertyActions.this.editingDomain)) {
                        uPoly.resizeLeftPart((Polygon)picto.getGraphicsAlgorithm(), size);
                    }
                }
            });
        }
    }

    void resize(final int x, final int y, final int width, final int height, final Shape shape) {
        this.editingDomain.getCommandStack().execute((Command)new RecordingCommand(this.editingDomain){

            protected void doExecute() {
                if (PropertyActions.this.isWriteTransaction(PropertyActions.this.editingDomain)) {
                    ResizeShapeContext ctx = new ResizeShapeContext(shape);
                    ctx.setX(x);
                    ctx.setY(y);
                    ctx.setWidth(width);
                    ctx.setHeight(height);
                    if (shape instanceof Diagram) {
                        shape.getGraphicsAlgorithm().setWidth(width);
                        shape.getGraphicsAlgorithm().setHeight(height);
                    } else {
                        IResizeShapeFeature resizeShapeFeature = PropertyActions.this.provider.getResizeShapeFeature((IResizeShapeContext)ctx);
                        if (resizeShapeFeature.canExecute((IContext)ctx)) {
                            resizeShapeFeature.execute((IContext)ctx);
                        }
                    }
                }
            }
        });
    }

    private boolean isWriteTransaction(TransactionalEditingDomain domain) {
        if (domain instanceof TransactionalEditingDomainImpl) {
            return !((TransactionalEditingDomainImpl)domain).getActiveTransaction().isReadOnly();
        }
        return true;
    }

    void changeMultiInstance(final ContainerShape shape, final boolean multipleInstances) {
        this.editingDomain.getCommandStack().execute((Command)new RecordingCommand(this.editingDomain){

            protected void doExecute() {
                FMCNodeAlgorithm shapeAlgorithm;
                if (PropertyActions.this.isWriteTransaction(PropertyActions.this.editingDomain) && (shapeAlgorithm = PropertyActions.this.factory.getShape((PictogramElement)shape)) != null) {
                    shapeAlgorithm.setMultipleInstances(shape, PropertyActions.this.provider, multipleInstances);
                }
            }
        });
    }

    void changeAgentType(final ContainerShape shape, final boolean human) {
        this.editingDomain.getCommandStack().execute((Command)new RecordingCommand(this.editingDomain){

            protected void doExecute() {
                if (PropertyActions.this.isWriteTransaction(PropertyActions.this.editingDomain)) {
                    GraphicsAlgorithm alg = shape.getGraphicsAlgorithm();
                    if (human) {
                        PropertyActions.this.factory.getHumanAgent().addHumanFigure(PropertyActions.this.diagram, shape, alg.getWidth());
                        PropertyActions.this.provider.link((PictogramElement)shape, (Object)FMCType.HumanAgent);
                    } else {
                        PropertyActions.this.factory.getHumanAgent().removeHumanFigure((PictogramElement)shape);
                        PropertyActions.this.provider.link((PictogramElement)shape, (Object)FMCType.Agent);
                    }
                }
            }
        });
    }

    public void changeShapeStyle(final PictogramElement element, final int selectionIndex) {
        this.editingDomain.getCommandStack().execute((Command)new RecordingCommand(this.editingDomain){

            protected void doExecute() {
                if (PropertyActions.this.isWriteTransaction(PropertyActions.this.editingDomain)) {
                    FMCNodeAlgorithm algorithm = null;
                    ShapeStyle style = ShapeStyle.values()[selectionIndex];
                    if (PropertyActions.this.helper.isAgent(element)) {
                        algorithm = PropertyActions.this.factory.getAgentByShapestyle(style);
                    } else if (PropertyActions.this.helper.isStorage(element)) {
                        algorithm = PropertyActions.this.factory.getStorageByShapestyle(style);
                    }
                    if (algorithm != null) {
                        ContainerShape firstLevelContainer = (ContainerShape)element;
                        GraphicsAlgorithm firstLevelGa = firstLevelContainer.getGraphicsAlgorithm();
                        GraphicsAlgorithm oldSecondLevelGa = (GraphicsAlgorithm)firstLevelGa.getGraphicsAlgorithmChildren().get(0);
                        Color oldBackground = oldSecondLevelGa.getBackground();
                        Color oldForeground = oldSecondLevelGa.getForeground();
                        Double oldTransparency = oldSecondLevelGa.getTransparency();
                        Style oldStyle = oldSecondLevelGa.getStyle();
                        boolean isMultiple = algorithm.isMultipleInstances(firstLevelContainer);
                        firstLevelGa = algorithm.createGraphics(PropertyActions.this.diagram, (GraphicsAlgorithmContainer)firstLevelContainer, firstLevelGa.getX(), firstLevelGa.getY(), firstLevelGa.getWidth(), firstLevelGa.getHeight());
                        firstLevelGa.setBackground(oldBackground);
                        firstLevelGa.setForeground(oldForeground);
                        firstLevelGa.setTransparency(oldTransparency);
                        firstLevelGa.setStyle(oldStyle);
                        firstLevelGa.setLineVisible(Boolean.valueOf(false));
                        firstLevelGa.setFilled(Boolean.valueOf(false));
                        Graphiti.getGaService().setLocationAndSize(firstLevelGa, firstLevelGa.getX(), firstLevelGa.getY(), firstLevelGa.getWidth(), firstLevelGa.getHeight());
                        GraphicsAlgorithm secondLevelGa = algorithm.createGraphics(PropertyActions.this.diagram, (GraphicsAlgorithmContainer)firstLevelGa, 0, 0, firstLevelGa.getWidth(), firstLevelGa.getHeight());
                        secondLevelGa.setLineVisible(Boolean.valueOf(true));
                        secondLevelGa.setFilled(Boolean.valueOf(true));
                        secondLevelGa.setBackground(oldBackground);
                        secondLevelGa.setForeground(oldForeground);
                        secondLevelGa.setTransparency(oldTransparency);
                        secondLevelGa.setStyle(oldStyle);
                        secondLevelGa.setParentGraphicsAlgorithm(firstLevelGa);
                        if (isMultiple) {
                            algorithm.setMultipleInstances(firstLevelContainer, PropertyActions.this.provider, true);
                        }
                        algorithm.relocateText(secondLevelGa);
                        algorithm.createBoxAnchorSet((Shape)firstLevelContainer);
                    }
                }
            }
        });
    }

    void changeGridUnit(final Diagram diagram, final int gridUnit) {
        this.editingDomain.getCommandStack().execute((Command)new RecordingCommand(this.editingDomain){

            protected void doExecute() {
                if (PropertyActions.this.isWriteTransaction(PropertyActions.this.editingDomain)) {
                    diagram.setGridUnit(gridUnit);
                }
            }
        });
    }

    void changeChannelLocation(final Connection con, final double location) {
        this.editingDomain.getCommandStack().execute((Command)new RecordingCommand(this.editingDomain){

            protected void doExecute() {
                if (PropertyActions.this.isWriteTransaction(PropertyActions.this.editingDomain)) {
                    PropertyActions.this.conFactory.getAlgorithm((PictogramElement)con).setChannelLocation(con, PropertyActions.this.diagram, location);
                }
            }
        });
    }

    void visualizeAnchors(final ContainerShape container, final boolean visible) {
        this.editingDomain.getCommandStack().execute((Command)new RecordingCommand(this.editingDomain){

            protected void doExecute() {
                if (PropertyActions.this.isWriteTransaction(PropertyActions.this.editingDomain)) {
                    for (Shape child : container.getChildren()) {
                        PropertyActions.this.visualizeAnchors(child, visible);
                    }
                }
            }
        });
    }

    void visualizeAnchors(final Shape shape, final boolean visible) {
        this.editingDomain.getCommandStack().execute((Command)new RecordingCommand(this.editingDomain){

            protected void doExecute() {
                FMCNodeAlgorithm nodeAlgo;
                if (PropertyActions.this.isWriteTransaction(PropertyActions.this.editingDomain) && (nodeAlgo = PropertyActions.this.factory.getShape((PictogramElement)shape)) != null) {
                    nodeAlgo.setBoxAnchorsVisible(shape, visible);
                }
            }
        });
    }

    void enableAnchors(final ContainerShape container, final boolean enabled) {
        this.editingDomain.getCommandStack().execute((Command)new RecordingCommand(this.editingDomain){

            protected void doExecute() {
                if (PropertyActions.this.isWriteTransaction(PropertyActions.this.editingDomain)) {
                    for (Shape child : container.getChildren()) {
                        PropertyActions.this.enableAnchors(child, enabled);
                    }
                }
            }
        });
    }

    boolean enableAnchors(final Shape shape, final boolean enabled) {
        FMCNodeAlgorithm nodeAlgo = this.factory.getShape((PictogramElement)shape);
        boolean created = nodeAlgo != null && enabled && !nodeAlgo.hasUnusedAnchors(shape);
        this.editingDomain.getCommandStack().execute((Command)new RecordingCommand(this.editingDomain){

            protected void doExecute() {
                FMCNodeAlgorithm nodeAlgo;
                if (PropertyActions.this.isWriteTransaction(PropertyActions.this.editingDomain) && (nodeAlgo = PropertyActions.this.factory.getShape((PictogramElement)shape)) != null) {
                    if (enabled && !nodeAlgo.hasUnusedAnchors(shape)) {
                        nodeAlgo.createBoxAnchorSet(shape);
                    } else {
                        nodeAlgo.removeUnusedBoxAnchors(shape);
                    }
                }
            }
        });
        return created;
    }

    public void changeConnectionType(final Connection connection, final int selectionIndex) {
        this.editingDomain.getCommandStack().execute((Command)new RecordingCommand(this.editingDomain){

            protected void doExecute() {
                if (PropertyActions.this.isWriteTransaction(PropertyActions.this.editingDomain)) {
                    FMCConnectionAlgorithm algorithm = PropertyActions.this.conFactory.getAlgorithm((PictogramElement)connection);
                    double channelLocation = algorithm.getChannelLocation(connection);
                    DataflowDirection direction = algorithm.getDirection(connection);
                    RequestDirection requestDirection = algorithm.getRequestDirection(connection);
                    Object modelObject = FMCUtil.getModelObject((PictogramElement)connection);
                    Anchor start = connection.getStart();
                    Anchor end = connection.getEnd();
                    RemoveContext remCtx = new RemoveContext((PictogramElement)connection);
                    IRemoveFeature removeFeature = PropertyActions.this.provider.getRemoveFeature((IRemoveContext)remCtx);
                    if (removeFeature.canExecute((IContext)remCtx)) {
                        removeFeature.execute((IContext)remCtx);
                    }
                    AddConnectionContext addCtx = new AddConnectionContext(start, end);
                    addCtx.setNewObject(modelObject);
                    switch (selectionIndex) {
                        case 0: {
                            addCtx.putProperty((Object)"graphicalType", (Object)ConnectionStyle.MANHATTAN);
                            break;
                        }
                        case 1: {
                            addCtx.putProperty((Object)"graphicalType", (Object)ConnectionStyle.NORMAL);
                            break;
                        }
                    }
                    IAddFeature addFeature = PropertyActions.this.provider.getAddFeature((IAddContext)addCtx);
                    if (addFeature.canExecute((IContext)addCtx)) {
                        addFeature.execute((IContext)addCtx);
                        EList connections = PropertyActions.this.provider.getDiagramTypeProvider().getDiagram().getConnections();
                        Connection newConnection = (Connection)connections.get(connections.size() - 1);
                        algorithm.setChannelLocation(newConnection, PropertyActions.this.diagram, channelLocation);
                        algorithm.setDirection(newConnection, direction, PropertyActions.this.diagram);
                        algorithm.setRequestDirection(newConnection, requestDirection, PropertyActions.this.diagram);
                    }
                }
            }
        });
    }
}

