/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.ajp;

import org.apache.coyote.AbstractProtocol;
import org.apache.coyote.Processor;
import org.apache.coyote.ajp.AbstractAjpProtocol;
import org.apache.coyote.ajp.AjpAprProcessor;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.AprEndpoint;
import org.apache.tomcat.util.net.SocketWrapper;

public class AjpAprProtocol
extends AbstractAjpProtocol<Long> {
    private static final Log log = LogFactory.getLog(AjpAprProtocol.class);
    private AjpConnectionHandler cHandler;

    @Override
    protected Log getLog() {
        return log;
    }

    @Override
    protected AbstractEndpoint.Handler getHandler() {
        return this.cHandler;
    }

    @Override
    public boolean isAprRequired() {
        return true;
    }

    public AjpAprProtocol() {
        this.endpoint = new AprEndpoint();
        this.cHandler = new AjpConnectionHandler(this);
        ((AprEndpoint)this.endpoint).setHandler(this.cHandler);
        this.setSoLinger(-1);
        this.setSoTimeout(-1);
        this.setTcpNoDelay(true);
        ((AprEndpoint)this.endpoint).setUseSendfile(false);
    }

    public int getPollTime() {
        return ((AprEndpoint)this.endpoint).getPollTime();
    }

    public void setPollTime(int pollTime) {
        ((AprEndpoint)this.endpoint).setPollTime(pollTime);
    }

    public void setPollerSize(int pollerSize) {
        this.endpoint.setMaxConnections(pollerSize);
    }

    public int getPollerSize() {
        return this.endpoint.getMaxConnections();
    }

    @Override
    protected String getNamePrefix() {
        return "ajp-apr";
    }

    protected static class AjpConnectionHandler
    extends AbstractAjpProtocol.AbstractAjpConnectionHandler<Long, AjpAprProcessor>
    implements AprEndpoint.Handler {
        protected AjpAprProtocol proto;

        public AjpConnectionHandler(AjpAprProtocol proto) {
            this.proto = proto;
        }

        @Override
        protected AbstractProtocol<Long> getProtocol() {
            return this.proto;
        }

        @Override
        protected Log getLog() {
            return log;
        }

        @Override
        public void release(SocketWrapper<Long> socket, Processor<Long> processor, boolean isSocketClosing, boolean addToPoller) {
            processor.recycle(isSocketClosing);
            this.recycledProcessors.offer(processor);
            if (addToPoller) {
                ((AprEndpoint)this.proto.endpoint).getPoller().add(socket.getSocket(), this.proto.endpoint.getKeepAliveTimeout(), true, false);
            }
        }

        @Override
        protected AjpAprProcessor createProcessor() {
            AjpAprProcessor processor = new AjpAprProcessor(this.proto.packetSize, (AprEndpoint)this.proto.endpoint);
            processor.setAdapter(this.proto.adapter);
            processor.setTomcatAuthentication(this.proto.tomcatAuthentication);
            processor.setRequiredSecret(this.proto.requiredSecret);
            processor.setClientCertProvider(this.proto.getClientCertProvider());
            this.register(processor);
            return processor;
        }
    }
}

