/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.web.tomcat.internal;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Set;
import javax.servlet.ServletContext;
import org.apache.jasper.servlet.JasperInitializer;
import org.apache.tomcat.Jar;
import org.apache.tomcat.JarScanFilter;
import org.apache.tomcat.JarScanType;
import org.apache.tomcat.JarScanner;
import org.apache.tomcat.JarScannerCallback;
import org.apache.tomcat.util.scan.JarFactory;
import org.apache.tomcat.websocket.server.WsSci;
import org.eclipse.gemini.web.tomcat.internal.BundleDependenciesJarScanFilter;
import org.eclipse.gemini.web.tomcat.internal.loader.BundleWebappClassLoader;
import org.eclipse.gemini.web.tomcat.internal.support.BundleDependencyDeterminer;
import org.eclipse.gemini.web.tomcat.internal.support.BundleFileResolver;
import org.eclipse.osgi.service.urlconversion.URLConverter;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class BundleDependenciesJarScanner
implements JarScanner {
    private static final String JAR_URL_SUFFIX = "!/";
    private static final String JAR_URL_PREFIX = "jar:";
    private static final Logger LOGGER = LoggerFactory.getLogger(BundleDependenciesJarScanner.class);
    private final BundleDependencyDeterminer bundleDependencyDeterminer;
    private final BundleFileResolver bundleFileResolver;
    private final ServiceTracker<?, ?> urlConverterTracker;
    private JarScanFilter jarScanFilter;

    BundleDependenciesJarScanner(BundleDependencyDeterminer bundleDependencyDeterminer, BundleFileResolver bundleFileResolver, BundleContext bundleContext, ServiceTracker<?, ?> urlConverterTracker) {
        this.bundleDependencyDeterminer = bundleDependencyDeterminer;
        this.bundleFileResolver = bundleFileResolver;
        this.jarScanFilter = new BundleDependenciesJarScanFilter(bundleContext);
        this.urlConverterTracker = urlConverterTracker;
    }

    public JarScanFilter getJarScanFilter() {
        return this.jarScanFilter;
    }

    public void setJarScanFilter(JarScanFilter jarScanFilter) {
        this.jarScanFilter = jarScanFilter;
    }

    public void scan(JarScanType jarScanType, ServletContext context, JarScannerCallback callback) {
        ClassLoader classLoader = context.getClassLoader();
        if (classLoader instanceof BundleWebappClassLoader) {
            Bundle bundle = ((BundleWebappClassLoader)classLoader).getBundle();
            this.scanDependentBundles(bundle, jarScanType, callback);
        }
    }

    private void scanDependentBundles(Bundle rootBundle, JarScanType jarScanType, JarScannerCallback callback) {
        Bundle apacheJasperBundle;
        Bundle apacheWebsocketBundle = FrameworkUtil.getBundle(WsSci.class);
        if (apacheWebsocketBundle != null) {
            this.scanBundle(apacheWebsocketBundle, callback, false);
        }
        if ((apacheJasperBundle = FrameworkUtil.getBundle(JasperInitializer.class)) != null) {
            this.scanBundle(apacheJasperBundle, callback, false);
        }
        Set<Bundle> dependencies = this.bundleDependencyDeterminer.getDependencies(rootBundle);
        for (Bundle bundle : dependencies) {
            if (!this.getJarScanFilter().check(jarScanType, bundle.getSymbolicName())) continue;
            this.scanBundle(bundle, callback, true);
        }
    }

    private void scanBundle(Bundle bundle, JarScannerCallback callback, boolean isWebapp) {
        File bundleFile = this.bundleFileResolver.resolve(bundle);
        if (bundleFile != null) {
            this.scanBundleFile(bundleFile, callback, isWebapp);
        } else {
            URL root = bundle.getEntry("/");
            try {
                try {
                    Object converter = this.urlConverterTracker.getService();
                    if (converter != null) {
                        root = ((URLConverter)converter).resolve(root);
                    }
                }
                catch (Exception exception) {}
                if (root != null) {
                    if ("file".equals(root.getProtocol())) {
                        this.scanBundleFile(new File(root.getPath()), callback, isWebapp);
                    } else if ("jar".equals(root.getProtocol())) {
                        this.scanBundleUrl(root, callback, isWebapp);
                    } else {
                        URL bundleUrl = new URL(JAR_URL_PREFIX + root.toExternalForm() + JAR_URL_SUFFIX);
                        this.scanBundleUrl(bundleUrl, callback, isWebapp);
                    }
                } else {
                    LOGGER.warn("Failed to scan the bundle [" + bundle + "].");
                }
            }
            catch (IOException iOException) {
                LOGGER.warn("Failed to scan the bundle location [" + root + "].");
            }
        }
    }

    private void scanBundleFile(File bundleFile, JarScannerCallback callback, boolean isWebapp) {
        if (bundleFile.isDirectory()) {
            try {
                callback.scan(bundleFile, null, isWebapp);
            }
            catch (IOException e) {
                LOGGER.warn("Failure when attempting to scan bundle file [" + bundleFile + "].", (Throwable)e);
            }
        } else {
            URL bundleUrl;
            try {
                bundleUrl = new URL(JAR_URL_PREFIX + bundleFile.toURI().toURL() + JAR_URL_SUFFIX);
            }
            catch (MalformedURLException malformedURLException) {
                LOGGER.warn("Failed to create jar: url for bundle file [" + bundleFile + "].");
                return;
            }
            this.scanBundleUrl(bundleUrl, callback, isWebapp);
        }
    }

    private void scanBundleUrl(URL url, JarScannerCallback callback, boolean isWebapp) {
        if ("jar".equals(url.getProtocol()) || url.getPath().endsWith(".jar")) {
            try {
                Throwable throwable = null;
                Object var5_7 = null;
                try (Jar jar = JarFactory.newInstance((URL)url);){
                    callback.scan(jar, null, isWebapp);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                LOGGER.warn("Failure when attempting to scan bundle via jar URL [" + url + "].", (Throwable)e);
            }
        }
    }
}

