/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.dsl.debug;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.gemoc.dsl.debug.DebugPackage;
import org.eclipse.gemoc.dsl.debug.DebugTarget;
import org.eclipse.gemoc.dsl.debug.DebugTargetState;
import org.eclipse.gemoc.dsl.debug.Register;
import org.eclipse.gemoc.dsl.debug.RegisterGroup;
import org.eclipse.gemoc.dsl.debug.StackFrame;
import org.eclipse.gemoc.dsl.debug.State;
import org.eclipse.gemoc.dsl.debug.Thread;
import org.eclipse.gemoc.dsl.debug.ThreadUtils;
import org.eclipse.gemoc.dsl.debug.Variable;

public final class DebugTargetUtils {
    private DebugTargetUtils() {
    }

    public static DebugTarget createDebugTarget(String name, EObject context) {
        DebugTarget res = DebugPackage.eINSTANCE.getDebugFactory().createDebugTarget();
        if (name == null) {
            throw new IllegalArgumentException("the debug target name can't be null.");
        }
        if (context == null) {
            throw new IllegalArgumentException("the debug target context can't be null.");
        }
        res.setName(name);
        res.setContext(context);
        res.setState(DebugTargetState.CONNECTED);
        return res;
    }

    public static void resumeRequest(DebugTarget target) {
        if (target.getState() != DebugTargetState.CONNECTED) {
            throw new IllegalStateException("can't resume a not connected debug target.");
        }
        if (DebugTargetUtils.canResume(target)) {
            for (Thread thread : target.getThreads()) {
                if (!ThreadUtils.canResume(thread)) continue;
                ThreadUtils.resumedReply(thread);
            }
        }
    }

    public static boolean canResume(DebugTarget target) {
        boolean res = false;
        if (target.getState() == DebugTargetState.CONNECTED) {
            for (Thread thread : target.getThreads()) {
                if (!ThreadUtils.canResume(thread)) continue;
                res = true;
                break;
            }
        }
        return res;
    }

    public static void suspendRequest(DebugTarget target) {
        if (target.getState() != DebugTargetState.CONNECTED) {
            throw new IllegalStateException("can't suspend a not connected debug target.");
        }
        if (DebugTargetUtils.canSuspend(target)) {
            for (Thread thread : target.getThreads()) {
                if (!ThreadUtils.canSuspend(thread)) continue;
                ThreadUtils.suspendRequest(thread);
            }
        }
    }

    public static boolean canSuspend(DebugTarget target) {
        boolean res = false;
        if (target.getState() == DebugTargetState.CONNECTED) {
            for (Thread thread : target.getThreads()) {
                if (!ThreadUtils.canSuspend(thread)) continue;
                res = true;
                break;
            }
        }
        return res;
    }

    public static void terminateRequest(DebugTarget target) {
        if (!DebugTargetUtils.canTerminate(target)) {
            throw new IllegalStateException("can't terminate a not connected debug target.");
        }
        target.setState(DebugTargetState.TERMINATING);
    }

    public static boolean canTerminate(DebugTarget target) {
        return target.getState() == DebugTargetState.CONNECTED;
    }

    public static void terminatedReply(DebugTarget target) {
        if (target.getState() == DebugTargetState.TERMINATED || target.getState() == DebugTargetState.DISCONNECTED) {
            throw new IllegalStateException("can't terminale a not connected or a terminated debug target.");
        }
        target.setState(DebugTargetState.TERMINATED);
    }

    public static void disconnectRequest(DebugTarget target) {
        if (!DebugTargetUtils.canDisconnect(target)) {
            throw new IllegalStateException("can't disconnect a not connected debug target.");
        }
        target.setState(DebugTargetState.DISCONNECTED);
    }

    public static boolean canDisconnect(DebugTarget target) {
        return target.getState() == DebugTargetState.CONNECTED;
    }

    public static Thread spawnRunningThreadReply(DebugTarget target, String threadName, EObject threadContext) {
        if (DebugTargetUtils.canSpawnThread(target, threadName)) {
            Thread thread = DebugPackage.eINSTANCE.getDebugFactory().createThread();
            thread.setName(threadName);
            thread.setContext(threadContext);
            thread.setState(State.RUNNING);
            target.getThreads().add((Object)thread);
            return thread;
        }
        throw new IllegalStateException("can't spawn a thread for a not connected debug target or with a name already used by an other thread.");
    }

    public static void spawnSuspendedThreadReply(DebugTarget target, String threadName, String frameName, EObject threadContext, EObject frameInstruction, boolean canStepInto) {
        if (!DebugTargetUtils.canSpawnThread(target, threadName)) {
            throw new IllegalStateException("can't spawn a thread for a not connected debug target or with a name already used by an other thread.");
        }
        Thread thread = DebugPackage.eINSTANCE.getDebugFactory().createThread();
        thread.setName(threadName);
        thread.setContext(threadContext);
        thread.setState(State.SUSPENDED);
        StackFrame topFrame = DebugPackage.eINSTANCE.getDebugFactory().createStackFrame();
        topFrame.setName(frameName);
        topFrame.setCurrentInstruction(frameInstruction);
        topFrame.setCanStepIntoCurrentInstruction(canStepInto);
        topFrame.setCurrentInstruction(frameInstruction);
        topFrame.setContext(thread.getContext());
        thread.setBottomStackFrame(topFrame);
        thread.setTopStackFrame(topFrame);
        target.getThreads().add((Object)thread);
    }

    public static boolean canSpawnThread(DebugTarget target, String name) {
        return target.getState() == DebugTargetState.CONNECTED && DebugTargetUtils.getThread(target, name) == null;
    }

    public static Thread getThread(DebugTarget target, String name) {
        Thread res = null;
        for (Thread thread : target.getThreads()) {
            if (!name.equals(thread.getName())) continue;
            res = thread;
            break;
        }
        return res;
    }

    public static StackFrame getStackFrame(Thread thread, String name) {
        StackFrame res = null;
        StackFrame currentFrame = thread.getBottomStackFrame();
        while (currentFrame != null) {
            if (name.equals(currentFrame.getName())) {
                res = currentFrame;
                break;
            }
            currentFrame = currentFrame.getChildFrame();
        }
        return res;
    }

    public static Variable getVariable(StackFrame frame, String name) {
        Variable res = null;
        for (Variable variable : frame.getVariables()) {
            if (!name.equals(variable.getName())) continue;
            res = variable;
            break;
        }
        return res;
    }

    public static void setVariable(StackFrame frame, String declarationTypeName, String name, Object value, boolean supportModifications) {
        Variable variable = DebugTargetUtils.getVariable(frame, name);
        if (variable == null) {
            variable = DebugPackage.eINSTANCE.getDebugFactory().createVariable();
            variable.setDeclarationType(declarationTypeName);
            variable.setName(name);
            variable.setSupportModifications(supportModifications);
            frame.getVariables().add((Object)variable);
        } else {
            variable.setValueChanged(true);
        }
        variable.setValue(value);
    }

    public static RegisterGroup getRegisterGroup(StackFrame frame, String name) {
        RegisterGroup res = null;
        for (RegisterGroup registerGroup : frame.getRegisterGroups()) {
            if (!name.equals(registerGroup.getName())) continue;
            res = registerGroup;
            break;
        }
        return res;
    }

    public static Register getRegister(RegisterGroup group, String name) {
        Register res = null;
        for (Register register : group.getRegisters()) {
            if (!name.equals(register.getName())) continue;
            res = register;
            break;
        }
        return res;
    }

    public static void setRegister(RegisterGroup group, String name, Object value) {
        Register register = DebugTargetUtils.getRegister(group, name);
        if (register == null) {
            register = DebugPackage.eINSTANCE.getDebugFactory().createRegister();
            register.setName(name);
            group.getRegisters().add((Object)register);
        }
        register.setValue(value);
    }

    public static boolean isSuspended(DebugTarget target) {
        boolean res = true;
        for (Thread thread : target.getThreads()) {
            if (ThreadUtils.isSuspended(thread)) continue;
            res = false;
            break;
        }
        return res;
    }

    public static boolean isTerminated(DebugTarget target) {
        return target.getState() == DebugTargetState.TERMINATED;
    }
}

