/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.executionframework.extensions.sirius.debug;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.internal.movida.Movida;
import org.eclipse.sirius.business.internal.movida.registry.ViewpointRegistry;
import org.eclipse.sirius.business.internal.movida.registry.ViewpointURIConverter;
import org.eclipse.sirius.business.internal.session.danalysis.DAnalysisSessionImpl;
import org.eclipse.sirius.common.tools.api.editing.EditingDomainFactoryService;
import org.eclipse.sirius.common.tools.api.util.SiriusCrossReferenceAdapterImpl;
import org.eclipse.sirius.tools.internal.resource.ResourceSetUtil;
import org.eclipse.sirius.viewpoint.DAnalysis;
import org.eclipse.sirius.viewpoint.ViewpointFactory;

public final class DebugSessionFactory {
    public static final DebugSessionFactory INSTANCE = new DebugSessionFactory();

    private DebugSessionFactory() {
    }

    public Session createSession(ResourceSet set, URI sessionResourceURI) throws CoreException {
        return this.createSession(set, sessionResourceURI, (IProgressMonitor)new NullProgressMonitor());
    }

    public Session createSession(ResourceSet set, URI sessionResourceURI, IProgressMonitor monitor) throws CoreException {
        TransactionalEditingDomain transactionalEditingDomain = EditingDomainFactoryService.INSTANCE.getEditingDomainFactory().createEditingDomain(set);
        transactionalEditingDomain.getResourceSet().eAdapters().add((Object)new SiriusCrossReferenceAdapterImpl());
        if (Movida.isEnabled()) {
            transactionalEditingDomain.getResourceSet().setURIConverter((URIConverter)new ViewpointURIConverter((ViewpointRegistry)org.eclipse.sirius.business.api.componentization.ViewpointRegistry.getInstance()));
        }
        boolean alreadyExistingResource = this.exists(sessionResourceURI, transactionalEditingDomain.getResourceSet());
        Session session = null;
        session = alreadyExistingResource ? this.loadSessionModelResource(sessionResourceURI, transactionalEditingDomain, monitor) : this.createSessionResource(sessionResourceURI, transactionalEditingDomain, monitor);
        return session;
    }

    private boolean exists(URI sessionResourceURI, ResourceSet resourceSet) {
        boolean exists;
        block13: {
            exists = false;
            InputStream inputStream = null;
            try {
                try {
                    inputStream = resourceSet.getURIConverter().createInputStream(sessionResourceURI);
                    if (inputStream != null) {
                        exists = true;
                    }
                }
                catch (IOException iOException) {
                    if (inputStream == null) break block13;
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException2) {}
                }
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return exists;
    }

    private Session loadSessionModelResource(URI sessionResourceURI, TransactionalEditingDomain transactionalEditingDomain, IProgressMonitor monitor) throws CoreException {
        ResourceSet resourceSet = transactionalEditingDomain.getResourceSet();
        Session session = null;
        try {
            try {
                monitor.beginTask("Session loading", 4);
                Resource sessionModelResource = resourceSet.getResource(sessionResourceURI, true);
                if (sessionModelResource != null) {
                    DAnalysis analysis = null;
                    if (!sessionModelResource.getContents().isEmpty() && sessionModelResource.getContents().get(0) instanceof DAnalysis) {
                        analysis = (DAnalysis)sessionModelResource.getContents().get(0);
                        session = new DAnalysisSessionImpl(analysis);
                        monitor.worked(2);
                    } else {
                        session = this.createSessionResource(sessionResourceURI, transactionalEditingDomain, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
                    }
                }
            }
            catch (WrappedException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.sirius", "Error while loading representations file", (Throwable)e));
            }
        }
        finally {
            monitor.done();
            ResourceSetUtil.resetProgressMonitor((ResourceSet)resourceSet);
        }
        return session;
    }

    private Session createSessionResource(URI sessionResourceURI, TransactionalEditingDomain transactionalEditingDomain, IProgressMonitor monitor) throws CoreException {
        DAnalysisSessionImpl session = null;
        try {
            monitor.beginTask("Session creation", 2);
            Resource sessionModelResource = new ResourceSetImpl().createResource(sessionResourceURI);
            DAnalysis analysis = ViewpointFactory.eINSTANCE.createDAnalysis();
            sessionModelResource.getContents().add((Object)analysis);
            try {
                sessionModelResource.save(Collections.emptyMap());
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.sirius", "session creation failed", (Throwable)e));
            }
            monitor.worked(1);
            sessionModelResource = transactionalEditingDomain.getResourceSet().getResource(sessionResourceURI, true);
            if (sessionModelResource.getContents().isEmpty()) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.sirius", "session creation failed: the resource content is empty."));
            }
            analysis = (DAnalysis)sessionModelResource.getContents().get(0);
            session = new DAnalysisSessionImpl(analysis);
            monitor.worked(1);
        }
        finally {
            monitor.done();
        }
        return session;
    }

    public Session createDefaultSession(ResourceSet set, URI sessionResourceURI) throws CoreException {
        return this.createSession(set, sessionResourceURI, (IProgressMonitor)new NullProgressMonitor());
    }
}

