/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.addon.diffviewer.views;

import java.util.ArrayList;
import javafx.scene.Node;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.HBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.PathElement;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.Shape;
import org.eclipse.gemoc.addon.diffviewer.logic.Diff;

public class ValueView
extends HBox {
    private static final int HEIGHT = 8;
    private static final int H_MARGIN = 8;
    private static final int WIDTH = 24;

    private Shape getHatching(int length, int offset) {
        Path p = new Path();
        int i = 0;
        while ((double)i < (double)length / 2.5 + 1.0) {
            double x1 = (double)(i - 1) * 2.5 + (double)offset;
            double y1 = 8.0;
            double x2 = (double)(i + 1) * 2.5 + (double)offset;
            double y2 = 0.0;
            MoveTo move = new MoveTo(x1, 8.0);
            LineTo line = new LineTo(x2, 0.0);
            p.getElements().addAll((Object[])new PathElement[]{move, line});
            p.setStrokeWidth(1.0);
            ++i;
        }
        return p;
    }

    public void setSegments(Diff.DiffKind ... segmentParts) {
        if (segmentParts.length > 0) {
            int totalLength = 40 * segmentParts.length - 16;
            ArrayList<Object> rectangles = new ArrayList<Object>();
            int j = 0;
            ArrayList<Integer> segmentLengths = new ArrayList<Integer>();
            ArrayList<Diff.DiffKind> segmentTypes = new ArrayList<Diff.DiffKind>();
            segmentLengths.add(1);
            segmentTypes.add(segmentParts[0]);
            int i = 1;
            while (i < segmentParts.length) {
                if (segmentParts[i] != segmentParts[i - 1]) {
                    ++j;
                    segmentLengths.add(1);
                    segmentTypes.add(segmentParts[i]);
                } else {
                    segmentLengths.add(1 + (Integer)segmentLengths.remove(j));
                }
                ++i;
            }
            if (segmentLengths.size() > 1) {
                Rectangle r;
                Color lastC;
                Rectangle lastR;
                Color firstC;
                Rectangle firstR;
                Rectangle r2;
                int segmentCount = segmentLengths.size();
                int i2 = 1;
                while (i2 < segmentCount - 1) {
                    Rectangle s;
                    int length = 40 * (Integer)segmentLengths.get(i2);
                    switch ((Diff.DiffKind)((Object)segmentTypes.get(i2))) {
                        case EQ: {
                            s = new Rectangle((double)length, 8.0, (Paint)Color.BLUE);
                            break;
                        }
                        case SUBST: {
                            s = new Rectangle((double)length, 8.0, (Paint)Color.TOMATO);
                            break;
                        }
                        case IN: 
                        case DEL: {
                            r2 = new Rectangle((double)length, 8.0);
                            s = Shape.subtract((Shape)r2, (Shape)this.getHatching(length, 0));
                            s.setFill((Paint)Color.BROWN);
                            break;
                        }
                        default: {
                            s = null;
                        }
                    }
                    rectangles.add(s);
                    ++i2;
                }
                int l1 = 40 * (Integer)segmentLengths.get(0) - 8;
                switch ((Diff.DiffKind)((Object)segmentTypes.get(0))) {
                    case EQ: {
                        firstR = new Rectangle((double)l1, 8.0);
                        firstC = Color.BLUE;
                        break;
                    }
                    case SUBST: {
                        firstR = new Rectangle((double)l1, 8.0);
                        firstC = Color.TOMATO;
                        break;
                    }
                    case IN: 
                    case DEL: {
                        r2 = new Rectangle((double)l1, 8.0);
                        firstR = Shape.subtract((Shape)r2, (Shape)this.getHatching(l1, 0));
                        firstC = Color.BROWN;
                        break;
                    }
                    default: {
                        firstR = null;
                        firstC = null;
                    }
                }
                int l2 = 40 * (Integer)segmentLengths.get(segmentCount - 1) - 8;
                switch ((Diff.DiffKind)((Object)segmentTypes.get(segmentCount - 1))) {
                    case EQ: {
                        lastR = new Rectangle((double)(totalLength - l2), 0.0, (double)l2, 8.0);
                        lastC = Color.BLUE;
                        break;
                    }
                    case SUBST: {
                        lastR = new Rectangle((double)(totalLength - l2), 0.0, (double)l2, 8.0);
                        lastC = Color.TOMATO;
                        break;
                    }
                    case IN: 
                    case DEL: {
                        r = new Rectangle((double)(totalLength - l2), 0.0, (double)l2, 8.0);
                        lastR = Shape.subtract((Shape)r, (Shape)this.getHatching(l2, totalLength - l2));
                        lastC = Color.BROWN;
                        break;
                    }
                    default: {
                        lastR = null;
                        lastC = null;
                    }
                }
                r = new Rectangle((double)totalLength, 8.0);
                r.setArcHeight(8.0);
                r.setArcWidth(12.0);
                Shape s1 = Shape.intersect((Shape)firstR, (Shape)r);
                Shape s2 = Shape.intersect((Shape)lastR, (Shape)r);
                s1.setFill((Paint)firstC);
                s2.setFill((Paint)lastC);
                rectangles.add(0, s1);
                rectangles.add(s2);
            } else {
                int length = 40 * (Integer)segmentLengths.get(0) - 16;
                switch ((Diff.DiffKind)((Object)segmentTypes.get(0))) {
                    case EQ: {
                        Rectangle r = new Rectangle((double)length, 8.0, (Paint)Color.BLUE);
                        r.setArcHeight(8.0);
                        r.setArcWidth(12.0);
                        rectangles.add(r);
                        break;
                    }
                    case SUBST: {
                        Rectangle r = new Rectangle((double)length, 8.0, (Paint)Color.TOMATO);
                        r.setArcHeight(8.0);
                        r.setArcWidth(12.0);
                        rectangles.add(r);
                        break;
                    }
                    case IN: 
                    case DEL: {
                        Rectangle r = new Rectangle((double)length, 8.0);
                        r.setArcHeight(8.0);
                        r.setArcWidth(12.0);
                        Shape s = Shape.subtract((Shape)r, (Shape)this.getHatching(length, totalLength - length));
                        s.setFill((Paint)Color.BROWN);
                        rectangles.add(s);
                    }
                }
            }
            this.getChildren().addAll(rectangles);
        }
    }

    public ValueView(String description, Diff.DiffKind ... segmentParts) {
        this.setSegments(segmentParts);
        Tooltip tooltip = new Tooltip(description);
        Tooltip.install((Node)this, (Tooltip)tooltip);
    }
}

