/**
 * Copyright (c) 2017 Inria.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Inria - initial API and implementation
 */
package org.eclipse.gemoc.xdsmlframework.test.lib;

import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotShell;
import org.eclipse.xtext.xbase.lib.InputOutput;

/**
 * Class containing helper methods for testing a workspace in a GEMOC Language workbench
 */
@SuppressWarnings("all")
public class SWTBotHelper {
  /**
   * relaunch the  waitForJobs several times in case some other background task
   * also wait for idle time to triggers new jobs
   */
  public static void printShellList(final SWTWorkbenchBot bot) {
    InputOutput.<String>println("SWTBOT Known shells :");
    SWTBotShell[] _shells = bot.shells();
    for (final SWTBotShell shell : _shells) {
      String _text = shell.getText();
      String _plus = ("\t" + _text);
      InputOutput.<String>println(_plus);
    }
  }
}
