/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.connectors.admin.cli;

import com.sun.appserv.connectors.internal.api.ConnectorsUtil;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Resource;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.beans.PropertyVetoException;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.connectors.config.ConnectorResource;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.resourcebase.resources.admin.cli.ResourceUtil;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@TargetType(value={CommandTarget.DAS, CommandTarget.DOMAIN, CommandTarget.CLUSTER, CommandTarget.STANDALONE_INSTANCE})
@RestEndpoints(value={@RestEndpoint(configBean=Resources.class, opType=RestEndpoint.OpType.DELETE, path="delete-connector-resource", description="delete-connector-resource")})
@ExecuteOn(value={RuntimeType.ALL})
@Service(name="delete-connector-resource")
@PerLookup
@I18n(value="delete.connector.resource")
public class DeleteConnectorResource
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DeleteConnectorResource.class);
    @Param(optional=true)
    private String target = "server";
    @Param(name="connector_resource_name", primary=true)
    private String jndiName;
    @Inject
    private ResourceUtil resourceUtil;
    @Inject
    private Domain domain;
    @Inject
    private ServerEnvironment environment;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        if (this.jndiName == null) {
            report.setMessage(localStrings.getLocalString("delete.connector.resource.noJndiName", "No JNDI name defined for connector resource."));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        Resource r = ConnectorsUtil.getResourceByName((Resources)this.domain.getResources(), ConnectorResource.class, (String)this.jndiName);
        if (r == null) {
            report.setMessage(localStrings.getLocalString("delete.connector.resource.notfound", "A connector resource named {0} does not exist.", new Object[]{this.jndiName}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        if ("system-all-req".equals(r.getObjectType())) {
            report.setMessage(localStrings.getLocalString("delete.connector.resource.notAllowed", "The {0} resource cannot be deleted as it is required to be configured in the system.", new Object[]{this.jndiName}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        if (this.environment.isDas()) {
            if ("domain".equals(this.target)) {
                if (this.resourceUtil.getTargetsReferringResourceRef(this.jndiName).size() > 0) {
                    report.setMessage(localStrings.getLocalString("delete.connector.resource.resource-ref.exist", "connector-resource [ {0} ] is referenced in aninstance/cluster target, Use delete-resource-ref on appropriate target", new Object[]{this.jndiName}));
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    return;
                }
            } else {
                if (!this.resourceUtil.isResourceRefInTarget(this.jndiName, this.target)) {
                    report.setMessage(localStrings.getLocalString("delete.connector.resource.no.resource-ref", "connector-resource [ {0} ] is not referenced in target [ {1} ]", new Object[]{this.jndiName, this.target}));
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    return;
                }
                if (this.resourceUtil.getTargetsReferringResourceRef(this.jndiName).size() > 1) {
                    report.setMessage(localStrings.getLocalString("delete.connector.resource.multiple.resource-refs", "connector resource [ {0} ] is referenced in multiple instance/cluster targets, Use delete-resource-ref on appropriate target", new Object[]{this.jndiName}));
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    return;
                }
            }
        }
        try {
            this.resourceUtil.deleteResourceRef(this.jndiName, this.target);
            if (ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Resources>(){

                public Object run(Resources param) throws PropertyVetoException, TransactionFailure {
                    ConnectorResource resource = (ConnectorResource)ConnectorsUtil.getResourceByName((Resources)DeleteConnectorResource.this.domain.getResources(), ConnectorResource.class, (String)DeleteConnectorResource.this.jndiName);
                    return param.getResources().remove(resource);
                }
            }, (ConfigBeanProxy)this.domain.getResources()) == null) {
                report.setMessage(localStrings.getLocalString("delete.connector.resource.fail", "Connector resource {0} delete failed ", new Object[]{this.jndiName}));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
        }
        catch (TransactionFailure tfe) {
            report.setMessage(localStrings.getLocalString("delete.connector.resource.fail", "Connector resource {0} delete failed ", new Object[]{this.jndiName}) + " " + tfe.getLocalizedMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)tfe);
        }
        report.setMessage(localStrings.getLocalString("delete.connector.resource.success", "Connector resource {0} deleted successfully", new Object[]{this.jndiName}));
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }
}

