/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.ide.editor;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.glsp.server.actions.ActionMessage;
import org.eclipse.glsp.server.protocol.GLSPClient;
import org.eclipse.glsp.server.protocol.GLSPServer;
import org.eclipse.glsp.server.session.ClientSessionManager;

public class IdeGLSPClient
implements GLSPClient {
    @Inject
    protected GLSPServer glspServer;
    @Inject
    protected ClientSessionManager clientSessionManager;
    protected Map<String, List<GLSPClient>> clientProxies = new ConcurrentHashMap<String, List<GLSPClient>>();

    public void connect(String clientSessionId, GLSPClient glspClient) {
        this.clientProxies.computeIfAbsent(clientSessionId, id -> new ArrayList()).add(glspClient);
    }

    public boolean disconnect(String clientSessionId, GLSPClient glspClient) {
        List<GLSPClient> clients = this.clientProxies.get(clientSessionId);
        if (clients == null) {
            return false;
        }
        boolean didDisconnect = clients.remove(glspClient);
        if (didDisconnect && clients.isEmpty()) {
            this.clientProxies.remove(clientSessionId);
        }
        return didDisconnect;
    }

    public void disconnect(GLSPClient glspClient) {
        this.clientProxies.keySet().stream().toList().forEach(clientSessionId -> {
            boolean bl = this.disconnect((String)clientSessionId, glspClient);
        });
    }

    public void process(ActionMessage message) {
        Collection result = this.clientProxies.get(message.getClientId());
        if (result == null || result.isEmpty()) {
            throw new IllegalArgumentException("Could not retrieve GLSPCLient proxy for client session with id: " + message.getClientId());
        }
        result.forEach(proxy -> proxy.process(message));
    }
}

