/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.server.websocket;

import com.google.inject.Module;
import java.io.IOException;
import java.net.InetSocketAddress;
import javax.websocket.server.ServerEndpointConfig;
import org.apache.log4j.Logger;
import org.eclipse.glsp.server.di.GLSPModule;
import org.eclipse.glsp.server.launch.GLSPServerLauncher;
import org.eclipse.glsp.server.websocket.GLSPConfigurator;
import org.eclipse.glsp.server.websocket.GLSPServerEndpoint;
import org.eclipse.glsp.server.websocket.WebsocketModule;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.websocket.jsr356.server.ServerContainer;
import org.eclipse.jetty.websocket.jsr356.server.deploy.WebSocketServerContainerInitializer;

public class WebsocketServerLauncher
extends GLSPServerLauncher {
    private static Logger LOG = Logger.getLogger(WebsocketServerLauncher.class);
    private Server server;
    private String clientAppPath;
    private final String endpointPath;

    public WebsocketServerLauncher(GLSPModule module, String endpointPath) {
        super(module);
        this.endpointPath = endpointPath.startsWith("/") ? endpointPath.substring(1) : endpointPath;
        this.addAdditionalModules(new Module[]{new WebsocketModule()});
    }

    public WebsocketServerLauncher(GLSPModule module, String endpointPath, String clientAppPath) {
        this(module, endpointPath);
        this.clientAppPath = clientAppPath;
    }

    public void start(String hostname, int port) {
        try {
            ServletContextHandler webAppContext;
            this.server = new Server(new InetSocketAddress(hostname, port));
            if (this.clientAppPath != null && !this.clientAppPath.isEmpty()) {
                LOG.info((Object)("Serving client app from :" + this.clientAppPath));
                webAppContext = new WebAppContext();
                webAppContext.setResourceBase(this.clientAppPath);
                String[] welcomeFiles = new String[]{"index.html"};
                webAppContext.setWelcomeFiles(welcomeFiles);
                webAppContext.setInitParameter("org.eclipse.jetty.servlet.Default.dirAllowed", "false");
                webAppContext.setInitParameter("org.eclipse.jetty.servlet.Default.useFileMappedBuffer", "false");
            } else {
                webAppContext = new ServletContextHandler(1);
                webAppContext.setContextPath("/");
            }
            this.server.setHandler((Handler)webAppContext);
            ServerContainer container = WebSocketServerContainerInitializer.configureContext((ServletContextHandler)webAppContext);
            ServerEndpointConfig.Builder builder = ServerEndpointConfig.Builder.create(GLSPServerEndpoint.class, (String)("/" + this.endpointPath));
            builder.configurator((ServerEndpointConfig.Configurator)new GLSPConfigurator(this.createInjector()));
            container.addEndpoint(builder.build());
            try {
                this.server.start();
                LOG.info((Object)("GLSP server is running and listening on Endpoint : " + this.server.getURI() + this.endpointPath));
                LOG.info((Object)"Press enter to stop the server...");
                new Thread(() -> {
                    try {
                        int key = System.in.read();
                        this.shutdown();
                        if (key == -1) {
                            LOG.warn((Object)"The standard input stream is empty");
                        }
                    }
                    catch (IOException e) {
                        LOG.warn((Object)e);
                    }
                }).start();
                this.server.join();
            }
            catch (Exception exception) {
                LOG.warn((Object)"Shutting down due to exception", (Throwable)exception);
                System.exit(1);
            }
        }
        catch (Exception ex) {
            LOG.error((Object)("Failed to start Websocket GLSP server " + ex.getMessage()), (Throwable)ex);
        }
    }

    public String getClientAppPath() {
        return this.clientAppPath;
    }

    public void setClientAppPath(String clientAppPath) {
        this.clientAppPath = clientAppPath;
    }

    public void shutdown() {
        if (this.server.isRunning()) {
            try {
                this.server.stop();
            }
            catch (Exception ex) {
                LOG.error((Object)("Failed to stop Websocket GLSP server " + ex.getMessage()), (Throwable)ex);
            }
        }
    }
}

