/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.server.features.core.model;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.eclipse.glsp.graph.GModelRoot;
import org.eclipse.glsp.server.actions.Action;
import org.eclipse.glsp.server.actions.SetDirtyStateAction;
import org.eclipse.glsp.server.diagram.DiagramConfiguration;
import org.eclipse.glsp.server.features.core.model.GModelFactory;
import org.eclipse.glsp.server.features.core.model.RequestBoundsAction;
import org.eclipse.glsp.server.features.core.model.SetModelAction;
import org.eclipse.glsp.server.features.core.model.UpdateModelAction;
import org.eclipse.glsp.server.layout.LayoutEngine;
import org.eclipse.glsp.server.layout.ServerLayoutKind;
import org.eclipse.glsp.server.model.GModelState;

@Singleton
public class ModelSubmissionHandler {
    @Inject
    protected Optional<LayoutEngine> layoutEngine;
    @Inject
    protected DiagramConfiguration diagramConfiguration;
    @Inject
    protected GModelFactory modelFactory;
    @Inject
    protected GModelState modelState;
    private final Object modelLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Action> submitModel(String reason) {
        this.modelFactory.createGModel();
        ((GModelRoot)this.modelState.getRoot()).setRevision(((GModelRoot)this.modelState.getRoot()).getRevision() + 1);
        boolean needsClientLayout = this.diagramConfiguration.needsClientLayout();
        if (needsClientLayout) {
            Object object = this.modelLock;
            synchronized (object) {
                return Arrays.asList(new RequestBoundsAction((GModelRoot)this.modelState.getRoot()), new SetDirtyStateAction(this.modelState.isDirty(), reason));
            }
        }
        return this.submitModelDirectly(reason);
    }

    public List<Action> submitModel() {
        return this.submitModel(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Action> submitModelDirectly(String reason) {
        GModelRoot gModel = (GModelRoot)this.modelState.getRoot();
        if (this.diagramConfiguration.getLayoutKind() == ServerLayoutKind.AUTOMATIC && this.layoutEngine.isPresent()) {
            this.layoutEngine.get().layout();
        }
        Action modelAction = gModel.getRevision() == 0 ? new SetModelAction(gModel) : new UpdateModelAction(gModel, this.diagramConfiguration.animatedUpdate());
        Object object = this.modelLock;
        synchronized (object) {
            ArrayList<Action> result = new ArrayList<Action>();
            result.add(modelAction);
            if (!this.diagramConfiguration.needsClientLayout()) {
                result.add(new SetDirtyStateAction(this.modelState.isDirty(), reason));
            }
            return result;
        }
    }

    public List<Action> submitModelDirectly() {
        return this.submitModelDirectly(null);
    }

    public synchronized Object getModelLock() {
        return this.modelLock;
    }
}

