/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.server.gmodel;

import java.util.Optional;
import org.eclipse.emf.common.command.Command;
import org.eclipse.glsp.graph.GEdge;
import org.eclipse.glsp.graph.GModelIndex;
import org.eclipse.glsp.server.operations.ChangeRoutingPointsOperation;
import org.eclipse.glsp.server.operations.GModelOperationHandler;
import org.eclipse.glsp.server.utils.LayoutUtil;

public class GModelChangeRoutingPointsHandler
extends GModelOperationHandler<ChangeRoutingPointsOperation> {
    @Override
    public Optional<Command> createCommand(ChangeRoutingPointsOperation operation) {
        return this.commandOf(() -> this.executeChangeRoutingPoints(operation));
    }

    protected void executeChangeRoutingPoints(ChangeRoutingPointsOperation operation) {
        if (operation.getNewRoutingPoints() == null) {
            throw new IllegalArgumentException("Incomplete change routingPoints  action");
        }
        GModelIndex index = this.modelState.getIndex();
        operation.getNewRoutingPoints().forEach(routingPoints -> {
            GEdge gEdge = LayoutUtil.applyRoutingPoints(routingPoints, index);
        });
    }
}

