/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.AbstractPolyPoly;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.DeviceContext;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.GdiBrush;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.GdiPen;

public class PolyPolygon
extends AbstractPolyPoly {
    public PolyPolygon(boolean b16Bits) {
        super(b16Bits);
    }

    protected boolean renderPoly(Graphics2D g, DeviceContext context, int[] xPoints, int[] yPoints, int nPoints) {
        GdiPen curPen;
        GdiBrush curBrush = context.getCurBrush();
        Shape s = this.getShape(xPoints, yPoints, nPoints);
        if (curBrush != null) {
            curBrush.fill(s, g, context);
        }
        if ((curPen = context.getCurPen()) != null) {
            curPen.apply(g, context);
            g.draw(s);
        }
        return true;
    }

    protected boolean renderPoly(GeneralPath p, int[] xPoints, int[] yPoints, int nPoints) {
        if (nPoints > 0) {
            p.moveTo(xPoints[0], yPoints[0]);
            int index = 1;
            while (index < nPoints) {
                p.lineTo(xPoints[index], yPoints[index]);
                ++index;
            }
            p.closePath();
        }
        return true;
    }

    private Shape getShape(int[] xPoints, int[] yPoints, int nPoints) {
        GeneralPath p = new GeneralPath();
        if (nPoints > 0) {
            p.moveTo(xPoints[0], yPoints[0]);
            int index = 1;
            while (index < nPoints) {
                p.lineTo(xPoints[index], yPoints[index]);
                ++index;
            }
            p.closePath();
        }
        return p;
    }
}

