/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.golo.cli.command.spi;

import java.io.File;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import org.eclipse.golo.compiler.GoloCompilationException;

public interface CliCommand {
    public void execute() throws Throwable;

    default public URLClassLoader primaryClassLoader(List<String> classpath) throws MalformedURLException {
        URL[] urls = new URL[classpath.size()];
        int index = 0;
        for (String element : classpath) {
            urls[index] = new File(element).toURI().toURL();
            ++index;
        }
        return new URLClassLoader(urls);
    }

    default public void callRun(Class<?> klass, String[] arguments) throws Throwable {
        MethodHandle main = MethodHandles.publicLookup().findStatic(klass, "main", MethodType.methodType(Void.TYPE, String[].class));
        main.invoke(arguments);
    }

    default public void handleCompilationException(GoloCompilationException e) {
        if (e.getMessage() != null) {
            System.out.println("[error] " + e.getMessage());
        }
        if (e.getCause() != null) {
            System.out.println("[error] " + e.getCause().getMessage());
        }
        for (GoloCompilationException.Problem problem : e.getProblems()) {
            System.out.println("[error] " + problem.getDescription());
        }
        System.exit(1);
    }
}

