/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.golo.compiler;

import gololang.FunctionReference;
import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.golo.compiler.CodeGenerationResult;
import org.eclipse.golo.compiler.JavaBytecodeStructGenerator;
import org.eclipse.golo.compiler.JavaBytecodeUnionGenerator;
import org.eclipse.golo.compiler.JavaBytecodeUtils;
import org.eclipse.golo.compiler.PackageAndClass;
import org.eclipse.golo.compiler.ir.AbstractInvocation;
import org.eclipse.golo.compiler.ir.AssignmentStatement;
import org.eclipse.golo.compiler.ir.Augmentation;
import org.eclipse.golo.compiler.ir.BinaryOperation;
import org.eclipse.golo.compiler.ir.Block;
import org.eclipse.golo.compiler.ir.Builders;
import org.eclipse.golo.compiler.ir.CaseStatement;
import org.eclipse.golo.compiler.ir.ClosureReference;
import org.eclipse.golo.compiler.ir.CollectionComprehension;
import org.eclipse.golo.compiler.ir.CollectionLiteral;
import org.eclipse.golo.compiler.ir.ConditionalBranching;
import org.eclipse.golo.compiler.ir.ConstantStatement;
import org.eclipse.golo.compiler.ir.Decorator;
import org.eclipse.golo.compiler.ir.DestructuringAssignment;
import org.eclipse.golo.compiler.ir.ExpressionStatement;
import org.eclipse.golo.compiler.ir.ForEachLoopStatement;
import org.eclipse.golo.compiler.ir.FunctionInvocation;
import org.eclipse.golo.compiler.ir.GoloElement;
import org.eclipse.golo.compiler.ir.GoloFunction;
import org.eclipse.golo.compiler.ir.GoloIrVisitor;
import org.eclipse.golo.compiler.ir.GoloModule;
import org.eclipse.golo.compiler.ir.GoloStatement;
import org.eclipse.golo.compiler.ir.LocalReference;
import org.eclipse.golo.compiler.ir.LoopBreakFlowStatement;
import org.eclipse.golo.compiler.ir.LoopStatement;
import org.eclipse.golo.compiler.ir.MatchExpression;
import org.eclipse.golo.compiler.ir.MethodInvocation;
import org.eclipse.golo.compiler.ir.ModuleImport;
import org.eclipse.golo.compiler.ir.NamedArgument;
import org.eclipse.golo.compiler.ir.NamedAugmentation;
import org.eclipse.golo.compiler.ir.ReferenceLookup;
import org.eclipse.golo.compiler.ir.ReferenceTable;
import org.eclipse.golo.compiler.ir.ReturnStatement;
import org.eclipse.golo.compiler.ir.Struct;
import org.eclipse.golo.compiler.ir.ThrowStatement;
import org.eclipse.golo.compiler.ir.TryCatchFinally;
import org.eclipse.golo.compiler.ir.UnaryOperation;
import org.eclipse.golo.compiler.ir.Union;
import org.eclipse.golo.compiler.ir.UnionValue;
import org.eclipse.golo.compiler.ir.WhenClause;
import org.eclipse.golo.compiler.parser.GoloParser;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

class JavaBytecodeGenerationGoloIrVisitor
implements GoloIrVisitor {
    private static final String JOBJECT = "java/lang/Object";
    private static final String TOBJECT = "Ljava/lang/Object;";
    private static final Handle FUNCTION_INVOCATION_HANDLE = JavaBytecodeGenerationGoloIrVisitor.makeHandle("FunctionCallSupport", "[Ljava/lang/Object;");
    private static final Handle OPERATOR_HANDLE = JavaBytecodeGenerationGoloIrVisitor.makeHandle("OperatorSupport", "I");
    private static final Handle METHOD_INVOCATION_HANDLE = JavaBytecodeGenerationGoloIrVisitor.makeHandle("MethodInvocationSupport", "[Ljava/lang/Object;");
    private static final Handle CLASSREF_HANDLE = JavaBytecodeGenerationGoloIrVisitor.makeHandle("ClassReferenceSupport", "");
    private static final Handle CLOSUREREF_HANDLE = JavaBytecodeGenerationGoloIrVisitor.makeHandle("ClosureReferenceSupport", "Ljava/lang/String;II");
    private static final Handle CLOSURE_INVOCATION_HANDLE = JavaBytecodeGenerationGoloIrVisitor.makeHandle("ClosureCallSupport", "[Ljava/lang/Object;");
    private ClassWriter classWriter;
    private String klass;
    private String jvmKlass;
    private MethodVisitor methodVisitor;
    private List<CodeGenerationResult> generationResults;
    private String sourceFilename;
    private Context context;
    private GoloModule currentModule;
    private static final JavaBytecodeStructGenerator STRUCT_GENERATOR = new JavaBytecodeStructGenerator();
    private static final JavaBytecodeUnionGenerator UNION_GENERATOR = new JavaBytecodeUnionGenerator();

    JavaBytecodeGenerationGoloIrVisitor() {
    }

    private static Handle makeHandle(String methodName, String description) {
        return new Handle(6, "org/eclipse/golo/runtime/" + methodName, "bootstrap", "(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;" + description + ")Ljava/lang/invoke/CallSite;");
    }

    private static RuntimeException invalidElement(GoloElement element) {
        return new IllegalStateException("No " + element.getClass() + " must remains at this stage");
    }

    public List<CodeGenerationResult> generateBytecode(GoloModule module, String sourceFilename) {
        this.sourceFilename = sourceFilename;
        this.classWriter = new ClassWriter(3);
        this.generationResults = new LinkedList<CodeGenerationResult>();
        this.context = new Context();
        module.accept(this);
        this.classWriter.visitEnd();
        this.generationResults.add(new CodeGenerationResult(this.classWriter.toByteArray(), module.getPackageAndClass()));
        return this.generationResults;
    }

    @Override
    public void visitCollectionComprehension(CollectionComprehension coll) {
        throw JavaBytecodeGenerationGoloIrVisitor.invalidElement(coll);
    }

    @Override
    public void visitMatchExpression(MatchExpression match) {
        throw JavaBytecodeGenerationGoloIrVisitor.invalidElement(match);
    }

    @Override
    public void visitCaseStatement(CaseStatement caseStatement) {
        throw JavaBytecodeGenerationGoloIrVisitor.invalidElement(caseStatement);
    }

    @Override
    public void visitWhenClause(WhenClause<?> whenClause) {
        throw JavaBytecodeGenerationGoloIrVisitor.invalidElement(whenClause);
    }

    @Override
    public void visitForEachLoopStatement(ForEachLoopStatement statement) {
        throw JavaBytecodeGenerationGoloIrVisitor.invalidElement(statement);
    }

    @Override
    public void visitDestructuringAssignment(DestructuringAssignment statement) {
        throw JavaBytecodeGenerationGoloIrVisitor.invalidElement(statement);
    }

    @Override
    public void visitModule(GoloModule module) {
        this.currentModule = module;
        this.classWriter.visit(52, 33, module.getPackageAndClass().toJVMType(), null, JOBJECT, null);
        this.classWriter.visitSource(this.sourceFilename, null);
        this.writeImportMetaData(module.getImports());
        this.klass = module.getPackageAndClass().toString();
        this.jvmKlass = module.getPackageAndClass().toJVMType();
        this.writeAugmentsMetaData();
        this.writeAugmentationApplicationsMetaData();
        module.walk(this);
    }

    @Override
    public void visitModuleImport(ModuleImport moduleImport) {
    }

    @Override
    public void visitLocalReference(LocalReference moduleState) {
        String name = moduleState.getName();
        this.classWriter.visitField(10, name, TOBJECT, null, null).visitEnd();
        MethodVisitor mv = this.classWriter.visitMethod(4106, name, "()Ljava/lang/Object;", null, null);
        mv.visitCode();
        mv.visitFieldInsn(178, this.jvmKlass, name, TOBJECT);
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        mv = this.classWriter.visitMethod(4106, name, "(Ljava/lang/Object;)V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(179, this.jvmKlass, name, TOBJECT);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void writeMetaData(String name, String[] data) {
        this.methodVisitor = this.classWriter.visitMethod(4105, "$" + name, "()[Ljava/lang/String;", null, null);
        this.methodVisitor.visitCode();
        JavaBytecodeUtils.loadInteger(this.methodVisitor, data.length);
        this.methodVisitor.visitTypeInsn(189, "java/lang/String");
        for (int i = 0; i < data.length; ++i) {
            this.methodVisitor.visitInsn(89);
            JavaBytecodeUtils.loadInteger(this.methodVisitor, i);
            this.methodVisitor.visitLdcInsn((Object)data[i]);
            this.methodVisitor.visitInsn(83);
        }
        this.methodVisitor.visitInsn(176);
        this.methodVisitor.visitMaxs(0, 0);
        this.methodVisitor.visitEnd();
    }

    private void writeAugmentationApplicationsMetaData() {
        ArrayList<Augmentation> applications = new ArrayList<Augmentation>(this.currentModule.getAugmentations());
        int applicationsSize = applications.size();
        this.writeMetaData("augmentationApplications", (String[])applications.stream().map(Augmentation::getTarget).map(PackageAndClass::toString).toArray(String[]::new));
        Label defaultLabel = new Label();
        Label[] labels = new Label[applicationsSize];
        int[] keys = new int[applicationsSize];
        String[][] namesArrays = new String[applicationsSize][];
        Collections.sort(applications, (o1, o2) -> Integer.compare(o1.getTarget().toString().hashCode(), o2.getTarget().toString().hashCode()));
        int i = 0;
        for (Augmentation application : applications) {
            labels[i] = new Label();
            keys[i] = application.getTarget().toString().hashCode();
            namesArrays[i] = application.getNames().toArray(new String[application.getNames().size()]);
            ++i;
        }
        this.methodVisitor = this.classWriter.visitMethod(4105, "$augmentationApplications", "(I)[Ljava/lang/String;", null, null);
        this.methodVisitor.visitCode();
        this.methodVisitor.visitVarInsn(21, 0);
        this.methodVisitor.visitLookupSwitchInsn(defaultLabel, keys, labels);
        for (i = 0; i < applicationsSize; ++i) {
            this.methodVisitor.visitLabel(labels[i]);
            JavaBytecodeUtils.loadInteger(this.methodVisitor, namesArrays[i].length);
            this.methodVisitor.visitTypeInsn(189, "java/lang/String");
            for (int j = 0; j < namesArrays[i].length; ++j) {
                this.methodVisitor.visitInsn(89);
                JavaBytecodeUtils.loadInteger(this.methodVisitor, j);
                this.methodVisitor.visitLdcInsn((Object)namesArrays[i][j]);
                this.methodVisitor.visitInsn(83);
            }
            this.methodVisitor.visitInsn(176);
        }
        this.methodVisitor.visitLabel(defaultLabel);
        JavaBytecodeUtils.loadInteger(this.methodVisitor, 0);
        this.methodVisitor.visitTypeInsn(189, "java/lang/String");
        this.methodVisitor.visitInsn(176);
        this.methodVisitor.visitMaxs(0, 0);
        this.methodVisitor.visitEnd();
    }

    private void writeImportMetaData(Set<ModuleImport> imports) {
        this.writeMetaData("imports", (String[])imports.stream().map(ModuleImport::getPackageAndClass).map(PackageAndClass::toString).toArray(String[]::new));
    }

    private void writeAugmentsMetaData() {
        this.writeMetaData("augmentations", (String[])this.currentModule.getAugmentations().stream().map(Augmentation::getTarget).map(PackageAndClass::toString).toArray(String[]::new));
    }

    @Override
    public void visitStruct(Struct struct) {
        this.generationResults.add(STRUCT_GENERATOR.compile(struct, this.sourceFilename));
    }

    @Override
    public void visitUnion(Union union) {
        this.generationResults.addAll(UNION_GENERATOR.compile(union, this.sourceFilename));
    }

    @Override
    public void visitUnionValue(UnionValue value) {
    }

    @Override
    public void visitAugmentation(Augmentation augmentation) {
        this.generateAugmentationBytecode(augmentation.getTarget(), augmentation.getFunctions());
    }

    @Override
    public void visitNamedAugmentation(NamedAugmentation namedAugmentation) {
        this.generateAugmentationBytecode(namedAugmentation.getPackageAndClass(), namedAugmentation.getFunctions());
    }

    private void generateAugmentationBytecode(PackageAndClass target, Set<GoloFunction> functions) {
        if (functions.isEmpty()) {
            return;
        }
        ClassWriter mainClassWriter = this.classWriter;
        String mangledClass = target.mangledName();
        PackageAndClass packageAndClass = this.currentModule.getPackageAndClass().createInnerClass(mangledClass);
        String augmentationClassInternalName = packageAndClass.toJVMType();
        String outerName = this.currentModule.getPackageAndClass().toJVMType();
        mainClassWriter.visitInnerClass(augmentationClassInternalName, outerName, mangledClass, 9);
        this.classWriter = new ClassWriter(3);
        this.classWriter.visit(52, 33, augmentationClassInternalName, null, JOBJECT, null);
        this.classWriter.visitSource(this.sourceFilename, null);
        this.classWriter.visitOuterClass(outerName, null, null);
        for (GoloFunction function : functions) {
            function.accept(this);
        }
        HashSet<ModuleImport> imports = new HashSet<ModuleImport>(this.currentModule.getImports());
        imports.add(Builders.moduleImport(this.currentModule.getPackageAndClass()));
        this.writeImportMetaData(imports);
        this.classWriter.visitEnd();
        this.generationResults.add(new CodeGenerationResult(this.classWriter.toByteArray(), packageAndClass));
        this.classWriter = mainClassWriter;
    }

    @Override
    public void visitFunction(GoloFunction function) {
        String signature;
        int accessFlags;
        int n = accessFlags = function.isLocal() ? 2 : 1;
        if (function.isMain()) {
            signature = "([Ljava/lang/String;)V";
        } else if (function.isVarargs()) {
            accessFlags |= 0x80;
            signature = this.goloVarargsFunctionSignature(function.getArity());
        } else {
            signature = function.isModuleInit() ? "()V" : this.goloFunctionSignature(function.getArity());
        }
        if (function.isSynthetic() || function.isDecorator()) {
            accessFlags |= 0x1000;
        }
        this.methodVisitor = this.classWriter.visitMethod(accessFlags | 8, function.getName(), signature, null, null);
        if (function.isDecorated()) {
            AnnotationVisitor annotation = this.methodVisitor.visitAnnotation("Lgololang/annotations/DecoratedBy;", true);
            annotation.visit("value", (Object)function.getDecoratorRef());
            annotation.visitEnd();
        }
        for (String parameter : function.getParameterNames()) {
            this.methodVisitor.visitParameter(parameter, 16);
        }
        this.methodVisitor.visitCode();
        JavaBytecodeUtils.visitLine(function, this.methodVisitor);
        function.walk(this);
        if (function.isModuleInit()) {
            this.methodVisitor.visitInsn(177);
        }
        this.methodVisitor.visitMaxs(0, 0);
        this.methodVisitor.visitEnd();
    }

    private String goloFunctionSignature(int arity) {
        return MethodType.genericMethodType(arity).toMethodDescriptorString();
    }

    private String goloVarargsFunctionSignature(int arity) {
        return MethodType.genericMethodType(arity - 1, true).toMethodDescriptorString();
    }

    @Override
    public void visitDecorator(Decorator deco) {
    }

    @Override
    public void visitBlock(Block block) {
        ReferenceTable referenceTable = block.getReferenceTable();
        this.context.referenceTableStack.push(referenceTable);
        Label blockStart = new Label();
        Label blockEnd = new Label();
        this.methodVisitor.visitLabel(blockStart);
        for (GoloStatement statement : block.getStatements()) {
            JavaBytecodeUtils.visitLine(statement, this.methodVisitor);
            statement.accept(this);
            this.insertMissingPop(statement);
        }
        this.methodVisitor.visitLabel(blockEnd);
        for (LocalReference localReference : referenceTable.ownedReferences()) {
            if (localReference.isModuleState()) continue;
            this.methodVisitor.visitLocalVariable(localReference.getName(), TOBJECT, null, blockStart, blockEnd, localReference.getIndex());
        }
        this.context.referenceTableStack.pop();
    }

    private void insertMissingPop(GoloStatement statement) {
        BinaryOperation operation;
        Class<?> statementClass = statement.getClass();
        if (statementClass == FunctionInvocation.class) {
            this.methodVisitor.visitInsn(87);
        } else if (statementClass == BinaryOperation.class && (operation = (BinaryOperation)statement).isMethodCall()) {
            this.methodVisitor.visitInsn(87);
        }
    }

    @Override
    public void visitConstantStatement(ConstantStatement constantStatement) {
        Object value = constantStatement.getValue();
        if (value == null) {
            this.methodVisitor.visitInsn(1);
            return;
        }
        if (value instanceof Integer) {
            int i = (Integer)value;
            JavaBytecodeUtils.loadInteger(this.methodVisitor, i);
            this.methodVisitor.visitMethodInsn(184, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;", false);
            return;
        }
        if (value instanceof Long) {
            long l = (Long)value;
            JavaBytecodeUtils.loadLong(this.methodVisitor, l);
            this.methodVisitor.visitMethodInsn(184, "java/lang/Long", "valueOf", "(J)Ljava/lang/Long;", false);
            return;
        }
        if (value instanceof Boolean) {
            boolean b = (Boolean)value;
            JavaBytecodeUtils.loadInteger(this.methodVisitor, b ? 1 : 0);
            this.methodVisitor.visitMethodInsn(184, "java/lang/Boolean", "valueOf", "(Z)Ljava/lang/Boolean;", false);
            return;
        }
        if (value instanceof String) {
            this.methodVisitor.visitLdcInsn(value);
            return;
        }
        if (value instanceof Character) {
            JavaBytecodeUtils.loadInteger(this.methodVisitor, ((Character)value).charValue());
            this.methodVisitor.visitMethodInsn(184, "java/lang/Character", "valueOf", "(C)Ljava/lang/Character;", false);
            return;
        }
        if (value instanceof GoloParser.ParserClassRef) {
            GoloParser.ParserClassRef ref = (GoloParser.ParserClassRef)value;
            this.methodVisitor.visitInvokeDynamicInsn(ref.name.replaceAll("\\.", "#"), "()Ljava/lang/Class;", CLASSREF_HANDLE, new Object[0]);
            return;
        }
        if (value instanceof Double) {
            double d = (Double)value;
            this.methodVisitor.visitLdcInsn((Object)d);
            this.methodVisitor.visitMethodInsn(184, "java/lang/Double", "valueOf", "(D)Ljava/lang/Double;", false);
            return;
        }
        if (value instanceof Float) {
            float f = ((Float)value).floatValue();
            this.methodVisitor.visitLdcInsn((Object)Float.valueOf(f));
            this.methodVisitor.visitMethodInsn(184, "java/lang/Float", "valueOf", "(F)Ljava/lang/Float;", false);
            return;
        }
        throw new IllegalArgumentException("Constants of type " + value.getClass() + " cannot be handled.");
    }

    @Override
    public void visitReturnStatement(ReturnStatement returnStatement) {
        returnStatement.getExpressionStatement().accept(this);
        if (returnStatement.isReturningVoid()) {
            this.methodVisitor.visitInsn(177);
        } else {
            this.methodVisitor.visitInsn(176);
        }
    }

    @Override
    public void visitThrowStatement(ThrowStatement throwStatement) {
        throwStatement.getExpressionStatement().accept(this);
        this.methodVisitor.visitTypeInsn(192, "java/lang/Throwable");
        this.methodVisitor.visitInsn(191);
    }

    private List<String> visitInvocationArguments(AbstractInvocation invocation) {
        ArrayList<String> argumentNames = new ArrayList<String>();
        for (ExpressionStatement argument : invocation.getArguments()) {
            if (invocation.usesNamedArguments()) {
                NamedArgument namedArgument = (NamedArgument)argument;
                argumentNames.add(namedArgument.getName());
                argument = namedArgument.getExpression();
            }
            argument.accept(this);
        }
        return argumentNames;
    }

    @Override
    public void visitFunctionInvocation(FunctionInvocation functionInvocation) {
        String name = functionInvocation.getName().replaceAll("\\.", "#");
        String typeDef = this.goloFunctionSignature(functionInvocation.getArity());
        Handle handle = FUNCTION_INVOCATION_HANDLE;
        ArrayList<Object> bootstrapArgs = new ArrayList<Object>();
        bootstrapArgs.add(functionInvocation.isConstant() ? 1 : 0);
        if (functionInvocation.isOnReference()) {
            ReferenceTable table = (ReferenceTable)this.context.referenceTableStack.peek();
            this.methodVisitor.visitVarInsn(25, table.get(functionInvocation.getName()).getIndex());
        }
        if (functionInvocation.isOnModuleState()) {
            Builders.refLookup(functionInvocation.getName()).accept(this);
        }
        if (functionInvocation.isAnonymous() || functionInvocation.isOnReference() || functionInvocation.isOnModuleState()) {
            this.methodVisitor.visitTypeInsn(192, "gololang/FunctionReference");
            MethodType type = MethodType.genericMethodType(functionInvocation.getArity() + 1).changeParameterType(0, FunctionReference.class);
            typeDef = type.toMethodDescriptorString();
            handle = CLOSURE_INVOCATION_HANDLE;
        }
        List<String> argumentNames = this.visitInvocationArguments(functionInvocation);
        bootstrapArgs.addAll(argumentNames);
        this.methodVisitor.visitInvokeDynamicInsn(name, typeDef, handle, bootstrapArgs.toArray());
        for (FunctionInvocation invocation : functionInvocation.getAnonymousFunctionInvocations()) {
            invocation.accept(this);
        }
    }

    @Override
    public void visitMethodInvocation(MethodInvocation methodInvocation) {
        ArrayList<Object> bootstrapArgs = new ArrayList<Object>();
        bootstrapArgs.add(methodInvocation.isNullSafeGuarded() ? 1 : 0);
        List<String> argumentNames = this.visitInvocationArguments(methodInvocation);
        bootstrapArgs.addAll(argumentNames);
        this.methodVisitor.visitInvokeDynamicInsn(methodInvocation.getName().replaceAll("\\.", "#"), this.goloFunctionSignature(methodInvocation.getArity() + 1), METHOD_INVOCATION_HANDLE, bootstrapArgs.toArray());
        for (FunctionInvocation invocation : methodInvocation.getAnonymousFunctionInvocations()) {
            invocation.accept(this);
        }
    }

    @Override
    public void visitAssignmentStatement(AssignmentStatement assignmentStatement) {
        assignmentStatement.walk(this);
        LocalReference reference = assignmentStatement.getLocalReference();
        if (reference.isModuleState()) {
            this.methodVisitor.visitInvokeDynamicInsn((this.klass + "." + reference.getName()).replaceAll("\\.", "#"), "(Ljava/lang/Object;)V", FUNCTION_INVOCATION_HANDLE, new Object[]{0});
        } else {
            this.methodVisitor.visitVarInsn(58, reference.getIndex());
        }
    }

    @Override
    public void visitReferenceLookup(ReferenceLookup referenceLookup) {
        LocalReference reference = referenceLookup.resolveIn((ReferenceTable)this.context.referenceTableStack.peek());
        if (reference.isModuleState()) {
            this.methodVisitor.visitInvokeDynamicInsn((this.klass + "." + referenceLookup.getName()).replaceAll("\\.", "#"), "()Ljava/lang/Object;", FUNCTION_INVOCATION_HANDLE, new Object[]{0});
        } else {
            this.methodVisitor.visitVarInsn(25, reference.getIndex());
        }
    }

    @Override
    public void visitConditionalBranching(ConditionalBranching conditionalBranching) {
        Label branchingElseLabel = new Label();
        Label branchingExitLabel = new Label();
        conditionalBranching.getCondition().accept(this);
        this.asmBooleanValue();
        this.methodVisitor.visitJumpInsn(153, branchingElseLabel);
        conditionalBranching.getTrueBlock().accept(this);
        if (conditionalBranching.hasFalseBlock()) {
            if (!conditionalBranching.getTrueBlock().hasReturn()) {
                this.methodVisitor.visitJumpInsn(167, branchingExitLabel);
            }
            this.methodVisitor.visitLabel(branchingElseLabel);
            conditionalBranching.getFalseBlock().accept(this);
            this.methodVisitor.visitLabel(branchingExitLabel);
        } else if (conditionalBranching.hasElseConditionalBranching()) {
            if (!conditionalBranching.getTrueBlock().hasReturn()) {
                this.methodVisitor.visitJumpInsn(167, branchingExitLabel);
            }
            this.methodVisitor.visitLabel(branchingElseLabel);
            conditionalBranching.getElseConditionalBranching().accept(this);
            this.methodVisitor.visitLabel(branchingExitLabel);
        } else {
            this.methodVisitor.visitLabel(branchingElseLabel);
        }
    }

    @Override
    public void visitLoopStatement(LoopStatement loopStatement) {
        Label loopStart = new Label();
        Label loopEnd = new Label();
        this.context.loopStartMap.put(loopStatement, loopStart);
        this.context.loopEndMap.put(loopStatement, loopEnd);
        if (loopStatement.hasInitStatement()) {
            loopStatement.getInitStatement().accept(this);
        }
        this.methodVisitor.visitLabel(loopStart);
        loopStatement.getConditionStatement().accept(this);
        this.asmBooleanValue();
        this.methodVisitor.visitJumpInsn(153, loopEnd);
        loopStatement.getBlock().accept(this);
        if (loopStatement.hasPostStatement()) {
            loopStatement.getPostStatement().accept(this);
        }
        this.methodVisitor.visitJumpInsn(167, loopStart);
        this.methodVisitor.visitLabel(loopEnd);
    }

    @Override
    public void visitLoopBreakFlowStatement(LoopBreakFlowStatement loopBreakFlowStatement) {
        Label jumpTarget = LoopBreakFlowStatement.Type.BREAK.equals((Object)loopBreakFlowStatement.getType()) ? (Label)this.context.loopEndMap.get(loopBreakFlowStatement.getEnclosingLoop()) : (Label)this.context.loopStartMap.get(loopBreakFlowStatement.getEnclosingLoop());
        this.methodVisitor.visitLdcInsn((Object)0);
        this.methodVisitor.visitJumpInsn(153, jumpTarget);
    }

    @Override
    public void visitNamedArgument(NamedArgument namedArgument) {
    }

    @Override
    public void visitCollectionLiteral(CollectionLiteral collectionLiteral) {
        throw JavaBytecodeGenerationGoloIrVisitor.invalidElement(collectionLiteral);
    }

    @Override
    public void visitTryCatchFinally(TryCatchFinally tryCatchFinally) {
        Label tryStart = new Label();
        Label tryEnd = new Label();
        Label catchStart = new Label();
        Label catchEnd = new Label();
        Label rethrowStart = null;
        Label rethrowEnd = null;
        if (tryCatchFinally.isTryCatchFinally()) {
            rethrowStart = new Label();
            rethrowEnd = new Label();
        }
        this.methodVisitor.visitLabel(tryStart);
        tryCatchFinally.getTryBlock().accept(this);
        if (tryCatchFinally.isTryCatch() || tryCatchFinally.isTryCatchFinally()) {
            this.methodVisitor.visitJumpInsn(167, catchEnd);
        }
        this.methodVisitor.visitTryCatchBlock(tryStart, tryEnd, catchStart, null);
        this.methodVisitor.visitLabel(tryEnd);
        if (tryCatchFinally.isTryFinally()) {
            tryCatchFinally.getFinallyBlock().accept(this);
            this.methodVisitor.visitJumpInsn(167, catchEnd);
        }
        if (tryCatchFinally.isTryCatchFinally()) {
            this.methodVisitor.visitTryCatchBlock(catchStart, catchEnd, rethrowStart, null);
        }
        this.methodVisitor.visitLabel(catchStart);
        if (tryCatchFinally.isTryCatch() || tryCatchFinally.isTryCatchFinally()) {
            Block catchBlock = tryCatchFinally.getCatchBlock();
            int exceptionRefIndex = catchBlock.getReferenceTable().get(tryCatchFinally.getExceptionId()).getIndex();
            this.methodVisitor.visitVarInsn(58, exceptionRefIndex);
            tryCatchFinally.getCatchBlock().accept(this);
        } else {
            tryCatchFinally.getFinallyBlock().accept(this);
            this.methodVisitor.visitInsn(191);
        }
        this.methodVisitor.visitLabel(catchEnd);
        if (tryCatchFinally.isTryCatchFinally()) {
            tryCatchFinally.getFinallyBlock().accept(this);
            this.methodVisitor.visitJumpInsn(167, rethrowEnd);
            this.methodVisitor.visitLabel(rethrowStart);
            tryCatchFinally.getFinallyBlock().accept(this);
            this.methodVisitor.visitInsn(191);
            this.methodVisitor.visitLabel(rethrowEnd);
        }
    }

    @Override
    public void visitClosureReference(ClosureReference closureReference) {
        GoloFunction target = closureReference.getTarget();
        boolean isVarArgs = target.isVarargs();
        int arity = isVarArgs ? target.getArity() - 1 : target.getArity();
        int syntheticCount = target.getSyntheticParameterCount();
        this.methodVisitor.visitInvokeDynamicInsn(target.getName(), MethodType.methodType(FunctionReference.class).toMethodDescriptorString(), CLOSUREREF_HANDLE, new Object[]{this.klass, arity, isVarArgs});
        if (syntheticCount > 0) {
            String[] refs = closureReference.getCapturedReferenceNames().toArray(new String[syntheticCount]);
            JavaBytecodeUtils.loadInteger(this.methodVisitor, 0);
            JavaBytecodeUtils.loadInteger(this.methodVisitor, syntheticCount);
            this.methodVisitor.visitTypeInsn(189, JOBJECT);
            ReferenceTable table = (ReferenceTable)this.context.referenceTableStack.peek();
            for (int i = 0; i < syntheticCount; ++i) {
                this.methodVisitor.visitInsn(89);
                JavaBytecodeUtils.loadInteger(this.methodVisitor, i);
                this.methodVisitor.visitVarInsn(25, table.get(refs[i]).getIndex());
                this.methodVisitor.visitInsn(83);
            }
            this.methodVisitor.visitMethodInsn(182, "gololang/FunctionReference", "insertArguments", "(I[Ljava/lang/Object;)Lgololang/FunctionReference;", false);
            if (isVarArgs) {
                this.methodVisitor.visitLdcInsn((Object)Type.getType(Object[].class));
                this.methodVisitor.visitMethodInsn(182, "gololang/FunctionReference", "asVarargsCollector", "(Ljava/lang/Class;)Lgololang/FunctionReference;", false);
            }
        }
    }

    @Override
    public void visitBinaryOperation(BinaryOperation binaryOperation) {
        switch (binaryOperation.getType()) {
            case AND: {
                this.andOperator(binaryOperation);
                break;
            }
            case OR: {
                this.orOperator(binaryOperation);
                break;
            }
            case ORIFNULL: {
                this.orIfNullOperator(binaryOperation);
                break;
            }
            default: {
                binaryOperation.walk(this);
                this.genericBinaryOperator(binaryOperation);
            }
        }
    }

    private void genericBinaryOperator(BinaryOperation binaryOperation) {
        if (!binaryOperation.isMethodCall()) {
            String name = binaryOperation.getType().name().toLowerCase();
            this.methodVisitor.visitInvokeDynamicInsn(name, this.goloFunctionSignature(2), OPERATOR_HANDLE, new Object[]{2});
        }
    }

    private void orIfNullOperator(BinaryOperation binaryOperation) {
        int idx = ((ReferenceTable)this.context.referenceTableStack.peek()).size();
        Label nullLabel = new Label();
        Label exitLabel = new Label();
        binaryOperation.getLeftExpression().accept(this);
        this.methodVisitor.visitVarInsn(58, idx);
        this.methodVisitor.visitVarInsn(25, idx);
        this.methodVisitor.visitJumpInsn(198, nullLabel);
        this.methodVisitor.visitJumpInsn(167, exitLabel);
        this.methodVisitor.visitLabel(nullLabel);
        binaryOperation.getRightExpression().accept(this);
        this.methodVisitor.visitVarInsn(58, idx);
        this.methodVisitor.visitLabel(exitLabel);
        this.methodVisitor.visitVarInsn(25, idx);
    }

    private void orOperator(BinaryOperation binaryOperation) {
        Label exitLabel = new Label();
        Label trueLabel = new Label();
        binaryOperation.getLeftExpression().accept(this);
        this.asmBooleanValue();
        this.methodVisitor.visitJumpInsn(154, trueLabel);
        binaryOperation.getRightExpression().accept(this);
        this.asmBooleanValue();
        this.methodVisitor.visitJumpInsn(154, trueLabel);
        this.asmFalseObject();
        this.methodVisitor.visitJumpInsn(167, exitLabel);
        this.methodVisitor.visitLabel(trueLabel);
        this.asmTrueObject();
        this.methodVisitor.visitLabel(exitLabel);
    }

    private void andOperator(BinaryOperation binaryOperation) {
        Label exitLabel = new Label();
        Label falseLabel = new Label();
        binaryOperation.getLeftExpression().accept(this);
        this.asmBooleanValue();
        this.methodVisitor.visitJumpInsn(153, falseLabel);
        binaryOperation.getRightExpression().accept(this);
        this.asmBooleanValue();
        this.methodVisitor.visitJumpInsn(153, falseLabel);
        this.asmTrueObject();
        this.methodVisitor.visitJumpInsn(167, exitLabel);
        this.methodVisitor.visitLabel(falseLabel);
        this.asmFalseObject();
        this.methodVisitor.visitLabel(exitLabel);
    }

    private void asmFalseObject() {
        this.methodVisitor.visitFieldInsn(178, "java/lang/Boolean", "FALSE", "Ljava/lang/Boolean;");
    }

    private void asmTrueObject() {
        this.methodVisitor.visitFieldInsn(178, "java/lang/Boolean", "TRUE", "Ljava/lang/Boolean;");
    }

    private void asmBooleanValue() {
        this.methodVisitor.visitTypeInsn(192, "java/lang/Boolean");
        this.methodVisitor.visitMethodInsn(182, "java/lang/Boolean", "booleanValue", "()Z", false);
    }

    @Override
    public void visitUnaryOperation(UnaryOperation unaryOperation) {
        String name = unaryOperation.getType().name().toLowerCase();
        unaryOperation.getExpressionStatement().accept(this);
        this.methodVisitor.visitInvokeDynamicInsn(name, this.goloFunctionSignature(1), OPERATOR_HANDLE, new Object[]{1});
    }

    private static final class Context {
        private final Deque<ReferenceTable> referenceTableStack = new LinkedList<ReferenceTable>();
        private final Map<LoopStatement, Label> loopStartMap = new HashMap<LoopStatement, Label>();
        private final Map<LoopStatement, Label> loopEndMap = new HashMap<LoopStatement, Label>();

        private Context() {
        }
    }
}

