/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.golo.compiler.ir;

import org.eclipse.golo.compiler.ir.Block;
import org.eclipse.golo.compiler.ir.Builders;
import org.eclipse.golo.compiler.ir.ExpressionStatement;
import org.eclipse.golo.compiler.ir.GoloElement;
import org.eclipse.golo.compiler.ir.GoloIrVisitor;
import org.eclipse.golo.compiler.ir.GoloStatement;
import org.eclipse.golo.compiler.ir.ReferenceTable;
import org.eclipse.golo.compiler.ir.Scope;
import org.eclipse.golo.compiler.parser.GoloASTNode;

public final class ConditionalBranching
extends GoloStatement
implements Scope {
    private ExpressionStatement condition;
    private Block trueBlock;
    private ConditionalBranching elseConditionalBranching;
    private Block falseBlock;

    ConditionalBranching() {
    }

    public ConditionalBranching condition(Object cond) {
        if (cond == null) {
            this.setCondition(Builders.constant(false));
        } else {
            this.setCondition((ExpressionStatement)cond);
        }
        return this;
    }

    public ConditionalBranching whenTrue(Object block) {
        this.setTrueBlock(Builders.toBlock(block));
        return this;
    }

    public ConditionalBranching whenFalse(Object block) {
        this.setFalseBlock(block == null ? null : Builders.toBlock(block));
        return this;
    }

    public ConditionalBranching elseBranch(Object elseBranch) {
        this.elseConditionalBranching = (ConditionalBranching)elseBranch;
        this.makeParentOf(this.elseConditionalBranching);
        return this;
    }

    public ConditionalBranching otherwise(Object alternative) {
        if (alternative instanceof ConditionalBranching) {
            return this.elseBranch((ConditionalBranching)alternative);
        }
        return this.whenFalse(alternative);
    }

    @Override
    public ConditionalBranching ofAST(GoloASTNode node) {
        super.ofAST(node);
        return this;
    }

    @Override
    public void relink(ReferenceTable table) {
        this.trueBlock.relink(table);
        if (this.falseBlock != null) {
            this.falseBlock.relink(table);
        }
        if (this.elseConditionalBranching != null) {
            this.elseConditionalBranching.relink(table);
        }
    }

    @Override
    public void relinkTopLevel(ReferenceTable table) {
        this.trueBlock.relinkTopLevel(table);
        if (this.falseBlock != null) {
            this.falseBlock.relinkTopLevel(table);
        }
        if (this.elseConditionalBranching != null) {
            this.elseConditionalBranching.relinkTopLevel(table);
        }
    }

    public ExpressionStatement getCondition() {
        return this.condition;
    }

    public void setCondition(ExpressionStatement condition) {
        this.condition = condition;
        this.makeParentOf(condition);
    }

    public Block getTrueBlock() {
        return this.trueBlock;
    }

    public void setTrueBlock(Block block) {
        this.trueBlock = block;
        this.makeParentOf(block);
    }

    public Block getFalseBlock() {
        return this.falseBlock;
    }

    public void setFalseBlock(Block block) {
        this.falseBlock = block;
        if (block != null) {
            this.makeParentOf(block);
        }
    }

    public boolean hasFalseBlock() {
        return this.falseBlock != null;
    }

    public ConditionalBranching getElseConditionalBranching() {
        return this.elseConditionalBranching;
    }

    public void setElseConditionalBranching(ConditionalBranching elseBranch) {
        this.elseConditionalBranching = elseBranch;
        this.makeParentOf(elseBranch);
    }

    public boolean hasElseConditionalBranching() {
        return this.elseConditionalBranching != null;
    }

    public boolean returnsFromBothBranches() {
        if (this.hasFalseBlock()) {
            return this.trueBlock.hasReturn() && this.falseBlock.hasReturn();
        }
        if (this.hasElseConditionalBranching()) {
            return this.trueBlock.hasReturn() && this.elseConditionalBranching.returnsFromBothBranches();
        }
        return false;
    }

    public String toString() {
        return String.format("if %s %s%s", this.condition, this.trueBlock, this.hasFalseBlock() ? " else " + this.falseBlock.toString() : (this.hasElseConditionalBranching() ? " else " + this.elseConditionalBranching.toString() : ""));
    }

    @Override
    public void accept(GoloIrVisitor visitor) {
        visitor.visitConditionalBranching(this);
    }

    @Override
    public void walk(GoloIrVisitor visitor) {
        this.condition.accept(visitor);
        this.trueBlock.accept(visitor);
        if (this.falseBlock != null) {
            this.falseBlock.accept(visitor);
        }
        if (this.elseConditionalBranching != null) {
            this.elseConditionalBranching.accept(visitor);
        }
    }

    @Override
    protected void replaceElement(GoloElement original, GoloElement newElement) {
        if (this.condition == original && newElement instanceof ExpressionStatement) {
            this.condition(newElement);
        } else if (this.elseConditionalBranching == original && newElement instanceof ConditionalBranching) {
            this.elseBranch(newElement);
        } else if (this.trueBlock == original) {
            this.whenTrue(newElement);
        } else if (this.falseBlock == original) {
            this.whenFalse(newElement);
        } else {
            throw this.cantReplace(original, newElement);
        }
    }
}

