/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.golo.doc;

import com.github.rjeschke.txtmark.BlockEmitter;
import com.github.rjeschke.txtmark.Configuration;
import com.github.rjeschke.txtmark.Processor;
import gololang.FunctionReference;
import gololang.Predefined;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.golo.compiler.parser.ASTCompilationUnit;
import org.eclipse.golo.doc.AbstractProcessor;
import org.eclipse.golo.doc.ModuleDocumentation;

public class HtmlProcessor
extends AbstractProcessor {
    @Override
    public String render(ASTCompilationUnit compilationUnit) throws Throwable {
        FunctionReference template = this.template("template", "html");
        ModuleDocumentation documentation = new ModuleDocumentation(compilationUnit);
        return (String)template.handle().invokeWithArguments(documentation);
    }

    @Override
    public void process(Map<String, ASTCompilationUnit> units, Path targetFolder) throws Throwable {
        TreeMap<String, String> moduleDocFile = new TreeMap<String, String>();
        this.ensureFolderExists(targetFolder);
        for (ASTCompilationUnit unit : units.values()) {
            String moduleName = this.moduleName(unit);
            Path docFile = this.outputFile(targetFolder, moduleName, ".html");
            this.ensureFolderExists(docFile.getParent());
            Predefined.textToFile(this.render(unit), docFile);
            moduleDocFile.put(moduleName, targetFolder.relativize(docFile).toString());
        }
        FunctionReference indexTemplate = this.template("index", "html");
        String index = (String)indexTemplate.handle().invokeWithArguments(moduleDocFile);
        Predefined.textToFile(index, targetFolder.resolve("index.html"));
    }

    public static BlockEmitter blockHighlighter() {
        return new BlockEmitter(){

            public void emitBlock(StringBuilder out, List<String> lines, String meta) {
                String language = "".equals(meta) ? "golo" : meta;
                out.append("<pre class=\"listing highlight highlightjs\">");
                out.append(String.format("<code class=\"language-%s\" data-lang=\"%s\">", language, language));
                for (String rawLine : lines) {
                    String line = rawLine.replace("&", "&amp;").replace(">", "&gt;").replace("<", "&lt;");
                    out.append(line);
                    out.append('\n');
                }
                out.append("</code></pre>");
                out.append('\n');
            }
        };
    }

    public static String process(String documentation, int rootLevel, Configuration configuration) {
        return Processor.process((String)AbstractProcessor.adaptSections(documentation, rootLevel), (Configuration)configuration);
    }
}

