/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.golo.cli.command;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import gololang.Messages;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import org.eclipse.golo.cli.command.Metadata;
import org.eclipse.golo.cli.command.spi.CliCommand;
import org.eclipse.golo.compiler.GoloCompilationException;
import org.eclipse.golo.compiler.GoloCompiler;

@Parameters(commandNames={"compile"}, resourceBundle="commands", commandDescriptionKey="compile")
public class CompilerCommand
implements CliCommand {
    @Parameter(names={"--output"}, descriptionKey="compile.output")
    String output = ".";
    @Parameter(descriptionKey="source_files")
    List<String> sources = new LinkedList<String>();

    @Override
    public void execute() throws Throwable {
        GoloCompiler compiler = new GoloCompiler();
        boolean compilingToJar = this.output.endsWith(".jar");
        File outputDir = compilingToJar ? null : new File(this.output);
        JarOutputStream jarOutputStream = compilingToJar ? new JarOutputStream((OutputStream)new FileOutputStream(new File(this.output)), this.manifest()) : null;
        for (String source : this.sources) {
            File file = new File(source);
            try {
                FileInputStream in = new FileInputStream(file);
                Throwable throwable = null;
                try {
                    if (compilingToJar) {
                        compiler.compileToJar(file.getName(), in, jarOutputStream);
                        continue;
                    }
                    compiler.compileTo(file.getName(), in, outputDir);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (in == null) continue;
                    if (throwable != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    in.close();
                }
            }
            catch (IOException e) {
                Messages.error(Messages.message("file_not_found", source));
                return;
            }
            catch (GoloCompilationException e) {
                this.handleCompilationException(e);
            }
        }
        if (compilingToJar) {
            jarOutputStream.close();
        }
    }

    private Manifest manifest() {
        Manifest manifest = new Manifest();
        Attributes attributes = manifest.getMainAttributes();
        attributes.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        attributes.put(new Attributes.Name("Created-By"), "Eclipse Golo " + Metadata.VERSION);
        return manifest;
    }
}

