/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.golo.compiler;

import java.util.Objects;

public final class PackageAndClass {
    private final String packageName;
    private final String className;

    public PackageAndClass(String packageName, String className) {
        this.packageName = Objects.requireNonNull(packageName);
        this.className = Objects.requireNonNull(className);
        if (className.isEmpty()) {
            throw new IllegalArgumentException("The class name can't be empty");
        }
    }

    public static PackageAndClass fromString(String qualifiedName) {
        return new PackageAndClass(PackageAndClass.extractTargetJavaPackage(qualifiedName), PackageAndClass.extractTargetJavaClass(qualifiedName));
    }

    private static int packageClassSeparatorIndex(String moduleName) {
        if (moduleName != null) {
            return moduleName.lastIndexOf(46);
        }
        return -1;
    }

    private static String extractTargetJavaPackage(String moduleName) {
        int packageClassSeparatorIndex = PackageAndClass.packageClassSeparatorIndex(moduleName);
        if (packageClassSeparatorIndex > 0) {
            return moduleName.substring(0, packageClassSeparatorIndex);
        }
        return "";
    }

    private static String extractTargetJavaClass(String moduleName) {
        int packageClassSeparatorIndex = PackageAndClass.packageClassSeparatorIndex(moduleName);
        if (packageClassSeparatorIndex > 0) {
            return moduleName.substring(packageClassSeparatorIndex + 1);
        }
        return moduleName;
    }

    public PackageAndClass createInnerClass(String name) {
        return new PackageAndClass(this.packageName, this.className + "$" + name.replace('.', '$'));
    }

    public PackageAndClass createSiblingClass(String name) {
        return new PackageAndClass(this.packageName, name);
    }

    public PackageAndClass createSubPackage(String name) {
        return new PackageAndClass(this.packageName.isEmpty() ? this.className : this.packageName + "." + this.className, name);
    }

    public PackageAndClass inPackage(String qualifiedName) {
        return new PackageAndClass(qualifiedName, this.className);
    }

    public PackageAndClass inPackage(PackageAndClass parent) {
        return new PackageAndClass(parent.packageName(), this.className);
    }

    public String packageName() {
        return this.packageName;
    }

    public boolean hasPackage() {
        return !this.packageName.isEmpty();
    }

    public PackageAndClass parentPackage() {
        return PackageAndClass.fromString(this.packageName);
    }

    public String className() {
        return this.className;
    }

    public String toString() {
        if (this.packageName.isEmpty()) {
            return this.className;
        }
        return this.packageName + "." + this.className;
    }

    public String toJVMType() {
        return this.toString().replaceAll("\\.", "/");
    }

    public String toJVMRef() {
        return "L" + this.toJVMType() + ";";
    }

    public String mangledName() {
        return this.toString().replace('.', '$');
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PackageAndClass that = (PackageAndClass)o;
        if (this.className != null ? !this.className.equals(that.className) : that.className != null) {
            return false;
        }
        return !(this.packageName != null ? !this.packageName.equals(that.packageName) : that.packageName != null);
    }

    public int hashCode() {
        int result = this.packageName != null ? this.packageName.hashCode() : 0;
        result = 31 * result + (this.className != null ? this.className.hashCode() : 0);
        return result;
    }
}

