/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.golo.compiler.ir;

import java.util.Set;
import org.eclipse.golo.compiler.PackageAndClass;
import org.eclipse.golo.compiler.ir.Builders;
import org.eclipse.golo.compiler.ir.GoloFunction;
import org.eclipse.golo.compiler.ir.GoloIrVisitor;
import org.eclipse.golo.compiler.ir.TypeWithMembers;
import org.eclipse.golo.compiler.parser.GoloASTNode;

public final class Struct
extends TypeWithMembers {
    public static final String IMMUTABLE_FACTORY_METHOD = "$_immutable";
    private PackageAndClass moduleName;

    @Override
    public Struct ofAST(GoloASTNode node) {
        super.ofAST(node);
        return this;
    }

    Struct(String name) {
        super(name);
    }

    @Override
    public PackageAndClass getPackageAndClass() {
        return this.moduleName.createSubPackage("types").createSubPackage(this.getName());
    }

    public void setModuleName(PackageAndClass module) {
        this.moduleName = module;
    }

    private GoloFunction createDefaultConstructor() {
        return Builders.functionDeclaration(this.getName()).synthetic().returns(Builders.call(this.getFactoryDelegateName()));
    }

    private String getImmutableName() {
        return "Immutable" + this.getName();
    }

    private GoloFunction createFullArgsImmutableConstructor() {
        return Builders.functionDeclaration(this.getImmutableName()).synthetic().withParameters(this.getMemberNames()).returns(Builders.call(this.getFactoryDelegateName() + "." + IMMUTABLE_FACTORY_METHOD).withArgs(this.getFullArgs()));
    }

    @Override
    public Set<GoloFunction> createFactories() {
        Set<GoloFunction> factories = super.createFactories();
        factories.add(this.createDefaultConstructor());
        factories.add(this.createFullArgsImmutableConstructor());
        return factories;
    }

    @Override
    public void accept(GoloIrVisitor visitor) {
        visitor.visitStruct(this);
    }
}

