/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.golo.compiler.ir;

import java.util.Objects;
import org.eclipse.golo.compiler.ir.Block;
import org.eclipse.golo.compiler.ir.Builders;
import org.eclipse.golo.compiler.ir.GoloElement;
import org.eclipse.golo.compiler.ir.GoloIrVisitor;
import org.eclipse.golo.compiler.ir.GoloStatement;
import org.eclipse.golo.compiler.parser.GoloASTNode;

public class TryCatchFinally
extends GoloStatement {
    private final String exceptionId;
    private Block tryBlock;
    private Block catchBlock;
    private Block finallyBlock;

    TryCatchFinally(String exceptionId) {
        this.exceptionId = exceptionId;
    }

    @Override
    public TryCatchFinally ofAST(GoloASTNode node) {
        super.ofAST(node);
        return this;
    }

    public String getExceptionId() {
        return this.exceptionId;
    }

    public Block getTryBlock() {
        return this.tryBlock;
    }

    public TryCatchFinally trying(Object block) {
        this.tryBlock = (Block)block;
        this.makeParentOf(this.tryBlock);
        return this;
    }

    public Block getCatchBlock() {
        return this.catchBlock;
    }

    public TryCatchFinally catching(Object block) {
        this.catchBlock = (Block)block;
        this.makeParentOf(this.catchBlock);
        this.catchBlock.getReferenceTable().add(Builders.localRef(this.exceptionId).synthetic());
        return this;
    }

    public Block getFinallyBlock() {
        return this.finallyBlock;
    }

    public TryCatchFinally finalizing(Object block) {
        this.finallyBlock = (Block)block;
        this.makeParentOf(this.finallyBlock);
        return this;
    }

    public boolean hasFinallyBlock() {
        return this.finallyBlock != null;
    }

    public boolean hasCatchBlock() {
        return this.catchBlock != null;
    }

    public boolean isTryCatchFinally() {
        return this.hasCatchBlock() && this.hasFinallyBlock();
    }

    public boolean isTryCatch() {
        return this.hasCatchBlock() && !this.hasFinallyBlock();
    }

    public boolean isTryFinally() {
        return !this.hasCatchBlock() && this.hasFinallyBlock();
    }

    @Override
    public void accept(GoloIrVisitor visitor) {
        visitor.visitTryCatchFinally(this);
    }

    @Override
    public void walk(GoloIrVisitor visitor) {
        this.tryBlock.accept(visitor);
        if (this.catchBlock != null) {
            this.catchBlock.accept(visitor);
        }
        if (this.finallyBlock != null) {
            this.finallyBlock.accept(visitor);
        }
    }

    @Override
    protected void replaceElement(GoloElement original, GoloElement newElement) {
        if (Objects.equals(original, this.tryBlock)) {
            this.trying(newElement);
        } else if (Objects.equals(original, this.catchBlock)) {
            this.catching(newElement);
        } else if (Objects.equals(original, this.finallyBlock)) {
            this.finalizing(newElement);
        } else {
            throw this.cantReplace(original, newElement);
        }
    }
}

