/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.golo.compiler.ir;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.golo.compiler.PackageAndClass;
import org.eclipse.golo.compiler.ir.Builders;
import org.eclipse.golo.compiler.ir.GoloElement;
import org.eclipse.golo.compiler.ir.GoloFunction;
import org.eclipse.golo.compiler.ir.GoloIrVisitor;
import org.eclipse.golo.compiler.ir.Member;
import org.eclipse.golo.compiler.ir.ReferenceLookup;

abstract class TypeWithMembers
extends GoloElement {
    private final Set<Member> members = new LinkedHashSet<Member>();
    private final String name;

    TypeWithMembers(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    protected String getFactoryDelegateName() {
        return this.getFullName();
    }

    public abstract PackageAndClass getPackageAndClass();

    String getFullName() {
        return this.getPackageAndClass().toString();
    }

    public TypeWithMembers members(Object ... members) {
        for (Object member : members) {
            this.withMember(member);
        }
        return this;
    }

    public boolean hasMembers() {
        return !this.members.isEmpty();
    }

    protected void addMember(Member member) {
        this.members.add(member);
        this.makeParentOf(member);
    }

    void addMembers(Iterable<Member> members) {
        members.forEach(this::addMember);
    }

    public TypeWithMembers withMember(Object member) {
        if (member instanceof Member) {
            this.addMember((Member)member);
        } else {
            this.addMember(new Member(member.toString()));
        }
        return this;
    }

    protected List<String> getMemberNames() {
        return this.members.stream().map(Member::getName).collect(Collectors.toList());
    }

    public Set<Member> getMembers() {
        return Collections.unmodifiableSet(this.members);
    }

    public List<Member> getPublicMembers() {
        return this.members.stream().filter(Member::isPublic).collect(Collectors.toList());
    }

    protected Object[] getFullArgs() {
        return this.members.stream().map(Member::getName).map(ReferenceLookup::new).toArray();
    }

    public Set<GoloFunction> createFactories() {
        LinkedHashSet<GoloFunction> factories = new LinkedHashSet<GoloFunction>();
        factories.add(this.createFullArgsConstructor());
        return factories;
    }

    protected GoloFunction createFullArgsConstructor() {
        return Builders.functionDeclaration(this.getName()).synthetic().withParameters(this.getMemberNames()).returns(Builders.call(this.getFactoryDelegateName()).withArgs(this.getFullArgs()));
    }

    @Override
    public void walk(GoloIrVisitor visitor) {
        for (Member m : this.members) {
            m.accept(visitor);
        }
    }

    @Override
    protected void replaceElement(GoloElement original, GoloElement newElement) {
        throw this.cantReplace();
    }
}

