/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.golo.compiler;

import gololang.Messages;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.eclipse.golo.compiler.GoloCompilationException;
import org.eclipse.golo.compiler.ir.AbstractGoloIrVisitor;
import org.eclipse.golo.compiler.ir.AssignmentStatement;
import org.eclipse.golo.compiler.ir.Block;
import org.eclipse.golo.compiler.ir.ClosureReference;
import org.eclipse.golo.compiler.ir.FunctionInvocation;
import org.eclipse.golo.compiler.ir.GoloFunction;
import org.eclipse.golo.compiler.ir.GoloModule;
import org.eclipse.golo.compiler.ir.LocalReference;
import org.eclipse.golo.compiler.ir.LoopBreakFlowStatement;
import org.eclipse.golo.compiler.ir.LoopStatement;
import org.eclipse.golo.compiler.ir.Member;
import org.eclipse.golo.compiler.ir.PositionInSourceCode;
import org.eclipse.golo.compiler.ir.ReferenceLookup;
import org.eclipse.golo.compiler.ir.ReferenceTable;
import org.eclipse.golo.compiler.parser.GoloASTNode;

class LocalReferenceAssignmentAndVerificationVisitor
extends AbstractGoloIrVisitor {
    private GoloModule module = null;
    private AssignmentCounter assignmentCounter = new AssignmentCounter();
    private Deque<GoloFunction> functionStack = new LinkedList<GoloFunction>();
    private Deque<ReferenceTable> tableStack = new LinkedList<ReferenceTable>();
    private Deque<Set<LocalReference>> assignmentStack = new LinkedList<Set<LocalReference>>();
    private Deque<LoopStatement> loopStack = new LinkedList<LoopStatement>();
    private GoloCompilationException.Builder exceptionBuilder;
    private final HashSet<LocalReference> uninitializedReferences = new HashSet();

    LocalReferenceAssignmentAndVerificationVisitor() {
    }

    LocalReferenceAssignmentAndVerificationVisitor(GoloCompilationException.Builder builder) {
        this();
        this.setExceptionBuilder(builder);
    }

    public void setExceptionBuilder(GoloCompilationException.Builder builder) {
        this.exceptionBuilder = builder;
    }

    private GoloCompilationException.Builder getExceptionBuilder() {
        if (this.exceptionBuilder == null) {
            this.exceptionBuilder = new GoloCompilationException.Builder(this.module.getPackageAndClass().toString());
        }
        return this.exceptionBuilder;
    }

    private void errorMessage(GoloCompilationException.Problem.Type type, GoloASTNode node, String message) {
        PositionInSourceCode position = node.getPositionInSourceCode();
        String errorMessage = message + ' ' + (position != null ? Messages.message("source_position", position.getLine(), position.getColumn()) : Messages.message("generated_code")) + ".";
        this.getExceptionBuilder().report(type, node, errorMessage);
    }

    @Override
    public void visitModule(GoloModule module) {
        this.module = module;
        module.walk(this);
    }

    @Override
    public void visitFunction(GoloFunction function) {
        this.assignmentCounter.reset();
        this.functionStack.push(function);
        ReferenceTable table = function.getBlock().getReferenceTable();
        for (String parameterName : function.getParameterNames()) {
            LocalReference reference = table.get(parameterName);
            this.uninitializedReferences.remove(reference);
            if (reference == null) {
                if (function.isSynthetic()) continue;
                throw new IllegalStateException(Messages.prefixed("bug", Messages.message("parameter_not_declared", parameterName, function.getName())));
            }
            reference.setIndex(this.assignmentCounter.next());
        }
        function.walk(this);
        this.functionStack.pop();
    }

    @Override
    public void visitBlock(Block block) {
        ReferenceTable table = block.getReferenceTable();
        this.extractUninitializedReferences(table);
        this.tableStack.push(table);
        this.assignmentStack.push(this.extractAssignedReferences(table));
        block.walk(this);
        this.assignmentStack.pop();
        this.tableStack.pop();
    }

    private void extractUninitializedReferences(ReferenceTable table) {
        for (LocalReference reference : table.ownedReferences()) {
            if (reference.getIndex() >= 0 || reference.isModuleState()) continue;
            reference.setIndex(this.assignmentCounter.next());
            this.uninitializedReferences.add(reference);
        }
    }

    private Set<LocalReference> extractAssignedReferences(ReferenceTable table) {
        HashSet<LocalReference> assigned = new HashSet<LocalReference>();
        if (table == this.functionStack.peek().getBlock().getReferenceTable()) {
            for (String param : this.functionStack.peek().getParameterNames()) {
                assigned.add(table.get(param));
            }
        }
        if (!this.assignmentStack.isEmpty()) {
            assigned.addAll((Collection<LocalReference>)this.assignmentStack.peek());
        }
        return assigned;
    }

    @Override
    public void visitFunctionInvocation(FunctionInvocation functionInvocation) {
        if (!this.tableStack.isEmpty() && this.tableStack.peek().hasReferenceFor(functionInvocation.getName())) {
            if (this.tableStack.peek().get(functionInvocation.getName()).isModuleState()) {
                functionInvocation.onModuleState();
            } else {
                functionInvocation.onReference();
            }
        }
        functionInvocation.walk(this);
    }

    @Override
    public void visitAssignmentStatement(AssignmentStatement assignmentStatement) {
        Set<LocalReference> assignedReferences;
        LocalReference reference = assignmentStatement.getLocalReference();
        if (this.redeclaringReferenceInBlock(assignmentStatement, reference, assignedReferences = this.assignmentStack.peek())) {
            this.errorMessage(GoloCompilationException.Problem.Type.REFERENCE_ALREADY_DECLARED_IN_BLOCK, assignmentStatement.getASTNode(), Messages.message("reference_already_declared", reference.getName()));
        } else if (this.assigningConstant(reference, assignedReferences)) {
            this.errorMessage(GoloCompilationException.Problem.Type.ASSIGN_CONSTANT, assignmentStatement.getASTNode(), Messages.message("assign_constant", reference.getName()));
        }
        this.bindReference(reference);
        assignedReferences.add(reference);
        assignmentStatement.walk(this);
        if (assignmentStatement.isDeclaring() && !reference.isSynthetic()) {
            this.uninitializedReferences.remove(reference);
        }
    }

    private void bindReference(LocalReference reference) {
        ReferenceTable table = this.tableStack.peek();
        if (reference.getIndex() < 0) {
            if (table.hasReferenceFor(reference.getName())) {
                reference.setIndex(table.get(reference.getName()).getIndex());
            } else if (reference.isSynthetic()) {
                reference.setIndex(this.assignmentCounter.next());
                table.add(reference);
            }
        }
    }

    private boolean redeclaringReferenceInBlock(AssignmentStatement assignmentStatement, LocalReference reference, Set<LocalReference> assignedReferences) {
        return !reference.isSynthetic() && assignmentStatement.isDeclaring() && this.referenceNameExists(reference, assignedReferences);
    }

    private boolean assigningConstant(LocalReference reference, Set<LocalReference> assignedReferences) {
        return reference.isConstant() && (assignedReferences.contains(reference) || reference.isModuleState() && !this.functionStack.peek().isModuleInit());
    }

    private boolean referenceNameExists(LocalReference reference, Set<LocalReference> referencesInBlock) {
        for (LocalReference ref : referencesInBlock) {
            if (ref == null || !ref.getName().equals(reference.getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void visitReferenceLookup(ReferenceLookup referenceLookup) {
        LocalReference ref;
        ReferenceTable table = this.tableStack.peek();
        if (table == null) {
            return;
        }
        if (!table.hasReferenceFor(referenceLookup.getName())) {
            this.errorMessage(GoloCompilationException.Problem.Type.UNDECLARED_REFERENCE, referenceLookup.getASTNode(), Messages.message("undeclared_reference", referenceLookup.getName(), !this.functionStack.isEmpty() ? Messages.message("in_function", this.functionStack.peek().getName()) : ""));
        }
        if (this.isUninitialized(ref = referenceLookup.resolveIn(table))) {
            this.errorMessage(GoloCompilationException.Problem.Type.UNINITIALIZED_REFERENCE_ACCESS, referenceLookup.getASTNode(), Messages.message("uninitialized_reference_access", ref.getName()));
        }
    }

    private boolean isUninitialized(LocalReference ref) {
        return ref != null && !ref.isSynthetic() && !ref.isModuleState() && this.uninitializedReferences.contains(ref);
    }

    @Override
    public void visitLoopStatement(LoopStatement loopStatement) {
        this.loopStack.push(loopStatement);
        loopStatement.walk(this);
        this.loopStack.pop();
    }

    @Override
    public void visitClosureReference(ClosureReference closureReference) {
        closureReference.updateCapturedReferenceNames();
    }

    @Override
    public void visitLoopBreakFlowStatement(LoopBreakFlowStatement loopBreakFlowStatement) {
        if (this.loopStack.isEmpty()) {
            this.errorMessage(GoloCompilationException.Problem.Type.BREAK_OR_CONTINUE_OUTSIDE_LOOP, loopBreakFlowStatement.getASTNode(), Messages.message("break_or_continue_outside_loop"));
        } else {
            loopBreakFlowStatement.setEnclosingLoop(this.loopStack.peek());
        }
    }

    @Override
    public void visitMember(Member member) {
    }

    private static class AssignmentCounter {
        private int counter = 0;

        private AssignmentCounter() {
        }

        public int next() {
            return this.counter++;
        }

        public void reset() {
            this.counter = 0;
        }
    }
}

