/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.golo.cli.command.spi;

import gololang.Messages;
import gololang.Runtime;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import org.eclipse.golo.compiler.GoloCompilationException;

public interface CliCommand {
    public void execute() throws Throwable;

    default public void callRun(Class<?> klass, String[] arguments) throws Throwable {
        MethodHandle main;
        try {
            main = MethodHandles.publicLookup().findStatic(klass, "main", MethodType.methodType(Void.TYPE, String[].class));
        }
        catch (NoSuchMethodException e) {
            throw new NoMainMethodException().initCause(e);
        }
        main.invoke(arguments);
    }

    default public void handleCompilationException(GoloCompilationException e) {
        this.handleCompilationException(e, true);
    }

    default public void handleCompilationException(GoloCompilationException e, boolean exit) {
        Messages.error(e.getMessage());
        for (GoloCompilationException.Problem problem : e.getProblems()) {
            Messages.error(problem.getDescription());
        }
        if (exit) {
            System.exit(1);
        }
    }

    default public void handleThrowable(Throwable e) {
        this.handleThrowable(e, true);
    }

    default public void handleThrowable(Throwable e, boolean exit) {
        this.handleThrowable(e, exit, Runtime.debugMode() || Runtime.showStackTrace());
    }

    default public void handleThrowable(Throwable e, boolean exit, boolean withStack) {
        Messages.error(e);
        if (e.getCause() != null) {
            Messages.error(e.getCause().getMessage());
        }
        if (withStack) {
            Messages.printStackTrace(e);
        } else {
            Messages.error(Messages.message("use_debug"));
        }
        if (exit) {
            System.exit(1);
        }
    }

    public static class NoMainMethodException
    extends NoSuchMethodException {
    }
}

