/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.golo.compiler;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.golo.compiler.CodeGenerationResult;
import org.eclipse.golo.compiler.JavaBytecodeUtils;
import org.eclipse.golo.compiler.PackageAndClass;
import org.eclipse.golo.compiler.ir.Member;
import org.eclipse.golo.compiler.ir.Union;
import org.eclipse.golo.compiler.ir.UnionValue;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;

class JavaBytecodeUnionGenerator {
    JavaBytecodeUnionGenerator() {
    }

    public Collection<CodeGenerationResult> compile(Union union, String sourceFilename) {
        LinkedList<CodeGenerationResult> results = new LinkedList<CodeGenerationResult>();
        ClassWriter classWriter = new ClassWriter(3);
        classWriter.visitSource(sourceFilename, null);
        classWriter.visit(52, 1057, union.getPackageAndClass().toJVMType(), null, "gololang/Union", null);
        this.makeDefaultConstructor(classWriter, "gololang/Union");
        HashMap<String, PackageAndClass> staticFields = new HashMap<String, PackageAndClass>();
        for (UnionValue value : union.getValues()) {
            this.makeMatchlikeTestMethod(classWriter, value, false);
            results.add(this.makeUnionValue(classWriter, sourceFilename, value));
            if (value.hasMembers()) {
                this.makeStaticFactory(classWriter, value);
                continue;
            }
            staticFields.put(value.getName(), value.getPackageAndClass());
        }
        this.initStaticFields(classWriter, union.getPackageAndClass(), staticFields);
        classWriter.visitEnd();
        results.addFirst(new CodeGenerationResult(classWriter.toByteArray(), union.getPackageAndClass()));
        return results;
    }

    private void initStaticFields(ClassWriter cw, PackageAndClass unionType, Map<String, PackageAndClass> staticFields) {
        MethodVisitor mv = cw.visitMethod(8, "<clinit>", "()V", null, null);
        mv.visitCode();
        for (Map.Entry<String, PackageAndClass> attr : staticFields.entrySet()) {
            mv.visitTypeInsn(187, attr.getValue().toJVMType());
            mv.visitInsn(89);
            mv.visitMethodInsn(183, attr.getValue().toJVMType(), "<init>", "()V", false);
            mv.visitFieldInsn(179, unionType.toJVMType(), attr.getKey(), unionType.toJVMRef());
        }
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void makeStaticFactory(ClassWriter cw, UnionValue value) {
        MethodVisitor mv = cw.visitMethod(9, value.getName(), this.argsSignature(value.getMembers().size()) + value.getUnion().getPackageAndClass().toJVMRef(), null, null);
        for (Member member : value.getMembers()) {
            mv.visitParameter(member.getName(), 16);
        }
        mv.visitCode();
        mv.visitTypeInsn(187, value.getPackageAndClass().toJVMType());
        mv.visitInsn(89);
        for (int i = 0; i < value.getMembers().size(); ++i) {
            mv.visitVarInsn(25, i);
        }
        mv.visitMethodInsn(183, value.getPackageAndClass().toJVMType(), "<init>", this.argsSignature(value.getMembers().size()) + "V", false);
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void makeDefaultConstructor(ClassWriter classWriter, String superCls) {
        MethodVisitor visitor = classWriter.visitMethod(4, "<init>", "()V", null, null);
        visitor.visitCode();
        visitor.visitVarInsn(25, 0);
        visitor.visitMethodInsn(183, superCls, "<init>", "()V", false);
        visitor.visitInsn(177);
        visitor.visitMaxs(0, 0);
        visitor.visitEnd();
    }

    private void makeMatchlikeTestMethod(ClassWriter classWriter, UnionValue value, boolean result) {
        String methName = "is" + value.getName();
        MethodVisitor mv = classWriter.visitMethod(1, methName, "()Z", null, null);
        mv.visitCode();
        mv.visitInsn(result ? 4 : 3);
        mv.visitInsn(172);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        if (value.hasMembers()) {
            mv = classWriter.visitMethod(1, methName, this.argsSignature(value.getMembers().size()) + "Z", null, null);
            for (Member member : value.getMembers()) {
                mv.visitParameter(member.getName(), 16);
            }
            mv.visitCode();
            if (!result) {
                mv.visitInsn(3);
            } else {
                int i = 1;
                Label allEquals = new Label();
                Label notEqual = new Label();
                String target = value.getPackageAndClass().toJVMType();
                for (Member member : value.getMembers()) {
                    mv.visitVarInsn(25, i);
                    mv.visitVarInsn(25, 0);
                    mv.visitFieldInsn(180, target, member.getName(), "Ljava/lang/Object;");
                    mv.visitMethodInsn(184, "java/util/Objects", "equals", "(Ljava/lang/Object;Ljava/lang/Object;)Z", false);
                    mv.visitJumpInsn(153, notEqual);
                    ++i;
                }
                mv.visitInsn(4);
                mv.visitJumpInsn(167, allEquals);
                mv.visitLabel(notEqual);
                mv.visitInsn(3);
                mv.visitLabel(allEquals);
            }
            mv.visitInsn(172);
            mv.visitMaxs(0, 0);
            mv.visitEnd();
        }
    }

    private void makeToString(ClassWriter classWriter, UnionValue value) {
        MethodVisitor visitor = classWriter.visitMethod(1, "toString", "()Ljava/lang/String;", null, null);
        visitor.visitCode();
        if (!value.hasMembers()) {
            visitor.visitLdcInsn((Object)("union " + value.getUnion().getPackageAndClass().className() + "." + value.getName()));
        } else {
            visitor.visitTypeInsn(187, "java/lang/StringBuilder");
            visitor.visitInsn(89);
            visitor.visitLdcInsn((Object)("union " + value.getUnion().getPackageAndClass().className() + "." + value.getName() + "{"));
            visitor.visitMethodInsn(183, "java/lang/StringBuilder", "<init>", "(Ljava/lang/String;)V", false);
            visitor.visitVarInsn(58, 1);
            boolean first = true;
            for (Member member : value.getMembers()) {
                visitor.visitVarInsn(25, 1);
                visitor.visitLdcInsn((Object)((first ? "" : ", ") + member.getName() + "="));
                visitor.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;", false);
                visitor.visitInsn(87);
                visitor.visitVarInsn(25, 1);
                visitor.visitVarInsn(25, 0);
                visitor.visitFieldInsn(180, value.getPackageAndClass().toJVMType(), member.getName(), "Ljava/lang/Object;");
                visitor.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(Ljava/lang/Object;)Ljava/lang/StringBuilder;", false);
                visitor.visitInsn(87);
                first = false;
            }
            visitor.visitVarInsn(25, 1);
            visitor.visitLdcInsn((Object)"}");
            visitor.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;", false);
            visitor.visitInsn(87);
            visitor.visitVarInsn(25, 1);
            visitor.visitMethodInsn(182, "java/lang/StringBuilder", "toString", "()Ljava/lang/String;", false);
        }
        visitor.visitInsn(176);
        visitor.visitMaxs(0, 0);
        visitor.visitEnd();
    }

    private CodeGenerationResult makeUnionValue(ClassWriter parentClassWriter, String sourceFilename, UnionValue value) {
        String unionType = value.getUnion().getPackageAndClass().toJVMType();
        String valueType = value.getPackageAndClass().toJVMType();
        ClassWriter classWriter = new ClassWriter(3);
        classWriter.visitSource(sourceFilename, null);
        classWriter.visit(52, 49, valueType, null, unionType, null);
        classWriter.visitInnerClass(valueType, unionType, value.getName(), 25);
        parentClassWriter.visitInnerClass(valueType, unionType, value.getName(), 25);
        for (Member member : value.getMembers()) {
            classWriter.visitField(17, member.getName(), "Ljava/lang/Object;", null, null).visitEnd();
        }
        if (value.hasMembers()) {
            this.makeValuedConstructor(classWriter, value);
            this.makeHashCode(classWriter, value);
            this.makeEquals(classWriter, value);
            this.makeToArray(classWriter, value);
        } else {
            this.makeDefaultConstructor(classWriter, unionType);
            parentClassWriter.visitField(25, value.getName(), value.getUnion().getPackageAndClass().toJVMRef(), null, null).visitEnd();
        }
        this.makeToString(classWriter, value);
        this.makeMatchlikeTestMethod(classWriter, value, true);
        classWriter.visitEnd();
        return new CodeGenerationResult(classWriter.toByteArray(), value.getPackageAndClass());
    }

    private void makeEquals(ClassWriter cw, UnionValue value) {
        String target = value.getPackageAndClass().toJVMType();
        MethodVisitor mv = cw.visitMethod(1, "equals", "(Ljava/lang/Object;)Z", null, null);
        Label notSameInstance = new Label();
        Label notNull = new Label();
        Label sameType = new Label();
        Label allAttrsEquals = new Label();
        Label attrNotEqual = new Label();
        mv.visitCode();
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 0);
        mv.visitJumpInsn(166, notSameInstance);
        mv.visitInsn(4);
        mv.visitInsn(172);
        mv.visitLabel(notSameInstance);
        mv.visitVarInsn(25, 1);
        mv.visitJumpInsn(199, notNull);
        mv.visitInsn(3);
        mv.visitInsn(172);
        mv.visitLabel(notNull);
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(193, target);
        mv.visitJumpInsn(154, sameType);
        mv.visitInsn(3);
        mv.visitInsn(172);
        mv.visitLabel(sameType);
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(192, target);
        mv.visitVarInsn(58, 2);
        for (Member member : value.getMembers()) {
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, target, member.getName(), "Ljava/lang/Object;");
            mv.visitVarInsn(25, 2);
            mv.visitFieldInsn(180, target, member.getName(), "Ljava/lang/Object;");
            mv.visitMethodInsn(184, "java/util/Objects", "equals", "(Ljava/lang/Object;Ljava/lang/Object;)Z", false);
            mv.visitJumpInsn(153, attrNotEqual);
        }
        mv.visitInsn(4);
        mv.visitJumpInsn(167, allAttrsEquals);
        mv.visitLabel(attrNotEqual);
        mv.visitInsn(3);
        mv.visitLabel(allAttrsEquals);
        mv.visitInsn(172);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void makeHashCode(ClassWriter cw, UnionValue value) {
        MethodVisitor mv = cw.visitMethod(1, "hashCode", "()I", null, null);
        mv.visitCode();
        this.loadMembersArray(mv, value);
        mv.visitMethodInsn(184, "java/util/Objects", "hash", "([Ljava/lang/Object;)I", false);
        mv.visitInsn(172);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void loadMembersArray(MethodVisitor mv, UnionValue value) {
        JavaBytecodeUtils.loadInteger(mv, value.getMembers().size());
        mv.visitTypeInsn(189, "java/lang/Object");
        int i = 0;
        for (Member member : value.getMembers()) {
            mv.visitInsn(89);
            JavaBytecodeUtils.loadInteger(mv, i);
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, value.getPackageAndClass().toJVMType(), member.getName(), "Ljava/lang/Object;");
            mv.visitInsn(83);
            ++i;
        }
    }

    private void makeToArray(ClassWriter cw, UnionValue value) {
        MethodVisitor mv = cw.visitMethod(1, "toArray", "()[Ljava/lang/Object;", null, null);
        mv.visitCode();
        this.loadMembersArray(mv, value);
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private String argsSignature(int membersCount) {
        StringBuilder signature = new StringBuilder("(");
        for (int i = 0; i < membersCount; ++i) {
            signature.append("Ljava/lang/Object;");
        }
        signature.append(")");
        return signature.toString();
    }

    private void makeValuedConstructor(ClassWriter cw, UnionValue value) {
        MethodVisitor mv = cw.visitMethod(4, "<init>", this.argsSignature(value.getMembers().size()) + "V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, value.getUnion().getPackageAndClass().toJVMType(), "<init>", "()V", false);
        int idx = 1;
        for (Member member : value.getMembers()) {
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, idx++);
            mv.visitFieldInsn(181, value.getPackageAndClass().toJVMType(), member.getName(), "Ljava/lang/Object;");
        }
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }
}

