/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.golo.compiler.ir;

import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.eclipse.golo.compiler.ir.Block;
import org.eclipse.golo.compiler.ir.BlockContainer;
import org.eclipse.golo.compiler.ir.Builders;
import org.eclipse.golo.compiler.ir.ExpressionStatement;
import org.eclipse.golo.compiler.ir.GoloElement;
import org.eclipse.golo.compiler.ir.GoloIrVisitor;
import org.eclipse.golo.compiler.ir.GoloStatement;
import org.eclipse.golo.compiler.ir.LocalReference;
import org.eclipse.golo.compiler.ir.ReferencesHolder;
import org.eclipse.golo.compiler.parser.GoloASTNode;

public final class ForEachLoopStatement
extends GoloStatement
implements BlockContainer,
ReferencesHolder {
    private Block block = Block.emptyBlock();
    private ExpressionStatement iterable;
    private final List<LocalReference> valueRefs = new LinkedList<LocalReference>();
    private ExpressionStatement whenClause;
    private boolean isVarargs = false;

    ForEachLoopStatement() {
    }

    public ForEachLoopStatement block(Object block) {
        this.block = Builders.toBlock(block);
        return this;
    }

    @Override
    public ForEachLoopStatement ofAST(GoloASTNode node) {
        node.setIrElement(this);
        return this;
    }

    public ForEachLoopStatement on(Object iterable) {
        this.iterable = ExpressionStatement.of(iterable);
        return this;
    }

    public ForEachLoopStatement varargs(boolean b) {
        this.isVarargs = b;
        return this;
    }

    public ForEachLoopStatement var(Object varRef) {
        LocalReference ref;
        if (varRef instanceof String) {
            ref = Builders.localRef(varRef).variable();
        } else if (varRef instanceof LocalReference) {
            ref = (LocalReference)varRef;
        } else {
            throw new IllegalArgumentException("not a ref, a string or a builder");
        }
        this.valueRefs.add(ref);
        return this;
    }

    public ForEachLoopStatement when(Object clause) {
        this.whenClause = ExpressionStatement.of(clause);
        return this;
    }

    public ExpressionStatement getIterable() {
        return this.iterable;
    }

    @Override
    public Block getBlock() {
        return this.block;
    }

    public boolean isDestructuring() {
        return this.valueRefs.size() > 1;
    }

    public boolean isVarargs() {
        return this.isVarargs;
    }

    public LocalReference getLocalReference() {
        return this.valueRefs.get(0);
    }

    @Override
    public LocalReference[] getReferences() {
        return this.valueRefs.toArray(new LocalReference[this.valueRefs.size()]);
    }

    @Override
    public int getReferencesCount() {
        return this.valueRefs.size();
    }

    public boolean hasWhenClause() {
        return this.whenClause != null;
    }

    public ExpressionStatement getWhenClause() {
        return this.whenClause;
    }

    @Override
    public void accept(GoloIrVisitor visitor) {
        visitor.visitForEachLoopStatement(this);
    }

    @Override
    public void walk(GoloIrVisitor visitor) {
        for (LocalReference ref : this.valueRefs) {
            ref.accept(visitor);
        }
        this.iterable.accept(visitor);
        if (this.whenClause != null) {
            this.whenClause.accept(visitor);
        }
        this.block.accept(visitor);
    }

    @Override
    protected void replaceElement(GoloElement original, GoloElement newElement) {
        if (Objects.equals(this.iterable, original)) {
            this.on(newElement);
        } else if (Objects.equals(this.whenClause, original)) {
            this.when(newElement);
        } else if (Objects.equals(this.block, original)) {
            this.block(newElement);
        } else {
            throw this.cantReplace(original, newElement);
        }
    }
}

