/*
 * Decompiled with CFR 0.152.
 */
package com.github.rjeschke.txtmark;

import com.github.rjeschke.txtmark.Block;
import com.github.rjeschke.txtmark.BlockType;
import com.github.rjeschke.txtmark.Configuration;
import com.github.rjeschke.txtmark.Decorator;
import com.github.rjeschke.txtmark.Emitter;
import com.github.rjeschke.txtmark.Line;
import com.github.rjeschke.txtmark.LineType;
import com.github.rjeschke.txtmark.LinkRef;
import com.github.rjeschke.txtmark.Utils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;

public class Processor {
    private final Reader reader;
    private final Emitter emitter;
    final Configuration config;
    private boolean useExtensions = false;

    private Processor(Reader reader, Configuration config) {
        this.reader = reader;
        this.config = config;
        this.useExtensions = config.forceExtendedProfile;
        this.emitter = new Emitter(this.config);
    }

    public static final String process(Reader reader, Configuration configuration) throws IOException {
        Processor p = new Processor(!(reader instanceof BufferedReader) ? new BufferedReader(reader) : reader, configuration);
        return p.process();
    }

    public static final String process(String input, Configuration configuration) {
        try {
            return Processor.process((Reader)new StringReader(input), configuration);
        }
        catch (IOException e) {
            return null;
        }
    }

    public static final String process(File file, Configuration configuration) throws IOException {
        FileInputStream input = new FileInputStream(file);
        String ret = Processor.process((InputStream)input, configuration);
        input.close();
        return ret;
    }

    public static final String process(InputStream input, Configuration configuration) throws IOException {
        Processor p = new Processor(new BufferedReader(new InputStreamReader(input, configuration.encoding)), configuration);
        return p.process();
    }

    public static final String process(String input) {
        return Processor.process(input, Configuration.DEFAULT);
    }

    public static final String process(String input, boolean safeMode) {
        return Processor.process(input, Configuration.builder().setSafeMode(safeMode).build());
    }

    public static final String process(String input, Decorator decorator) {
        return Processor.process(input, Configuration.builder().setDecorator(decorator).build());
    }

    public static final String process(String input, Decorator decorator, boolean safeMode) {
        return Processor.process(input, Configuration.builder().setDecorator(decorator).setSafeMode(safeMode).build());
    }

    public static final String process(File file) throws IOException {
        return Processor.process(file, Configuration.DEFAULT);
    }

    public static final String process(File file, boolean safeMode) throws IOException {
        return Processor.process(file, Configuration.builder().setSafeMode(safeMode).build());
    }

    public static final String process(File file, Decorator decorator) throws IOException {
        return Processor.process(file, Configuration.builder().setDecorator(decorator).build());
    }

    public static final String process(File file, Decorator decorator, boolean safeMode) throws IOException {
        return Processor.process(file, Configuration.builder().setDecorator(decorator).setSafeMode(safeMode).build());
    }

    public static final String process(File file, String encoding) throws IOException {
        return Processor.process(file, Configuration.builder().setEncoding(encoding).build());
    }

    public static final String process(File file, String encoding, boolean safeMode) throws IOException {
        return Processor.process(file, Configuration.builder().setEncoding(encoding).setSafeMode(safeMode).build());
    }

    public static final String process(File file, String encoding, Decorator decorator) throws IOException {
        return Processor.process(file, Configuration.builder().setEncoding(encoding).setDecorator(decorator).build());
    }

    public static final String process(File file, String encoding, Decorator decorator, boolean safeMode) throws IOException {
        return Processor.process(file, Configuration.builder().setEncoding(encoding).setSafeMode(safeMode).setDecorator(decorator).build());
    }

    public static final String process(InputStream input) throws IOException {
        return Processor.process(input, Configuration.DEFAULT);
    }

    public static final String process(InputStream input, boolean safeMode) throws IOException {
        return Processor.process(input, Configuration.builder().setSafeMode(safeMode).build());
    }

    public static final String process(InputStream input, Decorator decorator) throws IOException {
        return Processor.process(input, Configuration.builder().setDecorator(decorator).build());
    }

    public static final String process(InputStream input, Decorator decorator, boolean safeMode) throws IOException {
        return Processor.process(input, Configuration.builder().setDecorator(decorator).setSafeMode(safeMode).build());
    }

    public static final String process(InputStream input, String encoding) throws IOException {
        return Processor.process(input, Configuration.builder().setEncoding(encoding).build());
    }

    public static final String process(InputStream input, String encoding, boolean safeMode) throws IOException {
        return Processor.process(input, Configuration.builder().setEncoding(encoding).setSafeMode(safeMode).build());
    }

    public static final String process(InputStream input, String encoding, Decorator decorator) throws IOException {
        return Processor.process(input, Configuration.builder().setEncoding(encoding).setDecorator(decorator).build());
    }

    public static final String process(InputStream input, String encoding, Decorator decorator, boolean safeMode) throws IOException {
        return Processor.process(input, Configuration.builder().setEncoding(encoding).setDecorator(decorator).setSafeMode(safeMode).build());
    }

    public static final String process(Reader reader) throws IOException {
        return Processor.process(reader, Configuration.DEFAULT);
    }

    public static final String process(Reader reader, boolean safeMode) throws IOException {
        return Processor.process(reader, Configuration.builder().setSafeMode(safeMode).build());
    }

    public static final String process(Reader reader, Decorator decorator) throws IOException {
        return Processor.process(reader, Configuration.builder().setDecorator(decorator).build());
    }

    public static final String process(Reader reader, Decorator decorator, boolean safeMode) throws IOException {
        return Processor.process(reader, Configuration.builder().setDecorator(decorator).setSafeMode(safeMode).build());
    }

    private Block readLines() throws IOException {
        Block block = new Block();
        StringBuilder sb = new StringBuilder(80);
        int c = this.reader.read();
        LinkRef lastLinkRef = null;
        while (c != -1) {
            char ch;
            sb.setLength(0);
            int pos = 0;
            boolean eol = false;
            block7: while (!eol) {
                switch (c) {
                    case -1: {
                        eol = true;
                        continue block7;
                    }
                    case 10: {
                        c = this.reader.read();
                        if (c == 13) {
                            c = this.reader.read();
                        }
                        eol = true;
                        continue block7;
                    }
                    case 13: {
                        c = this.reader.read();
                        if (c == 10) {
                            c = this.reader.read();
                        }
                        eol = true;
                        continue block7;
                    }
                    case 9: {
                        int np = pos + (4 - (pos & 3));
                        while (pos < np) {
                            sb.append(' ');
                            ++pos;
                        }
                        c = this.reader.read();
                        continue block7;
                    }
                }
                if (c != 60 || !this.config.panicMode) {
                    ++pos;
                    sb.append((char)c);
                } else {
                    pos += 4;
                    sb.append("&lt;");
                }
                c = this.reader.read();
            }
            Line line = new Line();
            line.value = sb.toString();
            line.init();
            boolean isLinkRef = false;
            String id = null;
            String link = null;
            String comment = null;
            if (!line.isEmpty && line.leading < 4 && line.value.charAt(line.leading) == '[') {
                line.pos = line.leading + 1;
                id = line.readUntil(']');
                if (id != null && line.pos + 2 < line.value.length() && line.value.charAt(line.pos + 1) == ':') {
                    line.pos += 2;
                    line.skipSpaces();
                    if (line.value.charAt(line.pos) == '<') {
                        ++line.pos;
                        link = line.readUntil('>');
                        ++line.pos;
                    } else {
                        link = line.readUntil(' ', '\n');
                    }
                    if (link != null) {
                        if (line.skipSpaces()) {
                            ch = line.value.charAt(line.pos);
                            if (ch == '\"' || ch == '\'' || ch == '(') {
                                ++line.pos;
                                comment = line.readUntil(ch == '(' ? (char)')' : (char)ch);
                                if (comment != null) {
                                    isLinkRef = true;
                                }
                            }
                        } else {
                            isLinkRef = true;
                        }
                    }
                }
            }
            if (isLinkRef && id != null && link != null) {
                if (id.toLowerCase().equals("$profile$")) {
                    this.emitter.useExtensions = this.useExtensions = link.toLowerCase().equals("extended");
                    lastLinkRef = null;
                    continue;
                }
                LinkRef lr = new LinkRef(link, comment, comment != null && link.length() == 1 && link.charAt(0) == '*');
                this.emitter.addLinkRef(id, lr);
                if (comment != null) continue;
                lastLinkRef = lr;
                continue;
            }
            comment = null;
            if (!line.isEmpty && lastLinkRef != null) {
                line.pos = line.leading;
                ch = line.value.charAt(line.pos);
                if (ch == '\"' || ch == '\'' || ch == '(') {
                    ++line.pos;
                    comment = line.readUntil(ch == '(' ? (char)')' : (char)ch);
                }
                if (comment != null) {
                    lastLinkRef.title = comment;
                }
                lastLinkRef = null;
            }
            if (comment != null) continue;
            line.pos = 0;
            block.appendLine(line);
        }
        return block;
    }

    private void initListBlock(Block root) {
        Line line = root.lines;
        line = line.next;
        while (line != null) {
            LineType t = line.getLineType(this.config);
            if (t == LineType.OLIST || t == LineType.ULIST || !line.isEmpty && line.prevEmpty && line.leading == 0 && t != LineType.OLIST && t != LineType.ULIST) {
                root.split((Line)line.previous).type = BlockType.LIST_ITEM;
            }
            line = line.next;
        }
        root.split((Line)root.lineTail).type = BlockType.LIST_ITEM;
    }

    private void recurse(Block root, boolean listMode) {
        Line line = root.lines;
        if (listMode) {
            root.removeListIndent(this.config);
            if (this.useExtensions && root.lines != null && root.lines.getLineType(this.config) != LineType.CODE) {
                root.id = root.lines.stripID();
            }
        }
        while (line != null && line.isEmpty) {
            line = line.next;
        }
        if (line == null) {
            return;
        }
        block11: while (line != null) {
            LineType type = line.getLineType(this.config);
            switch (type) {
                case OTHER: {
                    BlockType bt;
                    boolean wasEmpty = line.prevEmpty;
                    while (line != null && !line.isEmpty) {
                        LineType t = line.getLineType(this.config);
                        if ((listMode || this.useExtensions) && (t == LineType.OLIST || t == LineType.ULIST) || this.useExtensions && (t == LineType.CODE || t == LineType.FENCED_CODE) || t == LineType.HEADLINE || t == LineType.HEADLINE1 || t == LineType.HEADLINE2 || t == LineType.HR || t == LineType.BQUOTE || t == LineType.XML) break;
                        line = line.next;
                    }
                    if (line != null && !line.isEmpty) {
                        root.split((Line)line.previous).type = bt = listMode && !wasEmpty ? BlockType.NONE : BlockType.PARAGRAPH;
                        root.removeLeadingEmptyLines();
                    } else {
                        bt = listMode && (line == null || !line.isEmpty) && !wasEmpty ? BlockType.NONE : BlockType.PARAGRAPH;
                        root.split((Line)(line == null ? root.lineTail : line)).type = bt;
                        root.removeLeadingEmptyLines();
                    }
                    line = root.lines;
                    continue block11;
                }
                case CODE: {
                    while (line != null && (line.isEmpty || line.leading > 3)) {
                        line = line.next;
                    }
                    Block block = root.split(line != null ? line.previous : root.lineTail);
                    block.type = BlockType.CODE;
                    block.removeSurroundingEmptyLines();
                    continue block11;
                }
                case XML: {
                    if (line.previous != null) {
                        root.split(line.previous);
                    }
                    root.split((Line)line.xmlEndLine).type = BlockType.XML;
                    root.removeLeadingEmptyLines();
                    line = root.lines;
                    continue block11;
                }
                case BQUOTE: {
                    while (line != null && (line.isEmpty || !line.prevEmpty || line.leading != 0 || line.getLineType(this.config) == LineType.BQUOTE)) {
                        line = line.next;
                    }
                    Block block = root.split(line != null ? line.previous : root.lineTail);
                    block.type = BlockType.BLOCKQUOTE;
                    block.removeSurroundingEmptyLines();
                    block.removeBlockQuotePrefix();
                    this.recurse(block, false);
                    line = root.lines;
                    continue block11;
                }
                case HR: {
                    if (line.previous != null) {
                        root.split(line.previous);
                    }
                    root.split((Line)line).type = BlockType.RULER;
                    root.removeLeadingEmptyLines();
                    line = root.lines;
                    continue block11;
                }
                case FENCED_CODE: {
                    line = line.next;
                    while (line != null && line.getLineType(this.config) != LineType.FENCED_CODE) {
                        line = line.next;
                    }
                    if (line != null) {
                        line = line.next;
                    }
                    Block block = root.split(line != null ? line.previous : root.lineTail);
                    block.type = BlockType.FENCED_CODE;
                    block.meta = Utils.getMetaFromFence(block.lines.value);
                    block.lines.setEmpty();
                    if (block.lineTail.getLineType(this.config) == LineType.FENCED_CODE) {
                        block.lineTail.setEmpty();
                    }
                    block.removeSurroundingEmptyLines();
                    continue block11;
                }
                case HEADLINE: 
                case HEADLINE1: 
                case HEADLINE2: {
                    if (line.previous != null) {
                        root.split(line.previous);
                    }
                    if (type != LineType.HEADLINE) {
                        line.next.setEmpty();
                    }
                    Block block = root.split(line);
                    block.type = BlockType.HEADLINE;
                    if (type != LineType.HEADLINE) {
                        int n = block.hlDepth = type == LineType.HEADLINE1 ? 1 : 2;
                    }
                    if (this.useExtensions) {
                        block.id = block.lines.stripID();
                    }
                    block.transfromHeadline();
                    root.removeLeadingEmptyLines();
                    line = root.lines;
                    continue block11;
                }
                case OLIST: 
                case ULIST: {
                    while (line != null) {
                        LineType t = line.getLineType(this.config);
                        if (!line.isEmpty && line.prevEmpty && line.leading == 0 && t != LineType.OLIST && t != LineType.ULIST) break;
                        line = line.next;
                    }
                    Block list = root.split(line != null ? line.previous : root.lineTail);
                    list.type = type == LineType.OLIST ? BlockType.ORDERED_LIST : BlockType.UNORDERED_LIST;
                    list.lines.prevEmpty = false;
                    list.lineTail.nextEmpty = false;
                    list.removeSurroundingEmptyLines();
                    list.lineTail.nextEmpty = false;
                    list.lines.prevEmpty = false;
                    this.initListBlock(list);
                    Block block = list.blocks;
                    while (block != null) {
                        this.recurse(block, true);
                        block = block.next;
                    }
                    list.expandListParagraphs();
                    continue block11;
                }
            }
            line = line.next;
        }
    }

    private String process() throws IOException {
        StringBuilder out = new StringBuilder();
        Block parent = this.readLines();
        parent.removeSurroundingEmptyLines();
        this.recurse(parent, false);
        Block block = parent.blocks;
        while (block != null) {
            this.emitter.emit(out, block);
            block = block.next;
        }
        return out.toString();
    }
}

