/*
 * Decompiled with CFR 0.152.
 */
package gololang;

import gololang.IO;
import gololang.ir.GoloModule;
import java.io.InputStream;
import java.net.URL;
import java.util.Objects;
import org.eclipse.golo.cli.command.Metadata;
import org.eclipse.golo.cli.command.spi.CliCommand;
import org.eclipse.golo.compiler.GoloClassLoader;

public final class Runtime {
    private static boolean debug = Runtime.loadBoolean("golo.debug", "GOLO_DEBUG", false);
    private static boolean showStackTrace = Runtime.loadBoolean("golo.debug.trace", "GOLO_DEBUG_TRACE", true);
    private static CliCommand command;

    private Runtime() {
    }

    public static boolean loadBoolean(String prop, String env, boolean defaultValue) {
        return Runtime.loadBoolean("true", prop, env, defaultValue);
    }

    public static boolean loadBoolean(String value, String prop, String env, boolean defaultValue) {
        String val = null;
        if (prop != null) {
            val = System.getProperty(prop);
        }
        if (val == null && env != null) {
            val = System.getenv(env);
        }
        if (val == null) {
            return defaultValue;
        }
        return val.toLowerCase().equals(value.toLowerCase());
    }

    public static boolean debugMode() {
        return debug;
    }

    public static void debugMode(boolean v) {
        debug = v;
    }

    public static boolean showStackTrace() {
        return showStackTrace;
    }

    public static void showStackTrace(boolean v) {
        showStackTrace = v;
    }

    public static void command(CliCommand cmd) {
        command = Objects.requireNonNull(cmd);
    }

    public static CliCommand command() {
        return command;
    }

    public static GoloClassLoader classLoader() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl instanceof GoloClassLoader) {
            return (GoloClassLoader)cl;
        }
        return new GoloClassLoader(cl);
    }

    public static Class<?> load(Object module) throws Exception {
        return Runtime.load(module, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Class<?> load(Object module, boolean failOnException) throws Exception {
        try {
            if (module instanceof GoloModule) {
                GoloModule mod = (GoloModule)module;
                return Runtime.classLoader().load(mod.sourceFile(), mod);
            }
            URL url = IO.toURL(module);
            try (InputStream is = url.openStream();){
                Class<?> clazz = Runtime.classLoader().load(module.toString(), is);
                return clazz;
            }
        }
        catch (Exception e) {
            if (!failOnException) return null;
            throw e;
        }
    }

    public static String version() {
        return Metadata.VERSION;
    }
}

