/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.golo.cli.command;

import com.beust.jcommander.IParameterValidator;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.ParametersDelegate;
import gololang.Messages;
import gololang.ir.GoloModule;
import gololang.ir.IrTreeDumper;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.golo.cli.command.ClasspathOption;
import org.eclipse.golo.cli.command.spi.CliCommand;
import org.eclipse.golo.compiler.GoloCompilationException;
import org.eclipse.golo.compiler.GoloCompiler;
import org.eclipse.golo.compiler.parser.ASTCompilationUnit;

@Parameters(commandNames={"diagnose"}, resourceBundle="commands", commandDescriptionKey="diagnose")
public class DiagnoseCommand
implements CliCommand {
    @Parameter(names={"--tool"}, hidden=true, descriptionKey="diagnose.tool", validateWith=DiagnoseModeValidator.class)
    String mode = "ir";
    @Parameter(names={"--stage"}, descriptionKey="diagnose.stage", validateWith=DiagnoseStageValidator.class)
    String stage = "refined";
    @Parameter(description="source_files")
    List<String> files = new LinkedList<String>();
    @ParametersDelegate
    ClasspathOption classpath = new ClasspathOption();
    GoloCompiler compiler;

    @Override
    public void execute() throws Throwable {
        if ("ast".equals(this.stage) && !"ast".equals(this.mode)) {
            this.mode = "ast";
        }
        if ("ast".equals(this.mode) && !"ast".equals(this.stage)) {
            this.stage = "ast";
        }
        this.compiler = this.classpath.initGoloClassLoader().getCompiler();
        try {
            switch (this.mode) {
                case "ast": {
                    this.dumpASTs(this.files);
                    break;
                }
                case "ir": {
                    this.dumpIRs(this.files);
                    break;
                }
                default: {
                    throw new AssertionError((Object)"WTF?");
                }
            }
        }
        catch (GoloCompilationException e) {
            this.handleCompilationException(e);
        }
    }

    private void dumpASTs(List<String> files) {
        for (String file : files) {
            this.dumpAST(file);
        }
    }

    private void dumpAST(String goloFile) {
        block4: {
            File file;
            block3: {
                file = new File(goloFile);
                if (!file.isDirectory()) break block3;
                File[] directoryFiles = file.listFiles();
                if (directoryFiles == null) break block4;
                for (File directoryFile : directoryFiles) {
                    this.dumpAST(directoryFile.getAbsolutePath());
                }
                break block4;
            }
            if (!file.getName().endsWith(".golo")) break block4;
            System.out.println(">>> AST: " + goloFile);
            try {
                ASTCompilationUnit ast = this.compiler.parse(goloFile);
                ast.dump("% ");
                System.out.println();
            }
            catch (IOException e) {
                Messages.error(Messages.message("file_not_found", goloFile));
            }
        }
    }

    private void dumpIRs(List<String> files) {
        IrTreeDumper dumper = new IrTreeDumper();
        for (String file : files) {
            this.dumpIR(file, dumper);
        }
    }

    private void dumpIR(String goloFile, IrTreeDumper dumper) {
        File file = new File(goloFile);
        if (file.isDirectory()) {
            File[] directoryFiles = file.listFiles();
            if (directoryFiles != null) {
                for (File directoryFile : directoryFiles) {
                    this.dumpIR(directoryFile.getAbsolutePath(), dumper);
                }
            }
        } else if (file.getName().endsWith(".golo")) {
            System.out.println(">>> IR: " + file);
            try {
                GoloModule module = this.compiler.transform(this.compiler.parse(goloFile));
                switch (this.stage) {
                    case "raw": {
                        break;
                    }
                    case "refined": {
                        this.compiler.refine(module);
                        break;
                    }
                }
                module.accept(dumper);
            }
            catch (IOException e) {
                Messages.error(Messages.message("file_not_found", goloFile));
            }
            System.out.println();
        }
    }

    public static final class DiagnoseStageValidator
    implements IParameterValidator {
        public void validate(String name, String value) throws ParameterException {
            switch (value) {
                case "ast": 
                case "raw": 
                case "refined": {
                    return;
                }
            }
            throw new ParameterException(Messages.message("diagnose_stage_error", "{ast, raw, refined}"));
        }
    }

    public static final class DiagnoseModeValidator
    implements IParameterValidator {
        public void validate(String name, String value) throws ParameterException {
            Messages.warning(Messages.message("diagnose_tool_warning"));
            switch (value) {
                case "ast": 
                case "ir": {
                    return;
                }
            }
            throw new ParameterException(Messages.message("diagnose_tool_error", "{ast, ir}"));
        }
    }
}

