/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.golo.cli.command;

import com.beust.jcommander.IParameterValidator;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.ParametersDelegate;
import gololang.Messages;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.eclipse.golo.cli.command.ClasspathOption;
import org.eclipse.golo.cli.command.spi.CliCommand;
import org.eclipse.golo.compiler.GoloCompilationException;
import org.eclipse.golo.compiler.GoloCompiler;
import org.eclipse.golo.doc.AbstractProcessor;
import org.eclipse.golo.doc.CtagsProcessor;
import org.eclipse.golo.doc.HtmlProcessor;
import org.eclipse.golo.doc.MarkdownProcessor;
import org.eclipse.golo.doc.ModuleDocumentation;

@Parameters(commandNames={"doc"}, commandDescriptionKey="doc", resourceBundle="commands")
public class DocCommand
implements CliCommand {
    @Parameter(names={"--format"}, descriptionKey="doc.format", validateWith=DocFormatValidator.class)
    String format = "html";
    @Parameter(names={"--output"}, descriptionKey="doc.output")
    String output = ".";
    @Parameter(descriptionKey="source_files")
    List<String> sources = new LinkedList<String>();
    @ParametersDelegate
    ClasspathOption classpath = new ClasspathOption();
    private static final Map<String, Supplier<? extends AbstractProcessor>> FORMATS = new HashMap<String, Supplier<? extends AbstractProcessor>>();
    private GoloCompiler compiler;

    @Override
    public void execute() throws Throwable {
        this.compiler = this.classpath.initGoloClassLoader().getCompiler();
        AbstractProcessor processor = FORMATS.get(this.format).get();
        HashSet<ModuleDocumentation> modules = new HashSet<ModuleDocumentation>();
        for (String source : this.sources) {
            this.loadGoloFile(source, modules);
        }
        try {
            processor.process(modules, Paths.get(this.output, new String[0]));
        }
        catch (Throwable throwable) {
            this.handleThrowable(throwable);
        }
    }

    private void loadGoloFile(String goloFile, HashSet<ModuleDocumentation> modules) {
        block6: {
            File file;
            block5: {
                file = new File(goloFile);
                if (!file.isDirectory()) break block5;
                File[] directoryFiles = file.listFiles();
                if (directoryFiles == null) break block6;
                for (File directoryFile : directoryFiles) {
                    this.loadGoloFile(directoryFile.getAbsolutePath(), modules);
                }
                break block6;
            }
            if (!file.getName().endsWith(".golo")) break block6;
            try {
                modules.add(ModuleDocumentation.load(goloFile, this.compiler));
            }
            catch (IOException e) {
                Messages.error(Messages.message("file_not_found", goloFile));
                return;
            }
            catch (GoloCompilationException e) {
                this.handleCompilationException(e);
            }
            catch (Throwable t) {
                this.handleThrowable(t);
            }
        }
    }

    static {
        FORMATS.put("markdown", MarkdownProcessor::new);
        FORMATS.put("html", HtmlProcessor::new);
        FORMATS.put("ctags", CtagsProcessor::new);
    }

    public static class DocFormatValidator
    implements IParameterValidator {
        public void validate(String name, String value) throws ParameterException {
            if (!FORMATS.keySet().contains(value)) {
                throw new ParameterException(Messages.message("format_error", FORMATS.keySet()));
            }
        }
    }
}

